/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.tile;

import com.github.se7_kn8.gates.GatesBlocks;
import com.github.se7_kn8.gates.block.redstone_clock.RedstoneClock;
import com.github.se7_kn8.gates.container.AdvancedRedstoneClockContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RedstoneClockTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int MIN_CLOCK_TIME = 2;
    public static final int MAX_CLOCK_TIME = 72000;
    public static final int MIN_CLOCK_LENGTH = 1;
    public static final int MAX_CLOCK_LENGTH = 71000;
    private int clockLength = 6;
    private int clockTime = 12;
    private int remainingTicks = 0;
    private int poweredTicks = 0;

    public RedstoneClockTileEntity() {
        super(GatesBlocks.REDSTONE_CLOCK_TILE_ENTITY_TYPE);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.remainingTicks = compound.func_74762_e("remaining");
        this.poweredTicks = compound.func_74762_e("powered");
        this.clockLength = compound.func_74762_e("clockLength");
        this.clockTime = compound.func_74762_e("clockTime");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("remaining", this.remainingTicks);
        compound.func_74768_a("powered", this.poweredTicks);
        compound.func_74768_a("clockLength", this.clockLength);
        compound.func_74768_a("clockTime", this.clockTime);
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.remainingTicks <= 0) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)RedstoneClock.POWERED, (Comparable)Boolean.valueOf(true)));
                this.poweredTicks = this.clockLength;
                this.remainingTicks = this.clockTime;
            } else {
                --this.remainingTicks;
            }
            if (this.poweredTicks <= 0) {
                if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)RedstoneClock.POWERED)).booleanValue()) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)RedstoneClock.POWERED, (Comparable)Boolean.valueOf(false)));
                }
            } else {
                --this.poweredTicks;
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.gates.advanced_redstone_clock");
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new AdvancedRedstoneClockContainer(windowId, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    public int getClockLength() {
        return this.clockLength;
    }

    public int getClockTime() {
        return this.clockTime;
    }

    public void setClockLength(int clockLength) {
        if (clockLength < 1) {
            clockLength = 1;
        } else if (clockLength > 71000) {
            clockLength = 71000;
        }
        this.clockLength = clockLength;
        this.checkLengthTimeRelation();
    }

    public void setClockTime(int clockTime) {
        if (clockTime < 2) {
            clockTime = 2;
        } else if (clockTime > 72000) {
            clockTime = 72000;
        }
        this.clockTime = clockTime;
        this.checkLengthTimeRelation();
    }

    public void resetClock() {
        this.poweredTicks = 0;
        this.remainingTicks = 0;
    }

    private void checkLengthTimeRelation() {
        if (this.clockLength >= this.clockTime) {
            this.clockLength = this.clockTime - 1;
        }
    }
}

