/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.api;

import com.github.se7_kn8.gates.api.IWirelessNode;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityWirelessNode {
    @CapabilityInject(value=IWirelessNode.class)
    public static Capability<IWirelessNode> WIRELESS_NODE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IWirelessNode.class, (Capability.IStorage)new Capability.IStorage<IWirelessNode>(){

            @Nullable
            public INBT writeNBT(Capability<IWirelessNode> capability, IWirelessNode instance, Direction side) {
                return ((WirelessNodeImpl)instance).serializeNBT();
            }

            public void readNBT(Capability<IWirelessNode> capability, IWirelessNode instance, Direction side, INBT nbt) {
                ((WirelessNodeImpl)instance).deserializeNBT((CompoundNBT)nbt);
            }
        }, () -> new WirelessNodeImpl(0, IWirelessNode.Types.NOOP));
    }

    public static class WirelessNodeImpl
    implements IWirelessNode,
    INBTSerializable<CompoundNBT> {
        int frequency;
        int power;
        IWirelessNode.Types type;

        public WirelessNodeImpl(int frequency, IWirelessNode.Types type) {
            this.frequency = frequency;
            this.type = type;
        }

        @Override
        public void setFrequency(int newFrequency) {
            this.frequency = newFrequency;
        }

        @Override
        public int getFrequency() {
            return this.frequency;
        }

        @Override
        public void setPower(int newPower) {
            this.power = newPower;
        }

        @Override
        public int getPower() {
            return this.power;
        }

        @Override
        public IWirelessNode.Types getType() {
            return this.type;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("frequency", this.frequency);
            nbt.func_74768_a("power", this.power);
            nbt.func_74778_a("type", this.type.name());
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.frequency = nbt.func_74762_e("frequency");
            this.power = nbt.func_74762_e("power");
            String typeString = nbt.func_74779_i("type");
            this.type = !typeString.equals("") ? IWirelessNode.Types.valueOf(typeString) : IWirelessNode.Types.NOOP;
        }
    }
}

