/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.client.screen;

import com.github.se7_kn8.gates.PacketHandler;
import com.github.se7_kn8.gates.container.FrequencyContainer;
import com.github.se7_kn8.gates.packages.UpdateFrequencyPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FrequencyScreen
extends ContainerScreen<FrequencyContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("gates", "textures/gui/container/empty_container.png");
    private TextFieldWidget frequencyField;
    private Button applyButton;
    private Button decreaseButton;
    private Button increaseButton;
    private int lastValue;

    public FrequencyScreen(FrequencyContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    protected void init() {
        super.init();
        this.frequencyField = new TextFieldWidget(this.font, this.width / 2 - 35, this.height / 2 - 50, 70, 20, I18n.func_135052_a((String)"gates.gui.transmitter", (Object[])new Object[0]));
        this.frequencyField.func_200675_a(s -> (s.matches("^[0-9]+$") || s.equals("")) && s.length() < 10);
        this.decreaseButton = (Button)this.addButton((Widget)new Button(this.width / 2 - 75, this.height / 2 - 50, 40, 20, "<-", p_onPress_1_ -> PacketHandler.MOD_CHANNEL.sendToServer((Object)new UpdateFrequencyPacket(((FrequencyContainer)this.func_212873_a_()).entity.func_174877_v(), ((FrequencyContainer)this.func_212873_a_()).getFrequency() - 1))));
        this.increaseButton = (Button)this.addButton((Widget)new Button(this.width / 2 + 35, this.height / 2 - 50, 40, 20, "->", p_onPress_1_ -> PacketHandler.MOD_CHANNEL.sendToServer((Object)new UpdateFrequencyPacket(((FrequencyContainer)this.func_212873_a_()).entity.func_174877_v(), ((FrequencyContainer)this.func_212873_a_()).getFrequency() + 1))));
        this.applyButton = (Button)this.addButton((Widget)new Button(this.width / 2, this.height / 2 - 25, 80, 20, I18n.func_135052_a((String)"gui.gates.apply", (Object[])new Object[0]), p_onPress_1_ -> PacketHandler.MOD_CHANNEL.sendToServer((Object)new UpdateFrequencyPacket(((FrequencyContainer)this.func_212873_a_()).entity.func_174877_v(), Integer.parseInt(this.frequencyField.func_146179_b())))));
        this.children.add(this.frequencyField);
        this.func_212928_a((IGuiEventListener)this.frequencyField);
        this.applyButton.visible = false;
    }

    public void tick() {
        this.frequencyField.func_146178_a();
        int freq = ((FrequencyContainer)this.func_212873_a_()).getFrequency();
        if (freq != this.lastValue) {
            this.lastValue = freq;
            this.frequencyField.func_146180_a(String.valueOf(freq));
        } else {
            try {
                this.applyButton.visible = freq != Integer.parseInt(this.frequencyField.func_146179_b());
            }
            catch (NumberFormatException e) {
                this.applyButton.visible = false;
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.frequencyField.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 4.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
        this.font.func_211126_b(new TranslationTextComponent("gui.gates.frequency", new Object[0]).func_150254_d(), 40.0f, 20.0f, 0x404040);
    }
}

