/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.data;

import com.github.se7_kn8.gates.api.CapabilityUtil;
import com.github.se7_kn8.gates.api.CapabilityWirelessNode;
import com.github.se7_kn8.gates.api.IWirelessNode;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.NonNullConsumer;

public class RedstoneReceiverWorldSavedData
extends WorldSavedData {
    public static final String DATA_NAME = "gates_wireless_network";
    private Set<BlockPos> receivers = new HashSet<BlockPos>();
    private Set<BlockPos> transmitters = new HashSet<BlockPos>();

    public RedstoneReceiverWorldSavedData() {
        super(DATA_NAME);
    }

    public RedstoneReceiverWorldSavedData(String s) {
        super(s);
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.receivers = this.loadBlockPosSet(nbt, "receivers");
        this.transmitters = this.loadBlockPosSet(nbt, "transmitters");
    }

    public Set<BlockPos> loadBlockPosSet(CompoundNBT compound, String name) {
        ListNBT list = compound.func_150295_c(name, 10);
        HashSet<BlockPos> pos = new HashSet<BlockPos>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT entry = (CompoundNBT)list.get(i);
            int x = entry.func_74762_e("x");
            int y = entry.func_74762_e("y");
            int z = entry.func_74762_e("z");
            pos.add(new BlockPos(x, y, z));
        }
        return pos;
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        this.saveBlockPosSet(this.receivers, compound, "receivers");
        this.saveBlockPosSet(this.transmitters, compound, "transmitters");
        return compound;
    }

    public void saveBlockPosSet(Set<BlockPos> set, CompoundNBT compound, String name) {
        ListNBT list = new ListNBT();
        for (BlockPos pos : set) {
            CompoundNBT entry = new CompoundNBT();
            entry.func_74768_a("x", pos.func_177958_n());
            entry.func_74768_a("y", pos.func_177956_o());
            entry.func_74768_a("z", pos.func_177952_p());
            list.add((Object)entry);
        }
        compound.func_218657_a(name, (INBT)list);
    }

    public int getCurrentFrequencyValue(World world, int frequency) {
        return this.transmitters.stream().map(pos -> (IWirelessNode)world.func_175625_s(pos).getCapability(CapabilityWirelessNode.WIRELESS_NODE).orElseThrow(IllegalStateException::new)).filter(node -> node.getFrequency() == frequency).map(IWirelessNode::getPower).max(Integer::compareTo).orElse(0);
    }

    public void updateFrequency(World world, int frequency) {
        int power = this.getCurrentFrequencyValue(world, frequency);
        this.updateFrequency(world, frequency, power);
    }

    public void updateFrequency(World world, int frequency, int power) {
        HashSet<BlockPos> receiversCopy = new HashSet<BlockPos>(this.receivers);
        receiversCopy.stream().map(pos -> (IWirelessNode)world.func_175625_s(pos).getCapability(CapabilityWirelessNode.WIRELESS_NODE).orElseThrow(IllegalStateException::new)).filter(node -> node.getFrequency() == frequency).forEach(node -> node.setPower(power));
    }

    public void addNode(World world, BlockPos pos) {
        CapabilityUtil.findWirelessCapability(world, pos, (NonNullConsumer<IWirelessNode>)((NonNullConsumer)c -> {
            switch (c.getType()) {
                case RECEIVER: {
                    c.setPower(this.getCurrentFrequencyValue(world, c.getFrequency()));
                    this.addReceiver(pos);
                    break;
                }
                case TRANSMITTER: {
                    this.addTransmitter(pos);
                }
            }
        }));
    }

    public void removeNode(World world, BlockPos pos) {
        CapabilityUtil.findWirelessCapability(world, pos, (NonNullConsumer<IWirelessNode>)((NonNullConsumer)c -> {
            switch (c.getType()) {
                case RECEIVER: {
                    this.removeReceiver(pos);
                    break;
                }
                case TRANSMITTER: {
                    this.removeTransmitter(pos);
                }
            }
        }));
    }

    private void addReceiver(BlockPos pos) {
        if (this.receivers.add(pos)) {
            this.func_76186_a(true);
        }
    }

    private void removeReceiver(BlockPos pos) {
        if (this.receivers.remove(pos)) {
            this.func_76186_a(true);
        }
    }

    private void addTransmitter(BlockPos pos) {
        if (this.transmitters.add(pos)) {
            this.func_76186_a(true);
        }
    }

    private void removeTransmitter(BlockPos pos) {
        if (this.transmitters.remove(pos)) {
            this.func_76186_a(true);
        }
    }

    @Nonnull
    public static RedstoneReceiverWorldSavedData get(ServerWorld world) {
        return (RedstoneReceiverWorldSavedData)world.func_217481_x().func_215752_a(RedstoneReceiverWorldSavedData::new, DATA_NAME);
    }
}

