/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.packages;

import com.github.se7_kn8.gates.api.CapabilityUtil;
import com.github.se7_kn8.gates.api.IWirelessNode;
import com.github.se7_kn8.gates.packages.BasePacket;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateFrequencyPacket
implements BasePacket {
    private final BlockPos pos;
    private final int frequency;

    public UpdateFrequencyPacket(BlockPos pos, int frequency) {
        this.pos = pos;
        this.frequency = frequency;
    }

    public UpdateFrequencyPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.frequency = buffer.readInt();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeInt(this.frequency);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
            if (!world.field_72995_K) {
                CapabilityUtil.findWirelessCapability(world, this.pos, (NonNullConsumer<IWirelessNode>)((NonNullConsumer)c -> {
                    int newFrequency = this.frequency;
                    if (newFrequency < c.getMinFrequency()) {
                        newFrequency = c.getMinFrequency();
                    }
                    if (newFrequency > c.getMaxFrequency()) {
                        newFrequency = c.getMaxFrequency();
                    }
                    c.setFrequency(newFrequency);
                }));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

