/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.growthcontrols.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.lothrazar.growthcontrols.ModGrowthCtrl;
import com.lothrazar.growthcontrols.UtilString;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final String DELIM = "->";
    private static ForgeConfigSpec.BooleanValue dropFailedGrowth;
    public static ForgeConfigSpec.ConfigValue<List<String>> SAPLING_BIOMES;
    public static ForgeConfigSpec.ConfigValue<List<String>> CROP_BIOMES;
    public static ForgeConfigSpec COMMON_CONFIG;

    public ConfigHandler(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public boolean getdropFailedGrowth() {
        return (Boolean)dropFailedGrowth.get();
    }

    public void getEmptyBiomes() {
        ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
        ArrayList<String> valid = new ArrayList<String>();
        for (Biome b : ForgeRegistries.BIOMES) {
            List<String> has = this.getGrowthsForBiome(b);
            if (has != null && !has.isEmpty()) continue;
            valid.add(b.getRegistryName().toString());
        }
        String lst = String.join((CharSequence)", ", valid);
        if (valid.size() == 0) {
            lst = "none";
        }
        UtilString.chatMessage((PlayerEntity)p, "Barren: " + lst);
    }

    private static void initConfig() {
        COMMON_BUILDER.comment("General settings").push("growthcontrols");
        dropFailedGrowth = COMMON_BUILDER.comment("Drop sapling item on failed growth").define("dropOnFailedGrow", true);
        ArrayList<String> configstuff = new ArrayList<String>();
        configstuff.add(Blocks.field_196679_x.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:savanna", "minecraft:shattered_savanna", "minecraft:shattered_savanna_plateau", "minecraft:savanna_plateau", "minecraft:modified_wooded_badlands_plateau", "minecraft:wooded_badlands_plateau"));
        configstuff.add(Blocks.field_196676_v.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:birch_forest", "minecraft:forest", "minecraft:birch_forest_hills", "minecraft:tall_birch_forest", "minecraft:tall_birch_hills"));
        configstuff.add(Blocks.field_196675_u.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:taiga", "minecraft:giant_tree_taiga", "minecraft:snowy_tundra", "minecraft:taiga_hills", "minecraft:snowy_taiga", "minecraft:snowy_taiga_hills", "minecraft:giant_tree_taiga_hills"));
        configstuff.add(Blocks.field_196674_t.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:forest", "minecraft:dark_forest", "minecraft:wooded_mountains", "minecraft:wooded_hills", "minecraft:swamp", "minecraft:swamp_hills", "minecraft:flower_forest"));
        configstuff.add(Blocks.field_196680_y.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:dark_forest", "minecraft:dark_forest_hills", "minecraft:flower_forest"));
        configstuff.add(Blocks.field_196678_w.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:jungle_edge", "minecraft:jungle", "minecraft:jungle_hills", "minecraft:modified_jungle", "minecraft:bamboo_jungle", "minecraft:bamboo_jungle_hills", "minecraft:modified_jungle_edge", "minecraft:modified_jungle"));
        SAPLING_BIOMES = COMMON_BUILDER.comment("Map growable block to CSV list of biomes no spaces, -> in between.  It SHOULD be fine to add modded saplings. An empty list means the sapling can gro nowhere.  Delete the key-entry for a sapling to let it grow everywhere.").define("SaplingBlockToBiome", configstuff);
        configstuff = new ArrayList();
        configstuff.add(Blocks.field_150464_aj.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:plains", "minecraft:swamp", "minecraft:beach"));
        configstuff.add(Blocks.field_150459_bM.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:taiga", "minecraft:savanna", "minecraft:savanna*", "minecraft:*savanna", "minecraft:shattered_savanna_plateau", "minecraft:sunflower_plains", "minecraft:giant_tree_taiga_hills"));
        configstuff.add(Blocks.field_150469_bN.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:taiga", "minecraft:snowy*", "minecraft:taiga*", "minecraft:*forest", "minecraft:dark_forest_hills", "minecraft:*taiga", "minecraft:*mountains", "minecraft:giant_tree_taiga_hills", "minecraft:mountain_edge"));
        configstuff.add(Blocks.field_185773_cZ.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:taiga", "minecraft:forest", "minecraft:swamp", "minecraft:flower_forest", "minecraft:birch_forest", "minecraft:birch*", "minecraft:tall_birch_forest", "minecraft:tall_birch_hills", "minecraft:dark_forest", "minecraft:dark_forest_hills"));
        CharSequence[] cactua = new String[]{"minecraft:desert", "minecraft:desert_hills", "minecraft:desert_lakes", "minecraft:badlands", "minecraft:badlands*", "minecraft:*badlands"};
        configstuff.add(Blocks.field_150434_aF.getRegistryName().toString() + DELIM + String.join((CharSequence)",", cactua));
        CharSequence[] reeds = new String[]{"minecraft:desert_lakes", "minecraft:stone_shore", "minecraft:ocean", "minecraft:river", "minecraft:beach", "minecraft:deep_ocean", "minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_warm_ocean", "minecraft:deep_lukewarm_ocean"};
        configstuff.add(Blocks.field_196608_cF.getRegistryName().toString() + DELIM + String.join((CharSequence)",", reeds));
        CharSequence[] purpur = new String[]{"minecraft:small_end_islands", "minecraft:end*", "minecraft:the_end", "minecraft:the_void"};
        configstuff.add(Blocks.field_185766_cS.getRegistryName().toString() + DELIM + String.join((CharSequence)",", purpur));
        configstuff.add(Blocks.field_185765_cR.getRegistryName().toString() + DELIM + String.join((CharSequence)",", purpur));
        CharSequence[] mushrooms = new String[]{"minecraft:mushroom*", "minecraft:nether", "minecraft:roofed_forest*"};
        configstuff.add(Blocks.field_150338_P.getRegistryName().toString() + DELIM + String.join((CharSequence)",", mushrooms));
        configstuff.add(Blocks.field_150337_Q.getRegistryName().toString() + DELIM + String.join((CharSequence)",", mushrooms));
        configstuff.add(Blocks.field_150375_by.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:jungle_edge", "minecraft:jungle", "minecraft:jungle_hills", "minecraft:modified_jungle", "minecraft:bamboo_jungle", "minecraft:bamboo_jungle_hills", "minecraft:modified_jungle_edge", "minecraft:modified_jungle"));
        configstuff.add(Blocks.field_150394_bc.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:ocean", "minecraft:river", "minecraft:beach", "minecraft:deep_ocean", "minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_warm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:jungle", "minecraft:jungle*", "minecraft:*jungle", "minecraft:bamboo_jungle", "minecraft:bamboo_jungle_hills", "minecraft:modified_jungle_edge", "minecraft:modified_jungle"));
        configstuff.add(Blocks.field_150393_bb.getRegistryName().toString() + DELIM + String.join((CharSequence)",", "minecraft:extreme*", "minecraft:taiga", "minecraft:snowy*", "minecraft:taiga*", "minecraft:dark_forest_hills", "minecraft:*taiga", "minecraft:giant_tree_taiga_hills"));
        CROP_BIOMES = COMMON_BUILDER.comment("Map growable block to CSV list of biomes no spaces, -> in between.  It SHOULD be fine to add modded blocks. An empty list means the crop can gro nowhere.  Delete the key-entry for a crop to let it grow everywhere.").define("CropBlockToBiome", configstuff);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public Map<String, List<String>> getMapBiome(ForgeConfigSpec.ConfigValue<List<String>> conf) {
        HashMap<String, List<String>> mapInit = new HashMap<String, List<String>>();
        for (String splitme : (List)conf.get()) {
            try {
                String[] split = splitme.split(DELIM);
                String blockId = split[0];
                String[] biomes = split[1].split(",");
                mapInit.put(blockId, Arrays.asList(biomes));
            }
            catch (Exception e) {
                ModGrowthCtrl.LOGGER.error("Error reading bad config value :" + splitme, (Throwable)e);
            }
        }
        return mapInit;
    }

    public List<String> getBiomesCombined(Block block) {
        List<String> found = this.getBiomesForCrop(block);
        List<String> saplings = this.getBiomesForSapling(block);
        if (found == null) {
            found = new ArrayList<String>();
        }
        if (saplings == null) {
            saplings = new ArrayList<String>();
        }
        found.addAll(saplings);
        return found;
    }

    public List<String> getBiomesCombinedAllowNull(Block block) {
        List<String> found = this.getBiomesForCrop(block);
        List<String> saplings = this.getBiomesForSapling(block);
        if (found == null) {
            return saplings;
        }
        if (saplings != null) {
            found.addAll(saplings);
        }
        return found;
    }

    public List<String> getBiomesForCrop(Block block) {
        String key;
        Map<String, List<String>> mapInit = this.getMapBiome(CROP_BIOMES);
        if (!mapInit.containsKey(key = block.getRegistryName().toString())) {
            return null;
        }
        return mapInit.get(key);
    }

    public List<String> getBiomesForSapling(Block block) {
        String key;
        Map<String, List<String>> mapInit = this.getMapBiome(SAPLING_BIOMES);
        if (!mapInit.containsKey(key = block.getRegistryName().toString())) {
            return null;
        }
        return mapInit.get(key);
    }

    public List<String> getGrowthsForBiome(Biome biome) {
        List<String> biomes;
        String block;
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this.getMapBiome(CROP_BIOMES).entrySet()) {
            block = entry.getKey();
            biomes = entry.getValue();
            if (!UtilString.isInList(biomes, biome.getRegistryName())) continue;
            result.add(block);
        }
        for (Map.Entry<String, List<String>> entry : this.getMapBiome(SAPLING_BIOMES).entrySet()) {
            block = entry.getKey();
            biomes = entry.getValue();
            if (!UtilString.isInList(biomes, biome.getRegistryName())) continue;
            result.add(block);
        }
        return result;
    }

    static {
        ConfigHandler.initConfig();
    }
}

