/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.growthcontrols;

import com.lothrazar.growthcontrols.ModGrowthCtrl;
import com.lothrazar.growthcontrols.UtilString;
import com.lothrazar.growthcontrols.item.ItemGrow;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GrowEvents {
    @SubscribeEvent
    public void onCropGrowEvent(BlockEvent.CropGrowEvent.Pre event) {
        BlockPos pos;
        IWorld world = event.getWorld();
        if (world.func_175623_d(pos = event.getPos())) {
            Block blockBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (blockBelow == Blocks.field_150434_aF || blockBelow == Blocks.field_185766_cS) {
                pos = pos.func_177977_b();
            } else {
                return;
            }
        }
        Block b = world.func_180495_p(pos).func_177230_c();
        Biome biome = ItemGrow.getBiome(world, pos);
        List<String> allowed = ModGrowthCtrl.config.getBiomesForCrop(b);
        if (allowed == null) {
            return;
        }
        boolean allowedToGrow = UtilString.isInList(allowed, biome.getRegistryName());
        if (!allowedToGrow) {
            event.setResult(Event.Result.DENY);
            this.onGrowCancel(world, pos, biome);
        }
    }

    @SubscribeEvent
    public void onSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        IWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        Block b = world.func_180495_p(pos).func_177230_c();
        Biome biome = ItemGrow.getBiome(world, pos);
        String biomeId = biome.getRegistryName().toString();
        List<String> allowed = ModGrowthCtrl.config.getBiomesForSapling(b);
        if (allowed == null) {
            return;
        }
        boolean treeAllowedToGrow = UtilString.isInList(allowed, biome.getRegistryName());
        if (!treeAllowedToGrow) {
            event.setResult(Event.Result.DENY);
            if (ModGrowthCtrl.config.getdropFailedGrowth()) {
                this.onGrowCancel(world, pos, biome);
            }
            world.func_180501_a(pos, Blocks.field_196555_aI.func_176223_P(), 3);
        }
    }

    @SubscribeEvent
    public void onBone(BonemealEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Block b = world.func_180495_p(pos).func_177230_c();
        Biome biome = ItemGrow.getBiome((IWorld)world, pos);
        List<String> crops = ModGrowthCtrl.config.getBiomesCombinedAllowNull(b);
        if (crops == null) {
            return;
        }
        boolean allowedCrop = UtilString.isInList(crops, biome.getRegistryName());
        if (!allowedCrop) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            this.doSmoke((IWorld)world, pos);
        }
    }

    private void onGrowCancel(IWorld world, BlockPos pos, Biome biome) {
        world.func_175655_b(pos, true);
        this.doSmoke(world, pos);
    }

    private void doSmoke(IWorld world, BlockPos pos) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() + 0.5;
        double ySpeed = 0.2;
        for (int i = 0; i < 20; ++i) {
            world.func_195594_a((IParticleData)ParticleTypes.field_203217_T, x, y, z, 0.0, ySpeed, 0.0);
        }
    }
}

