/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.growthcontrols.item;

import com.lothrazar.growthcontrols.ModGrowthCtrl;
import com.lothrazar.growthcontrols.UtilString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemGrow
extends Item {
    public ItemGrow(Item.Properties p) {
        super(p.func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K && playerIn.func_213453_ef()) {
            ModGrowthCtrl.config.getEmptyBiomes();
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static Biome getBiome(IWorld world, BlockPos pos) {
        return world.func_225523_d_().func_226836_a_(pos);
    }

    public ActionResultType func_195939_a(ItemUseContext c) {
        if (c.func_195991_k().field_72995_K) {
            BlockState block = c.func_195991_k().func_180495_p(c.func_195995_a());
            List<String> biomes = ModGrowthCtrl.config.getBiomesCombined(block.func_177230_c());
            if (biomes != null && biomes.size() > 0) {
                boolean growHere = UtilString.isInList(biomes, ItemGrow.getBiome((IWorld)c.func_195991_k(), c.func_195995_a()).getRegistryName());
                TextFormatting formatf = growHere ? TextFormatting.GREEN : TextFormatting.RED;
                UtilString.chatMessage(c.func_195999_j(), formatf + block.func_177230_c().func_200291_n().func_150254_d() + " -> " + String.join((CharSequence)", ", biomes));
            } else {
                Biome biome = ItemGrow.getBiome((IWorld)c.func_195991_k(), c.func_195995_a());
                List<String> growths = ModGrowthCtrl.config.getGrowthsForBiome(biome);
                this.sendInfoToPlayer(growths, biome);
            }
        }
        return super.func_195939_a(c);
    }

    private void sendInfoToPlayer(List<String> growths, Biome biome) {
        ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
        ArrayList<String> valid = new ArrayList<String>();
        for (String g : growths) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(g));
            if (b == null) continue;
            if (p.func_213453_ef()) {
                valid.add(b.getRegistryName().toString());
                continue;
            }
            valid.add(b.func_200291_n().func_150254_d());
        }
        Collections.sort(valid);
        String bname = p.func_213453_ef() ? biome.getRegistryName().toString() : biome.func_205403_k().func_150254_d();
        UtilString.chatMessage((PlayerEntity)p, bname + " : " + String.join((CharSequence)", ", valid));
    }
}

