/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.gulliver;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.GravelBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.MyceliumBlock;
import net.minecraft.block.SandBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoulSandBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.WebBlock;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.teamfruit.gulliver.ClimbingHandler;
import net.teamfruit.gulliver.GulliverCommands;
import net.teamfruit.gulliver.GulliverConfig;
import net.teamfruit.gulliver.attributes.AttributesHandler;
import net.teamfruit.gulliver.compatibilities.Capabilities;
import net.teamfruit.gulliver.compatibilities.CapabilitiesHandler;
import net.teamfruit.gulliver.compatibilities.sizeCap.SizeCapPro;
import net.teamfruit.gulliver.event.PlayNetMoveEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gulliver")
public class Gulliver {
    public static final String MODID = "gulliver";
    public static final String NAME = "Gulliver-1.15.2";
    public static final Logger LOGGER = LogManager.getLogger((String)"Gulliver-1.15.2");

    public Gulliver() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, GulliverConfig.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigEvent);
    }

    public static DamageSource causeCrushingDamage(LivingEntity entity) {
        return new EntityDamageSource("gulliver.crushing", (Entity)entity);
    }

    public void preInit(FMLCommonSetupEvent event) {
        Capabilities.init();
        MinecraftForge.EVENT_BUS.register((Object)new CapabilitiesHandler());
        MinecraftForge.EVENT_BUS.register((Object)new AttributesHandler());
    }

    public void onConfigEvent(ModConfig.Loading event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        new GulliverCommands().register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (((Boolean)GulliverConfig.FEATURE.SCALED_FALL_DAMAGE.get()).booleanValue()) {
                event.setDistance(event.getDistance() / (player.func_213302_cg() * 0.6f));
            }
            if (player.func_213302_cg() < 0.45f) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = event.getEntityLiving().field_70170_p;
        for (LivingEntity entities : world.func_217357_a(LivingEntity.class, entity.func_174813_aQ())) {
            if (entity.func_225608_bj_() || !((Boolean)GulliverConfig.FEATURE.GIANTS_CRUSH_ENTITIES.get()).booleanValue() || !(entity.func_213302_cg() / entities.func_213302_cg() >= 4.0f) || entities.func_184187_bx() == entity) continue;
            entities.func_70097_a(Gulliver.causeCrushingDamage(entity), entity.func_213302_cg() - entities.func_213302_cg());
        }
    }

    @SubscribeEvent
    public void onTargetEntity(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity && ((Boolean)GulliverConfig.FEATURE.SMALL_IS_INVISIBLE_TO_NONCATS_OR_NONSPIDERS.get()).booleanValue()) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            MobEntity entity = (MobEntity)event.getEntityLiving();
            if (!(entity instanceof SpiderEntity) && !(entity instanceof OcelotEntity) && player.func_213302_cg() <= 0.45f) {
                entity.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onPlayNetMove(PlayNetMoveEvent event) {
        ServerPlayerEntity serverPlayer = event.getPlayer();
        if (serverPlayer.func_213302_cg() > 2.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        World world = event.player.field_70170_p;
        player.field_70138_W = player.func_213302_cg() / 3.0f;
        player.field_70747_aH *= (float)Math.pow(player.func_213302_cg() / 1.8f, 0.4f);
        if (player.func_213302_cg() > 2.0f && player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (serverPlayer.field_71135_a != null) {
                serverPlayer.field_71135_a.field_184344_B = false;
            }
        }
        if (player.func_213302_cg() < 0.9f) {
            BlockPos pos = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            float ratio = player.func_213302_cg() / 1.8f / 2.0f;
            if (!player.field_71075_bZ.field_75100_b && ((Boolean)GulliverConfig.FEATURE.PLANTS_SLOW_SMALL_DOWN.get()).booleanValue() && block instanceof BushBlock || block instanceof CarpetBlock || block instanceof FlowerBlock || block instanceof SugarCaneBlock || block instanceof SnowBlock || block instanceof WebBlock || block instanceof SoulSandBlock) {
                player.func_213317_d(player.func_213322_ci().func_216372_d((double)ratio, block instanceof WebBlock ? (double)ratio : 1.0, (double)ratio));
            }
        }
        if (player.func_213302_cg() <= 0.45f) {
            Direction facing = player.func_174811_aO();
            BlockPos pos = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            BlockState state = world.func_180495_p(pos.func_177982_a(0, 0, 0).func_177972_a(facing));
            Block block = state.func_177230_c();
            boolean canPass = state.func_196957_g((IBlockReader)world, pos.func_177972_a(facing), PathType.LAND);
            if ((ClimbingHandler.canClimb(player, facing) && ((Boolean)GulliverConfig.FEATURE.CLIMB_SOME_BLOCKS.get()).booleanValue() && block == Blocks.field_150346_d || block instanceof GrassBlock || block instanceof MyceliumBlock || block instanceof LeavesBlock || block instanceof SandBlock || block instanceof SoulSandBlock || block instanceof ConcretePowderBlock || block instanceof FarmlandBlock || block instanceof GrassPathBlock || block instanceof GravelBlock || block == Blocks.field_150435_aG) && player.field_70123_F) {
                Vec3d motion;
                if (!player.func_225608_bj_()) {
                    motion = player.func_213322_ci();
                    player.func_213293_j(motion.field_72450_a, 0.1, motion.field_72449_c);
                }
                if (player.func_225608_bj_()) {
                    motion = player.func_213322_ci();
                    player.func_213293_j(motion.field_72450_a, 0.0, motion.field_72449_c);
                }
            }
            for (ItemStack stack : player.func_184214_aD()) {
                Vec3d motion;
                if ((stack.func_77973_b() == Items.field_151123_aH || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180399_cE) && ((Boolean)GulliverConfig.FEATURE.CLIMB_WITH_SLIME.get()).booleanValue()) && ClimbingHandler.canClimb(player, facing) && player.field_70123_F) {
                    if (!player.func_225608_bj_()) {
                        motion = player.func_213322_ci();
                        player.func_213293_j(motion.field_72450_a, 0.1, motion.field_72449_c);
                    }
                    if (player.func_225608_bj_()) {
                        motion = player.func_213322_ci();
                        player.func_213293_j(motion.field_72450_a, 0.0, motion.field_72449_c);
                    }
                }
                if (stack.func_77973_b() != Items.field_151121_aF || !((Boolean)GulliverConfig.FEATURE.GLIDE_WITH_PAPER.get()).booleanValue() || player.field_70122_E) continue;
                player.field_70747_aH = 0.035f;
                player.field_70143_R = 0.0f;
                motion = player.func_213322_ci();
                if (motion.func_82617_b() < 0.0) {
                    player.func_213317_d(motion.func_216372_d(1.0, 0.6, 1.0));
                }
                if (player.func_225608_bj_()) {
                    player.field_70747_aH *= 3.5f;
                }
                double blockY = player.func_226278_cu_();
                while (!player.func_225608_bj_() && (world.func_180495_p(new BlockPos(player.func_226277_ct_(), blockY, player.func_226281_cx_())).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(new BlockPos(player.func_226277_ct_(), blockY, player.func_226281_cx_())).func_177230_c() == Blocks.field_150353_l || world.func_180495_p(new BlockPos(player.func_226277_ct_(), blockY, player.func_226281_cx_())).func_177230_c() == Blocks.field_150480_ab || world.func_180495_p(new BlockPos(player.func_226277_ct_(), blockY, player.func_226281_cx_())).func_177230_c() == Blocks.field_150460_al || world.func_180495_p(new BlockPos(player.func_226277_ct_(), blockY, player.func_226281_cx_())).func_177230_c() == Blocks.field_196814_hQ) && player.func_226278_cu_() - blockY < 25.0) {
                    if (world.func_180495_p(new BlockPos(player.func_226277_ct_(), blockY, player.func_226281_cx_())).func_177230_c() == Blocks.field_150353_l || world.func_180495_p(new BlockPos(player.func_226277_ct_(), blockY, player.func_226281_cx_())).func_177230_c() == Blocks.field_150480_ab || world.func_180495_p(new BlockPos(player.func_226277_ct_(), blockY, player.func_226281_cx_())).func_177230_c() == Blocks.field_150460_al || world.func_180495_p(new BlockPos(player.func_226277_ct_(), blockY, player.func_226281_cx_())).func_177230_c() == Blocks.field_196814_hQ && ((Boolean)GulliverConfig.FEATURE.HOT_BLOCKS_GIVE_LIFT.get()).booleanValue()) {
                        player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, MathHelper.func_151237_a((double)0.07, (double)Double.MIN_VALUE, (double)0.1), 0.0));
                    }
                    blockY -= 1.0;
                }
            }
        }
        if (player.func_184207_aI() && player.func_225608_bj_()) {
            for (Entity entity : player.func_184188_bt()) {
                entity.func_184210_p();
                entity.func_70024_g(0.0, -1.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)event.getTarget();
            PlayerEntity player = event.getPlayer();
            if (target.func_213302_cg() / 2.0f >= player.func_213302_cg() && ((Boolean)GulliverConfig.FEATURE.RIDE_BIG_ENTITIES.get()).booleanValue()) {
                for (ItemStack stack : player.func_184214_aD()) {
                    if (stack.func_77973_b() != Items.field_151007_F) continue;
                    player.func_184220_m((Entity)target);
                }
            }
            if (target.func_213302_cg() * 2.0f <= player.func_213302_cg() && ((Boolean)GulliverConfig.FEATURE.PICKUP_SMALL_ENTITIES.get()).booleanValue()) {
                target.func_184220_m((Entity)player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && ((Boolean)GulliverConfig.MODIFIER.JUMP_MODIFIER.get()).booleanValue()) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            float jumpHeight = (float)Math.pow(player.func_213302_cg() / 1.8f, 0.6f);
            jumpHeight = MathHelper.func_76131_a((float)jumpHeight, (float)0.65f, (float)jumpHeight);
            player.func_213317_d(player.func_213322_ci().func_216372_d(1.0, (double)jumpHeight, 1.0));
            if ((player.func_225608_bj_() || player.func_70051_ag()) && player.func_213302_cg() < 1.8f) {
                Vec3d motion = player.func_213322_ci();
                player.func_213293_j(motion.field_72450_a, (double)0.42f, motion.field_72449_c);
            }
        }
    }

    @SubscribeEvent
    public void onHarvest(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        if (((Boolean)GulliverConfig.MODIFIER.HARVEST_MODIFIER.get()).booleanValue()) {
            event.setNewSpeed(event.getOriginalSpeed() * (player.func_213302_cg() / 1.8f));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onFOVChange(FOVUpdateEvent event) {
        if (event.getEntity() != null) {
            PlayerEntity player = event.getEntity();
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            EffectInstance speed = player.func_70660_b(Effects.field_76424_c);
            float fov = (float)settings.field_74334_X;
            if (player.func_70051_ag()) {
                event.setNewfov(speed != null ? fov + (0.1f * (float)(speed.func_76458_c() + 1) + 0.15f) : fov + 0.1f);
            } else {
                event.setNewfov(speed != null ? fov + 0.1f * (float)(speed.func_76458_c() + 1) : fov);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderWorld(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float scale = player.func_213302_cg() / 1.8f;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && player.func_213302_cg() > 1.8f) {
            event.getMatrixStack().func_227861_a_(0.0, 0.0, (double)(-scale * 2.0f));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 && player.func_213302_cg() > 1.8f) {
            event.getMatrixStack().func_227861_a_(0.0, 0.0, (double)(scale * 2.0f));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onEntityRenderPre(RenderLivingEvent.Pre event) {
        if (((Boolean)GulliverConfig.FEATURE.DO_ADJUSTED_RENDER.get()).booleanValue()) {
            LivingEntity entity = event.getEntity();
            LazyOptional capLazy = entity.getCapability(SizeCapPro.sizeCapability);
            capLazy.ifPresent(cap -> {
                float scale;
                if (cap.getTrans() && (scale = entity.func_213302_cg() / cap.getDefaultHeight()) < 0.4f) {
                    event.getMatrixStack().func_227860_a_();
                    event.getMatrixStack().func_227862_a_(scale * 2.5f, 1.0f, scale * 2.5f);
                }
            });
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onLivingRenderPost(RenderLivingEvent.Post event) {
        if (((Boolean)GulliverConfig.FEATURE.DO_ADJUSTED_RENDER.get()).booleanValue()) {
            LivingEntity entity = event.getEntity();
            LazyOptional capLazy = entity.getCapability(SizeCapPro.sizeCapability);
            capLazy.ifPresent(cap -> {
                float scale;
                if (cap.getTrans() && (scale = entity.func_213302_cg() / cap.getDefaultHeight()) < 0.4f) {
                    event.getMatrixStack().func_227865_b_();
                }
            });
        }
    }
}

