/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.gulliver;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.teamfruit.gulliver.GulliverConfig;
import net.teamfruit.gulliver.attributes.Attributes;

public class GulliverCommands {
    private static UUID uuidHeight = UUID.fromString("5440b01a-974f-4495-bb9a-c7c87424bca4");
    private static UUID uuidWidth = UUID.fromString("3949d2ed-b6cc-4330-9c13-98777f48ea51");
    private static UUID uuidReach1 = UUID.fromString("854e0004-c218-406c-a9e2-590f1846d80b");
    private static UUID uuidReach2 = UUID.fromString("216080dc-22d3-4eff-a730-190ec0210d5c");
    private static UUID uuidHealth = UUID.fromString("3b901d47-2d30-495c-be45-f0091c0f6fb2");
    private static UUID uuidStrength = UUID.fromString("558f55be-b277-4091-ae9b-056c7bc96e84");
    private static UUID uuidSpeed = UUID.fromString("f2fb5cda-3fbe-4509-a0af-4fc994e6aeca");

    public void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"size").requires(cs -> cs.func_197034_c(0))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"size", (ArgumentType)FloatArgumentType.floatArg((float)0.125f)).requires(cs -> {
            if (!((Boolean)GulliverConfig.GENERAL.REQUIRE_PERMISSION.get()).booleanValue()) {
                return true;
            }
            if (cs.func_197034_c(2)) {
                return true;
            }
            if (cs.func_197022_f() instanceof ServerPlayerEntity) {
                try {
                    String playerUUID = cs.func_197035_h().func_146103_bH().getId().toString();
                    if (((List)GulliverConfig.GENERAL.WHITELIST.get()).contains(playerUUID)) {
                        return true;
                    }
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
            return false;
        })).executes(ctx -> {
            ServerPlayerEntity sender = ((CommandSource)ctx.getSource()).func_197035_h();
            float size = FloatArgumentType.getFloat((CommandContext)ctx, (String)"size");
            float maxUserSize = ((Double)GulliverConfig.GENERAL.MAX_SIZE_USER.get()).floatValue();
            if (!((CommandSource)ctx.getSource()).func_197034_c(2) && size > maxUserSize) {
                StringTextComponent message = new StringTextComponent("Need permission for size over " + maxUserSize);
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
            }
            this.changeSize((LivingEntity)sender, size);
            ((CommandSource)ctx.getSource()).func_197030_a(sender.func_145748_c_().func_150257_a((ITextComponent)new StringTextComponent(" set their size to " + size)), false);
            return 1;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
            Collection entities = EntityArgument.func_197097_b((CommandContext)ctx, (String)"entities");
            float size = FloatArgumentType.getFloat((CommandContext)ctx, (String)"size");
            Map<String, List<LivingEntity>> listEntity = entities.stream().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).peek(entity -> this.changeSize((LivingEntity)entity, size)).collect(Collectors.groupingBy(entity -> entity.func_145748_c_().func_150254_d()));
            ITextComponent text = TextComponentUtils.func_197677_b(listEntity.entrySet(), entry -> {
                int length = ((List)entry.getValue()).size();
                if (length <= 0) {
                    return new StringTextComponent("");
                }
                ITextComponent name = ((LivingEntity)((List)entry.getValue()).get(0)).func_145748_c_();
                if (length > 1) {
                    return new StringTextComponent("").func_150257_a(new StringTextComponent(length + "\u00d7").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY))).func_150257_a(name);
                }
                return name;
            });
            ((CommandSource)ctx.getSource()).func_197030_a(new StringTextComponent("").func_150257_a(new StringTextComponent("[").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY))).func_150257_a(text).func_150257_a(new StringTextComponent("]").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY))).func_150257_a((ITextComponent)new StringTextComponent(" set their size to " + size)), true);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"gulliver").then(LiteralArgumentBuilder.literal((String)"size").redirect((CommandNode)node))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"whitelist").requires(cs -> cs.func_197034_c(3))).then(LiteralArgumentBuilder.literal((String)"on").executes(ctx -> {
            GulliverConfig.GENERAL.REQUIRE_PERMISSION.set((Object)true);
            GulliverConfig.GENERAL.REQUIRE_PERMISSION.save();
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.whitelist.enabled", new Object[0]), true);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"off").executes(ctx -> {
            GulliverConfig.GENERAL.REQUIRE_PERMISSION.set((Object)false);
            GulliverConfig.GENERAL.REQUIRE_PERMISSION.save();
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.whitelist.disabled", new Object[0]), true);
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"list").executes(ctx -> {
            List whitelist = (List)GulliverConfig.GENERAL.WHITELIST.get();
            PlayerList playerList = ((CommandSource)ctx.getSource()).func_197028_i().func_184103_al();
            List list = whitelist.stream().map(uuid -> {
                try {
                    return playerList.func_177451_a(UUID.fromString(uuid)).func_145748_c_();
                }
                catch (IllegalArgumentException e) {
                    return new StringTextComponent(uuid);
                }
            }).collect(Collectors.toList());
            if (list.isEmpty()) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.whitelist.none", new Object[0]), false);
            } else {
                ITextComponent text = TextComponentUtils.func_197677_b(list, Function.identity());
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.whitelist.list", new Object[]{list.size(), text}), false);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"add").then(RequiredArgumentBuilder.argument((String)"players", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)ctx, (String)"players");
            List whitelist = (List)GulliverConfig.GENERAL.WHITELIST.get();
            for (ServerPlayerEntity player : players) {
                String uuid = player.func_146103_bH().getId().toString();
                if (whitelist.contains(uuid)) continue;
                whitelist.add(uuid);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.whitelist.add.success", new Object[]{TextComponentUtils.func_197679_a((GameProfile)player.func_146103_bH())}), true);
            }
            GulliverConfig.GENERAL.WHITELIST.set((Object)whitelist);
            GulliverConfig.GENERAL.WHITELIST.save();
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"remove").then(RequiredArgumentBuilder.argument((String)"players", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)ctx, (String)"players");
            List whitelist = (List)GulliverConfig.GENERAL.WHITELIST.get();
            for (ServerPlayerEntity player : players) {
                String uuid = player.func_146103_bH().getId().toString();
                if (!whitelist.contains(uuid)) continue;
                whitelist.remove(uuid);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.whitelist.remove.success", new Object[]{TextComponentUtils.func_197679_a((GameProfile)player.func_146103_bH())}), true);
            }
            GulliverConfig.GENERAL.WHITELIST.set((Object)whitelist);
            GulliverConfig.GENERAL.WHITELIST.save();
            return 1;
        })))));
    }

    public void changeSize(LivingEntity sender, float size) {
        HashMultimap attributes = HashMultimap.create();
        HashMultimap removeableAttributes = HashMultimap.create();
        HashMultimap removeableAttributes2 = HashMultimap.create();
        attributes.put((Object)Attributes.ENTITY_HEIGHT.func_111108_a(), (Object)new AttributeModifier(uuidHeight, "Player Height", (double)(size - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
        attributes.put((Object)Attributes.ENTITY_WIDTH.func_111108_a(), (Object)new AttributeModifier(uuidWidth, "Player Width", MathHelper.func_151237_a((double)(size - 1.0f), (double)-0.6, (double)((Double)GulliverConfig.GENERAL.MAX_SIZE.get())), AttributeModifier.Operation.MULTIPLY_TOTAL));
        if (((Boolean)GulliverConfig.MODIFIER.SPEED_MODIFIER.get()).booleanValue()) {
            attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuidSpeed, "Player Speed", (double)((size - 1.0f) / 2.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (((Boolean)GulliverConfig.MODIFIER.REACH_MODIFIER.get()).booleanValue()) {
            removeableAttributes.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(uuidReach1, "Player Reach 1", (double)(size - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (((Boolean)GulliverConfig.MODIFIER.REACH_MODIFIER.get()).booleanValue()) {
            removeableAttributes2.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(uuidReach2, "Player Reach 2", -MathHelper.func_151237_a((double)(size - 1.0f), (double)0.33, (double)Double.MAX_VALUE), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (((Boolean)GulliverConfig.MODIFIER.STRENGTH_MODIFIER.get()).booleanValue()) {
            attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuidStrength, "Player Strength", (double)(size - 1.0f), AttributeModifier.Operation.ADDITION));
        }
        if (((Boolean)GulliverConfig.MODIFIER.HEALTH_MODIFIER.get()).booleanValue()) {
            attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(uuidHealth, "Player Health", (double)(size - 1.0f) * (Double)GulliverConfig.GENERAL.HEALTH_MULTIPLIER.get(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (size > 1.0f) {
            sender.func_110140_aT().func_111147_b((Multimap)removeableAttributes);
        } else {
            sender.func_110140_aT().func_111148_a((Multimap)removeableAttributes);
        }
        if (size < 1.0f) {
            sender.func_110140_aT().func_111147_b((Multimap)removeableAttributes2);
        } else {
            sender.func_110140_aT().func_111148_a((Multimap)removeableAttributes2);
        }
        sender.func_110140_aT().func_111147_b((Multimap)attributes);
        sender.func_70606_j(sender.func_110138_aP());
    }
}

