/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.gulliver.attributes;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.teamfruit.gulliver.attributes.Attributes;
import net.teamfruit.gulliver.compatibilities.sizeCap.SizeCapPro;

public class AttributesHandler {
    @SubscribeEvent
    public void attachAttributes(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            AbstractAttributeMap map = entity.func_110140_aT();
            map.func_111150_b(Attributes.ENTITY_HEIGHT);
            map.func_111150_b(Attributes.ENTITY_WIDTH);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        LazyOptional lazyCap = player.getCapability(SizeCapPro.sizeCapability);
        lazyCap.ifPresent(cap -> {
            boolean hasHeightModifier = player.func_110148_a(Attributes.ENTITY_HEIGHT).func_225505_c_().isEmpty();
            boolean hasWidthModifier = player.func_110148_a(Attributes.ENTITY_WIDTH).func_225505_c_().isEmpty();
            double heightAttribute = player.func_110148_a(Attributes.ENTITY_HEIGHT).func_111126_e();
            double widthAttribute = player.func_110148_a(Attributes.ENTITY_WIDTH).func_111126_e();
            float height = (float)((double)cap.getDefaultHeight() * heightAttribute);
            float width = (float)((double)cap.getDefaultWidth() * widthAttribute);
            if (!hasHeightModifier || !hasWidthModifier) {
                if (!cap.getTrans()) {
                    cap.setDefaultHeight(1.8f);
                    cap.setDefaultWidth(0.6f);
                    cap.setTrans(true);
                }
                if (cap.getTrans()) {
                    float eyeHeight = (float)((double)player.func_213348_b(player.func_213283_Z(), player.func_213305_a(player.func_213283_Z())) * heightAttribute);
                    if (player.func_225608_bj_()) {
                        height *= 0.9166667f;
                        eyeHeight *= 0.9382716f;
                    }
                    if (player.func_184613_cA()) {
                        height *= 0.33f;
                    }
                    if (player.func_70608_bn()) {
                        width = 0.2f;
                        height = 0.2f;
                    }
                    if (player.func_184218_aH()) {
                        // empty if block
                    }
                    width = MathHelper.func_76131_a((float)width, (float)0.15f, (float)width);
                    player.field_213326_aJ = (height = MathHelper.func_76131_a((float)height, (float)0.25f, (float)height)) >= 1.6f ? eyeHeight : eyeHeight * 0.9876542f;
                    player.field_213325_aI = EntitySize.func_220314_b((float)width, (float)height);
                    double d0 = (double)width / 2.0;
                    AxisAlignedBB aabb = player.func_174813_aQ();
                    player.func_174826_a(new AxisAlignedBB(player.func_226277_ct_() - d0, aabb.field_72338_b, player.func_226281_cx_() - d0, player.func_226277_ct_() + d0, aabb.field_72338_b + (double)player.func_213302_cg(), player.func_226281_cx_() + d0));
                }
            } else if (cap.getTrans()) {
                player.field_213325_aI = EntitySize.func_220314_b((float)width, (float)height);
                double d0 = (double)width / 2.0;
                AxisAlignedBB aabb = player.func_174813_aQ();
                player.func_174826_a(new AxisAlignedBB(player.func_226277_ct_() - d0, aabb.field_72338_b, player.func_226281_cx_() - d0, player.func_226277_ct_() + d0, aabb.field_72338_b + (double)height, player.func_226281_cx_() + d0));
                player.field_213326_aJ = player.func_213305_a((Pose)player.func_213283_Z()).field_220316_b * 0.85f;
                cap.setTrans(false);
            }
        });
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof PlayerEntity)) {
            LazyOptional lazyCap = entity.getCapability(SizeCapPro.sizeCapability);
            lazyCap.ifPresent(cap -> {
                boolean hasHeightModifier = entity.func_110148_a(Attributes.ENTITY_HEIGHT).func_225505_c_().isEmpty();
                boolean hasWidthModifier = entity.func_110148_a(Attributes.ENTITY_WIDTH).func_225505_c_().isEmpty();
                double heightAttribute = entity.func_110148_a(Attributes.ENTITY_HEIGHT).func_111126_e();
                double widthAttribute = entity.func_110148_a(Attributes.ENTITY_WIDTH).func_111126_e();
                float height = (float)((double)cap.getDefaultHeight() * heightAttribute);
                float width = (float)((double)cap.getDefaultWidth() * widthAttribute);
                if (!hasHeightModifier || !hasWidthModifier) {
                    if (!cap.getTrans()) {
                        cap.setDefaultHeight(entity.func_213302_cg());
                        cap.setDefaultWidth(entity.func_213311_cf());
                        cap.setTrans(true);
                    }
                    if (cap.getTrans()) {
                        width = MathHelper.func_76131_a((float)width, (float)0.04f, (float)width);
                        height = MathHelper.func_76131_a((float)height, (float)0.08f, (float)height);
                        entity.field_213325_aI = EntitySize.func_220314_b((float)width, (float)height);
                        double d0 = (double)width / 2.0;
                        AxisAlignedBB aabb = entity.func_174813_aQ();
                        entity.func_174826_a(new AxisAlignedBB(entity.func_226277_ct_() - d0, aabb.field_72338_b, entity.func_226281_cx_() - d0, entity.func_226277_ct_() + d0, aabb.field_72338_b + (double)entity.func_213302_cg(), entity.func_226281_cx_() + d0));
                    }
                } else if (cap.getTrans()) {
                    entity.field_213325_aI = EntitySize.func_220314_b((float)width, (float)height);
                    double d0 = (double)width / 2.0;
                    AxisAlignedBB aabb = entity.func_174813_aQ();
                    entity.func_174826_a(new AxisAlignedBB(entity.func_226277_ct_() - d0, aabb.field_72338_b, entity.func_226281_cx_() - d0, entity.func_226277_ct_() + d0, aabb.field_72338_b + (double)height, entity.func_226281_cx_() + d0));
                    cap.setTrans(false);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityRenderPre(RenderLivingEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        LazyOptional lazyCap = entity.getCapability(SizeCapPro.sizeCapability);
        lazyCap.ifPresent(cap -> {
            if (cap.getTrans()) {
                float scaleHeight = entity.func_213302_cg() / cap.getDefaultHeight();
                float scaleWidth = entity.func_213311_cf() / cap.getDefaultWidth();
                if (entity instanceof PlayerEntity && entity.func_184187_bx() instanceof AbstractHorseEntity) {
                    event.getMatrixStack().func_227861_a_(0.0, (double)((1.0f - scaleHeight) * 0.62f), 0.0);
                }
                event.getMatrixStack().func_227860_a_();
                event.getMatrixStack().func_227862_a_(scaleWidth, scaleHeight, scaleWidth);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onLivingRenderPost(RenderLivingEvent.Post event) {
        LivingEntity entity = event.getEntity();
        LazyOptional lazyCap = entity.getCapability(SizeCapPro.sizeCapability);
        lazyCap.ifPresent(cap -> {
            if (cap.getTrans()) {
                event.getMatrixStack().func_227865_b_();
            }
        });
    }
}

