/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.harvestsprites.blocks;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.mongotheelder.harvestsprites.Config;
import tv.mongotheelder.harvestsprites.blocks.SpriteLampTile;

public class SpriteLampBlock
extends Block {
    private static final Logger LOGGER = LogManager.getLogger();

    public SpriteLampBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SpriteLampTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        int minX = pos.func_177958_n() - 9;
        int maxX = pos.func_177958_n() + 9;
        int maxY = pos.func_177956_o() + 3;
        int minY = pos.func_177956_o() - 3;
        int minZ = pos.func_177952_p() - 9;
        int maxZ = pos.func_177952_p() + 9;
        ArrayList blocks = new ArrayList();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos target = new BlockPos(x, y, z);
                    if (worldIn.func_195588_v(target) && !(worldIn.func_180495_p(target).func_177230_c() instanceof SpriteLampBlock)) continue;
                }
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208194_u});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.55;
            double d2 = (double)pos.func_177952_p() + 0.5;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u) != false && (Boolean)Config.ENABLE_LIGHT.get() != false ? super.func_149750_m(state) : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return (Boolean)Config.EMIT_REDSTONE.get();
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)Config.EMIT_REDSTONE.get()).booleanValue()) {
            return 0;
        }
        SpriteLampTile te = (SpriteLampTile)blockAccess.func_175625_s(pos);
        if (te == null) {
            return 0;
        }
        return te.getLampRedstoneLevel();
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_180656_a(blockState, blockAccess, pos, side) > 0 ? 15 : 0;
    }

    public void notifyNeighbors(World world, BlockPos pos) {
        world.func_195593_d(pos, (Block)this);
    }
}

