/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.harvestsprites.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import tv.mongotheelder.harvestsprites.blocks.SpriteLampTile;

public class ProgressPacket {
    private final float progress;
    private final BlockPos pos;

    public ProgressPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.progress = buf.readFloat();
    }

    public ProgressPacket(BlockPos pos, float progress) {
        this.pos = pos;
        this.progress = progress;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeFloat(this.progress);
    }

    public static void handle(ProgressPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                TileEntity e = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
                if (e instanceof SpriteLampTile) {
                    ((SpriteLampTile)e).setProgress(message.progress);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

