/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.dispenser;

import defeatedcrow.dispenser.AgriPlugin;
import defeatedcrow.dispenser.DispenserHervestDC;
import defeatedcrow.dispenser.HaCPlugin;
import defeatedcrow.dispenser.RegisterShearsJson;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class DispenseShears
extends BehaviorDefaultDispenseItem {
    private static final DispenseShears INSTANCE = new DispenseShears();
    private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

    public static DispenseShears getInstance() {
        return INSTANCE;
    }

    private DispenseShears() {
    }

    @Nonnull
    public ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        if (DispenserHervestDC.loadedHaC && HaCPlugin.isScythe(stack)) {
            int r = HaCPlugin.getScytheTier(stack);
            return this.harvestCrop(source, stack, r);
        }
        if (RegisterShearsJson.INSTANCE.getRange(stack) > 0) {
            return this.harvestCrop(source, stack, RegisterShearsJson.INSTANCE.getRange(stack));
        }
        return super.func_82487_b(source, stack);
    }

    private boolean isShears(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemShears;
    }

    @Nonnull
    private ItemStack harvestCrop(@Nonnull IBlockSource source, @Nonnull ItemStack stack, int r) {
        World world = source.func_82618_k();
        EnumFacing face = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos pos = source.func_180699_d();
        int range = r;
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        if (range > 0) {
            boolean success = false;
            IItemHandler inv = null;
            for (EnumFacing f : EnumFacing.field_82609_l) {
                if (world.func_175625_s(pos.func_177972_a(f)) == null || world.func_175625_s(pos.func_177972_a(f)) instanceof TileEntityDispenser || !world.func_175625_s(pos.func_177972_a(f)).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d())) continue;
                inv = (IItemHandler)world.func_175625_s(pos.func_177972_a(f)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d());
                break;
            }
            BlockPos pos2 = pos.func_177967_a(face, range + 1);
            for (int x = pos2.func_177958_n() - range; x <= pos2.func_177958_n() + range; ++x) {
                for (int z = pos2.func_177952_p() - range; z <= pos2.func_177952_p() + range; ++z) {
                    IGrowable crop;
                    NonNullList l1;
                    BlockCrops crop2;
                    BlockPos p1 = new BlockPos(x, pos2.func_177956_o() + 1, z);
                    BlockPos p2 = new BlockPos(x, pos2.func_177956_o(), z);
                    IBlockState s1 = world.func_180495_p(p1);
                    IBlockState s2 = world.func_180495_p(p2);
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    if (DispenserHervestDC.loadedHaC && HaCPlugin.isHaCCrop(s1)) {
                        if (HaCPlugin.isHarvestableCrop(s1) && !HaCPlugin.getHarvest(s1, fortune).isEmpty()) {
                            list.addAll(HaCPlugin.getHarvest(s1, fortune));
                            world.func_175656_a(p1, HaCPlugin.setGroundState(s1));
                        }
                    } else if (DispenserHervestDC.loadedAgri && AgriPlugin.isAgriCrop(world, p1)) {
                        if (AgriPlugin.isHarvestableCrop(world, p1) && !AgriPlugin.getHarvest(world, p1, fortune).isEmpty()) {
                            list.addAll(AgriPlugin.getHarvest(world, p1, fortune));
                            AgriPlugin.setGroundState(world, p1);
                        }
                    } else if (s1.func_177230_c() instanceof BlockCrops) {
                        crop2 = (BlockCrops)s1.func_177230_c();
                        if (crop2.func_185525_y(s1)) {
                            l1 = NonNullList.func_191196_a();
                            crop2.getDrops(l1, (IBlockAccess)world, p1, s1, fortune);
                            if (!l1.isEmpty()) {
                                list.addAll((Collection<ItemStack>)l1);
                                world.func_175656_a(p1, crop2.func_176223_P());
                            }
                        }
                    } else if (s1.func_177230_c() instanceof BlockCactus || s1.func_177230_c() instanceof BlockReed || s1.func_185904_a() == Material.field_151572_C) {
                        list.add(new ItemStack(s1.func_177230_c().func_180660_a(s1, world.field_73012_v, fortune), 1, 0));
                        world.func_175698_g(p1);
                    } else if (!(s1.func_177230_c() instanceof BlockStem) && s1.func_177230_c() instanceof IGrowable && !(crop = (IGrowable)s1.func_177230_c()).func_176473_a(world, p1, s1, false)) {
                        l1 = NonNullList.func_191196_a();
                        s1.func_177230_c().getDrops(l1, (IBlockAccess)world, p1, s1, fortune);
                        if (!l1.isEmpty()) {
                            list.addAll((Collection<ItemStack>)l1);
                            world.func_175656_a(p1, s1.func_177230_c().func_176223_P());
                        }
                    }
                    if (DispenserHervestDC.loadedHaC && HaCPlugin.isHaCCrop(s2)) {
                        if (HaCPlugin.isHarvestableCrop(s2) && !HaCPlugin.getHarvest(s2, fortune).isEmpty()) {
                            list.addAll(HaCPlugin.getHarvest(s2, fortune));
                            world.func_175656_a(p2, HaCPlugin.setGroundState(s2));
                        }
                    } else if (DispenserHervestDC.loadedAgri && AgriPlugin.isAgriCrop(world, p2)) {
                        if (AgriPlugin.isHarvestableCrop(world, p2) && !AgriPlugin.getHarvest(world, p2, fortune).isEmpty()) {
                            list.addAll(AgriPlugin.getHarvest(world, p2, fortune));
                            AgriPlugin.setGroundState(world, p2);
                        }
                    } else if (s2.func_177230_c() instanceof BlockCrops) {
                        crop2 = (BlockCrops)s2.func_177230_c();
                        if (crop2.func_185525_y(s2)) {
                            l1 = NonNullList.func_191196_a();
                            crop2.getDrops(l1, (IBlockAccess)world, p2, s2, fortune);
                            if (!l1.isEmpty()) {
                                list.addAll((Collection<ItemStack>)l1);
                                world.func_175656_a(p2, crop2.func_176223_P());
                            }
                        }
                    } else if (s2.func_177230_c() instanceof BlockCactus || s2.func_177230_c() instanceof BlockReed || s2.func_185904_a() == Material.field_151572_C) {
                        list.add(new ItemStack(s2.func_177230_c().func_180660_a(s2, world.field_73012_v, fortune), 1, 0));
                        world.func_175698_g(p2);
                    } else if (!(s2.func_177230_c() instanceof BlockStem) && s2.func_177230_c() instanceof IGrowable && !(crop2 = (IGrowable)s2.func_177230_c()).func_176473_a(world, p2, s2, false)) {
                        l1 = NonNullList.func_191196_a();
                        s2.func_177230_c().getDrops(l1, (IBlockAccess)world, p2, s2, fortune);
                        if (!l1.isEmpty()) {
                            list.addAll((Collection<ItemStack>)l1);
                            world.func_175656_a(p2, s2.func_177230_c().func_176223_P());
                        }
                    }
                    if (list.isEmpty()) continue;
                    success = true;
                    for (int i = 0; i < list.size(); ++i) {
                        ItemStack c1 = (ItemStack)list.get(i);
                        ItemStack ret = ItemStack.field_190927_a;
                        if (inv != null) {
                            for (int slot = 0; slot < inv.getSlots() && !(ret = inv.insertItem(slot, c1, false)).func_190926_b(); ++slot) {
                            }
                        } else {
                            ret = c1;
                        }
                        if (ret.func_190926_b()) continue;
                        EntityItem drop = new EntityItem(world, (double)pos.func_177972_a(face).func_177958_n() + 0.5, (double)pos.func_177972_a(face).func_177956_o() + 0.5, (double)pos.func_177972_a(face).func_177952_p() + 0.5, ret);
                        drop.field_70159_w = 0.0;
                        drop.field_70181_x = 0.0;
                        drop.field_70179_y = 0.0;
                        world.func_72838_d((Entity)drop);
                    }
                }
            }
            if (success && stack.func_96631_a(1, world.field_73012_v, null)) {
                stack.func_190920_e(0);
            }
        }
        return stack;
    }
}

