/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.dispenser;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import defeatedcrow.dispenser.DispenseShears;
import defeatedcrow.dispenser.DispenserHarvestDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RegisterShearsJson {
    public static final HashMap<Item, Integer> rangeMap = new HashMap();
    public static final RegisterShearsJson INSTANCE = new RegisterShearsJson();
    private static Map<String, Object> jsonMap = new HashMap<String, Object>();
    protected static Map<String, Map<String, Integer>> intMap = new HashMap<String, Map<String, Integer>>();
    private static File dir = null;

    private RegisterShearsJson() {
    }

    public HashMap<Item, Integer> getHeatMap() {
        return rangeMap;
    }

    public static boolean isEmpty(ItemStack item) {
        if (item == null) {
            item = ItemStack.field_190927_a;
            return true;
        }
        return item.func_77973_b() == null || item.func_190926_b();
    }

    public void registerMaterial(Item item, int r) {
        if (item == null) {
            return;
        }
        if (!rangeMap.containsKey(item)) {
            rangeMap.put(item, r);
            DispenserHarvestDC.LOGGER.info("register item as shears: " + item.getRegistryName().toString() + " : range " + r);
            String mapName = item.getRegistryName().toString();
            HashMap map = Maps.newHashMap();
            map.put("range", r);
            intMap.put(mapName, map);
            DispenserBlock.func_199774_a((IItemProvider)item.func_199767_j(), (IDispenseItemBehavior)new DispenseShears());
        }
    }

    public int getRange(ItemStack item) {
        if (RegisterShearsJson.isEmpty(item)) {
            return 0;
        }
        if (rangeMap.containsKey(item.func_77973_b())) {
            int ret = rangeMap.get(item.func_77973_b());
            return ret;
        }
        return 0;
    }

    public void registerItemName(String name, int r) {
        if (RegisterShearsJson.isValidKey(name)) {
            Item item;
            String[] n2;
            String itemName = name = name.toLowerCase();
            String modid = "minecraft";
            if (name.contains(":") && (n2 = name.split(":")) != null && n2.length > 0) {
                if (n2.length == 1) {
                    itemName = n2[0];
                } else {
                    modid = n2[0];
                    itemName = n2[1];
                }
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, itemName))) != null) {
                DispenserHarvestDC.LOGGER.info("register target item from json: " + modid + ":" + itemName);
                INSTANCE.registerMaterial(item, r);
            }
        }
    }

    public static boolean isValidKey(String key) {
        return key != null && !key.contains(" ") && !key.contains(",") && !key.contains("(") && !key.contains(")");
    }

    public static void startMap() {
        if (!jsonMap.isEmpty()) {
            for (Map.Entry<String, Object> ent : jsonMap.entrySet()) {
                if (ent == null) continue;
                String name = ent.getKey();
                Object value = ent.getValue();
                Float f = Float.valueOf(0.0f);
                int range = 0;
                if (value instanceof Map) {
                    String h = ((Map)value).get("range").toString();
                    f = Float.valueOf(Float.parseFloat(h));
                    range = MathHelper.func_76141_d((float)f.floatValue());
                }
                INSTANCE.registerItemName(name, range);
            }
        } else {
            DispenserHarvestDC.LOGGER.info("no shears json data.");
        }
    }

    public static void pre() {
        if (dir != null) {
            try {
                if (!dir.exists() && !dir.createNewFile()) {
                    return;
                }
                if (dir.canRead()) {
                    FileInputStream fis = new FileInputStream(dir.getPath());
                    InputStreamReader isr = new InputStreamReader(fis);
                    JsonReader jsr = new JsonReader((Reader)isr);
                    Gson gson = new Gson();
                    Map get = (Map)gson.fromJson(jsr, Map.class);
                    isr.close();
                    fis.close();
                    jsr.close();
                    if (get != null && !get.isEmpty()) {
                        jsonMap.putAll(get);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        RegisterShearsJson.startMap();
    }

    public static void post() {
        if (dir != null) {
            try {
                if (!dir.exists() && !dir.createNewFile()) {
                    return;
                }
                if (!jsonMap.isEmpty()) {
                    DispenserHarvestDC.LOGGER.info("item resistant data json is already exists.");
                    return;
                }
                INSTANCE.registerMaterial(Items.field_151097_aZ, 2);
                if (dir.canWrite()) {
                    FileOutputStream fos = new FileOutputStream(dir.getPath());
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    JsonWriter jsw = new JsonWriter((Writer)osw);
                    jsw.setIndent(" ");
                    Gson gson = new Gson();
                    gson.toJson(intMap, Map.class, jsw);
                    osw.close();
                    fos.close();
                    jsw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setDir(Path path) {
        dir = new File(path.toFile(), "harvest_with_dispenser.json");
        if (dir.getParentFile() != null) {
            dir.getParentFile().mkdirs();
        }
    }
}

