/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.gui.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class WindowInputReceiver
extends Window<WorkspaceHats> {
    public float lastX;
    public float x;
    public float headingX;
    public float lastY;
    public float y;
    public float headingY;
    public float lastDriftYaw;
    public float driftYaw;
    public float headingDriftYaw;
    public float lastDriftPitch;
    public float driftPitch;
    public float headingDriftPitch;
    public float lastCamDist;
    public float camDist;
    public float headingCamDist;

    public WindowInputReceiver(WorkspaceHats parent) {
        super((IWindows)parent);
        this.size(parent.getWidth(), parent.getHeight());
        this.setConstraint(Constraint.matchParent((IConstrained)this, (IConstrainable)parent, (int)0));
        this.borderSize = () -> 0;
        this.titleSize = () -> 0;
        this.disableBringToFront();
        this.disableDocking();
        this.disableDockStacking();
        this.disableUndocking();
        this.disableDrag();
        this.disableDragResize();
        this.disableTitle();
    }

    public void init() {
        this.constraint.apply();
    }

    public void resize(Minecraft mc, int width, int height) {
        this.constraint.apply();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        if (!((WorkspaceHats)this.parent).fallback) {
            Hats.eventHandlerClient.guiX = this.lastX + (this.x - this.lastX) * partialTick;
            Hats.eventHandlerClient.guiY = this.lastY + (this.y - this.lastY) * partialTick;
            Hats.eventHandlerClient.guiYaw = (this.lastDriftYaw + (this.driftYaw - this.lastDriftYaw) * partialTick) % 360.0f;
            Hats.eventHandlerClient.guiPitch = (this.lastDriftPitch + (this.driftPitch - this.lastDriftPitch) * partialTick) % 360.0f;
            Hats.eventHandlerClient.guiDist = this.lastCamDist + (this.camDist - this.lastCamDist) * partialTick;
        }
    }

    public void tick() {
        super.tick();
        this.correct();
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastDriftYaw = this.driftYaw;
        this.lastDriftPitch = this.driftPitch;
        this.lastCamDist = this.camDist;
        float mag = 0.4f;
        this.x += (this.headingX - this.x) * mag;
        this.y += (this.headingY - this.y) * mag;
        this.driftYaw += (this.headingDriftYaw - this.driftYaw) * mag;
        this.driftPitch += (this.headingDriftPitch - this.driftPitch) * mag;
        this.camDist += (this.headingCamDist - this.camDist) * mag;
    }

    public void correct() {
        if (((WorkspaceHats)this.parent).fallback) {
            if (this.headingCamDist < -5.0f) {
                this.headingCamDist = -5.0f;
            } else if (this.headingCamDist > 1.0f) {
                this.headingCamDist = 1.0f;
            }
        } else if (this.headingCamDist < -1.2f) {
            this.headingCamDist = -1.2f;
        } else if (this.headingCamDist > 4.0f) {
            this.headingCamDist = 4.0f;
        }
        if (this.headingX < -4.0f) {
            this.headingX = -4.0f;
        } else if (this.headingX > 4.0f) {
            this.headingX = 4.0f;
        }
        if (this.headingY < -4.0f) {
            this.headingY = -4.0f;
        } else if (this.headingY > 4.0f) {
            this.headingY = 4.0f;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY) && mouseX < (double)this.getWidth() / 2.0) {
            ((WorkspaceHats)this.parent).func_231037_b__(true);
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        super.func_231048_c_(mouseX, mouseY, button);
        return true;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double distX, double distY) {
        if (button == 0 || button == 1 || button == 2) {
            if (button == 2 || Screen.func_231173_s_()) {
                float mag = 0.0125f;
                this.headingX = (float)((double)this.headingX - distX * (double)mag);
                this.headingY = (float)((double)this.headingY + distY * (double)mag);
            } else if (Screen.func_231172_r_()) {
                this.headingCamDist = (float)((double)this.headingCamDist + (distX - distY) * 0.05);
            } else {
                float mag = 0.5f;
                this.headingDriftYaw = (float)((double)this.headingDriftYaw + distX * (double)mag);
                this.headingDriftPitch = (float)((double)this.headingDriftPitch + distY * (double)mag);
            }
        }
        return true;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            this.headingCamDist = (float)((double)this.headingCamDist - amount * 0.05);
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        return false;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return false;
    }
}

