/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.gui.window.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.hats.client.gui.window.element.ElementHatRender;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementFertile;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class ElementHatsScrollView
extends ElementFertile {
    public List<Element<?>> elements = new ArrayList();
    @Nullable
    private ElementScrollBar<?> scrollVert;
    public boolean hasInit;

    public ElementHatsScrollView(@Nonnull Fragment parent) {
        super(parent);
    }

    public <T extends ElementHatsScrollView> T setScrollVertical(ElementScrollBar<?> scroll) {
        this.scrollVert = scroll;
        this.scrollVert.setCallback(scr -> this.alignItems());
        return (T)((Object)this);
    }

    public Element<?> addElement(Element<?> e) {
        this.elements.add(e);
        if (this.hasInit) {
            this.scrollToSelectedElement();
            this.alignItems();
            this.updateScrollBarSizes();
        }
        return e;
    }

    public void init() {
        super.init();
        this.hasInit = true;
        this.scrollToSelectedElement();
        this.alignItems();
        this.updateScrollBarSizes();
    }

    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        this.scrollToSelectedElement();
        this.alignItems();
        super.resize(mc, width, height);
        this.scrollToSelectedElement();
        this.alignItems();
        this.updateScrollBarSizes();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        if (this.renderMinecraftStyle() > 0) {
            ElementHatsScrollView.bindTexture((ResourceLocation)this.resourceHorse());
            ElementHatsScrollView.cropAndStitch((MatrixStack)stack, (int)(this.getLeft() - 1), (int)(this.getTop() - 1), (int)(this.width + 2), (int)(this.height + 2), (int)2, (double)79.0, (double)17.0, (int)90, (int)54, (double)256.0, (double)256.0);
        } else {
            RenderHelper.drawColour((MatrixStack)stack, (int)this.getTheme().elementTreeBorder[0], (int)this.getTheme().elementTreeBorder[1], (int)this.getTheme().elementTreeBorder[2], (int)255, (double)(this.getLeft() - 1), (double)(this.getTop() - 1), (double)(this.width + 2), (double)1.0, (double)0.0);
            RenderHelper.drawColour((MatrixStack)stack, (int)this.getTheme().elementTreeBorder[0], (int)this.getTheme().elementTreeBorder[1], (int)this.getTheme().elementTreeBorder[2], (int)255, (double)(this.getLeft() - 1), (double)(this.getTop() - 1), (double)1.0, (double)(this.height + 2), (double)0.0);
            RenderHelper.drawColour((MatrixStack)stack, (int)this.getTheme().elementTreeBorder[0], (int)this.getTheme().elementTreeBorder[1], (int)this.getTheme().elementTreeBorder[2], (int)255, (double)(this.getLeft() - 1), (double)this.getBottom(), (double)(this.width + 2), (double)1.0, (double)0.0);
            RenderHelper.drawColour((MatrixStack)stack, (int)this.getTheme().elementTreeBorder[0], (int)this.getTheme().elementTreeBorder[1], (int)this.getTheme().elementTreeBorder[2], (int)255, (double)this.getRight(), (double)(this.getTop() - 1), (double)1.0, (double)(this.height + 2), (double)0.0);
        }
        this.setScissor();
        this.elements.forEach(item -> {
            if (item.getBottom() >= this.getTop() && item.getTop() < this.getBottom()) {
                item.func_230430_a_(stack, mouseX, mouseY, partialTick);
            }
        });
        this.resetScissorToParent();
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double dist) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            boolean defaultScroll = super.func_231043_a_(mouseX, mouseY, dist);
            if (defaultScroll) {
                return true;
            }
            if (this.scrollVert != null) {
                this.scrollVert.secondHandScroll(dist * 70.0 / (double)this.getTotalItemHeight() * 2.0);
                return true;
            }
        }
        return false;
    }

    public int getTotalItemHeight() {
        int padding = 3;
        int useableWidth = this.getWidth() - padding;
        int maxPerRow = (int)Math.floor((float)useableWidth / 50.0f);
        if (maxPerRow > this.elements.size()) {
            maxPerRow = this.elements.size();
        }
        int rowCount = (int)Math.ceil((float)this.elements.size() / (float)maxPerRow);
        return (70 + padding) * rowCount + padding;
    }

    public void scrollToSelectedElement() {
        if (this.scrollVert != null) {
            int padding = 3;
            int useableWidth = this.getWidth() - padding;
            int maxPerRow = (int)Math.floor((float)useableWidth / 50.0f);
            if (maxPerRow > this.elements.size()) {
                maxPerRow = this.elements.size();
            }
            int rowCount = (int)Math.ceil((float)this.elements.size() / (float)maxPerRow);
            int totalItemHeight = (70 + padding) * rowCount + padding;
            for (int i = 0; i < this.elements.size(); ++i) {
                ElementHatRender hatRender = (ElementHatRender)this.elements.get(i);
                if (!hatRender.toggleState) continue;
                int thisRow = (int)Math.floor((float)i / (float)maxPerRow);
                this.scrollVert.setScrollProg((float)((70 + padding) * thisRow) / (float)Math.max(0.1, (double)(totalItemHeight - this.height)));
                break;
            }
        }
    }

    public void alignItems() {
        int padding = 3;
        int useableWidth = this.getWidth() - padding;
        int maxPerRow = (int)Math.floor((float)useableWidth / 50.0f);
        if (maxPerRow > this.elements.size()) {
            maxPerRow = this.elements.size();
        }
        int rowCount = (int)Math.ceil((float)this.elements.size() / (float)maxPerRow);
        int totalItemHeight = (70 + padding) * rowCount + padding;
        int offsetY = 0;
        if (this.scrollVert != null) {
            offsetY = (int)((float)Math.max(0, totalItemHeight - this.height) * this.scrollVert.scrollProg);
        }
        int offsetX = 0;
        int widthPerItem = (int)Math.floor((float)useableWidth / (float)maxPerRow) - padding;
        int currentWidth = 0;
        int currentHeight = padding;
        for (Element<?> item : this.elements) {
            item.posX = (currentWidth += padding) - offsetX;
            item.posY = currentHeight - offsetY;
            if (item.width != widthPerItem) {
                item.width = widthPerItem;
            }
            if ((currentWidth += item.width) + padding + widthPerItem <= useableWidth) continue;
            currentWidth = 0;
            currentHeight += padding;
            currentHeight += item.getHeight();
        }
    }

    public void updateScrollBarSizes() {
        if (this.scrollVert != null) {
            this.scrollVert.setScrollBarSize((float)this.height / (float)this.getTotalItemHeight());
        }
    }

    public List<? extends Element<?>> func_231039_at__() {
        return this.elements;
    }

    public boolean requireScissor() {
        return true;
    }

    public boolean func_231049_c__(boolean direction) {
        return false;
    }

    public int getMinWidth() {
        return 58;
    }

    public int getMinHeight() {
        if (this.scrollVert != null) {
            return 14;
        }
        return super.getMinHeight();
    }

    public int getBorderSize() {
        return 0;
    }
}

