/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.module.tabula;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowPopup;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButtonTextured;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementNumberInput;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextField;
import me.ichun.mods.ichunutil.common.module.tabula.TabulaPlugin;
import me.ichun.mods.ichunutil.common.module.tabula.formats.ImportList;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HatsTabulaPlugin
extends TabulaPlugin {
    public ElementButtonTextured<?> onPopulateToolbar(@Nonnull TabulaPlugin.TabulaWorkspace workspace, @Nonnull View<?> toolbarView, @Nonnull ElementButtonTextured<?> lastToolbarButton, @Nullable Project currentProject) {
        ElementButtonTextured btn = new ElementButtonTextured(toolbarView, new ResourceLocation("hats", "textures/icon/tabula_open.png"), button -> {
            WindowOpenProject window = new WindowOpenProject(toolbarView.getWorkspace(), workspace);
            toolbarView.getWorkspace().openWindowInCenter((Window)window, 0.4, 0.6);
            window.init();
        });
        btn.setSize(20, 20).setTooltip(I18n.func_135052_a((String)"hats.plugin.tabula.button", (Object[])new Object[0]));
        btn.setConstraint(new Constraint((IConstrained)btn).left(lastToolbarButton, Constraint.Property.Type.RIGHT, 0));
        toolbarView.elements.add(btn);
        return btn;
    }

    public static class WindowOpenProject
    extends Window<Workspace> {
        public TabulaPlugin.TabulaWorkspace tabulaWorkspace;

        public WindowOpenProject(Workspace parent, TabulaPlugin.TabulaWorkspace tabulaWorkspace) {
            super((IWindows)parent);
            this.tabulaWorkspace = tabulaWorkspace;
            this.setView(new ViewOpenProject(this));
            this.disableDockingEntirely();
        }

        public static class ViewOpenProject
        extends View<WindowOpenProject> {
            public TreeSet<File> files = new TreeSet(Ordering.natural());
            public ElementList<?> list;

            public ViewOpenProject(@Nonnull WindowOpenProject parent) {
                super((Window)parent, "window.open.title");
                ElementScrollBar sv = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
                sv.setConstraint(new Constraint((IConstrained)sv).top((IConstrainable)this, Constraint.Property.Type.TOP, 0).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 40).right((IConstrainable)this, Constraint.Property.Type.RIGHT, 0));
                this.elements.add(sv);
                this.list = new ElementList((Fragment)this).setScrollVertical(sv);
                this.list.setConstraint(new Constraint(this.list).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 40).left((IConstrainable)this, Constraint.Property.Type.LEFT, 0).right((IConstrainable)sv, Constraint.Property.Type.LEFT, 0).top((IConstrainable)this, Constraint.Property.Type.TOP, 0));
                this.elements.add(this.list);
                ArrayList<File> allFiles = new ArrayList<File>();
                ViewOpenProject.scourForHats(allFiles, HatResourceHandler.getHatsDir().toFile());
                this.files.addAll(allFiles);
                ElementButtonTextured openDir = new ElementButtonTextured((Fragment)this, new ResourceLocation("tabula", "textures/icon/info.png"), btn -> Util.func_110647_a().func_195641_a(HatResourceHandler.getHatsDir().toFile()));
                openDir.setTooltip(I18n.func_135052_a((String)"topdock.openWorkingDir", (Object[])new Object[0])).setSize(20, 20);
                openDir.setConstraint(new Constraint((IConstrained)openDir).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 10).left((IConstrainable)this, Constraint.Property.Type.LEFT, 10));
                this.elements.add(openDir);
                ElementNumberInput input = new ElementNumberInput((Fragment)this, false);
                input.setMin(0.0).setMax(100.0).setDefaultText("20").setTooltip(I18n.func_135052_a((String)"window.controls.opacity", (Object[])new Object[0])).setSize(60, 20).setId("inputOpacity");
                input.setConstraint(new Constraint((IConstrained)input).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 10).left((IConstrainable)openDir, Constraint.Property.Type.RIGHT, 10));
                this.elements.add(input);
                ElementButton button = new ElementButton((Fragment)this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), btn -> this.getWorkspace().removeWindow((Window)parent));
                button.setSize(60, 20).setTooltip(I18n.func_135052_a((String)"hats.plugin.tabula.button.ok.tooltip", (Object[])new Object[0]));
                button.setConstraint(new Constraint((IConstrained)button).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 10).right((IConstrainable)this, Constraint.Property.Type.RIGHT, 10));
                this.elements.add(button);
                ElementButton button1 = new ElementButton((Fragment)this, I18n.func_135052_a((String)"gui.ok", (Object[])new Object[0]), btn -> {
                    for (ElementList.Item item : this.list.items) {
                        if (!item.selected) continue;
                        this.loadFile((File)item.getObject(), (float)((ElementNumberInput)this.getById("inputOpacity")).getInt() / 100.0f, Screen.func_231173_s_());
                        return;
                    }
                    if (Screen.func_231173_s_()) {
                        this.loadFile(null, (float)((ElementNumberInput)this.getById("inputOpacity")).getInt() / 100.0f, false);
                    }
                }){

                    public void renderText(MatrixStack stack) {
                        this.text = Screen.func_231173_s_() ? I18n.func_135052_a((String)"hats.plugin.tabula.button.new", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.ok", (Object[])new Object[0]);
                        super.renderText(stack);
                    }
                };
                button1.setSize(60, 20);
                button1.setConstraint(new Constraint((IConstrained)button1).right((IConstrainable)button, Constraint.Property.Type.LEFT, 10));
                this.elements.add(button1);
                ElementTextField textField = new ElementTextField((Fragment)this);
                textField.setId("search");
                textField.setResponder(s -> {
                    this.list.items.clear();
                    this.populateList((String)s);
                }).setHeight(14);
                textField.setConstraint(new Constraint((IConstrained)textField).left((IConstrainable)input, Constraint.Property.Type.RIGHT, 10).right((IConstrainable)button1, Constraint.Property.Type.LEFT, 10).bottom((IConstrainable)button1, Constraint.Property.Type.BOTTOM, 3));
                this.elements.add(textField);
                this.populateList("");
            }

            public void populateList(String query) {
                for (File file : this.files) {
                    if (!query.isEmpty() && !file.getName().toLowerCase(Locale.ROOT).contains(query.toLowerCase(Locale.ROOT))) continue;
                    this.list.addItem((Object)file).setDefaultAppearance().setDoubleClickHandler(item -> {
                        if (item.selected) {
                            this.loadFile((File)item.getObject(), (float)((ElementNumberInput)this.getById("inputOpacity")).getInt() / 100.0f, Screen.func_231173_s_());
                        }
                    });
                }
                this.list.init();
                this.list.init();
            }

            public void loadFile(File file, float ghostOpacity, boolean loadAsGhost) {
                Project project;
                ((Workspace)((WindowOpenProject)this.parentFragment).parent).removeWindow((Window)this.parentFragment);
                if (file != null) {
                    project = ImportList.createProjectFromFile((File)file);
                } else {
                    project = new Project();
                    project.name = "New Hat";
                    project.author = Minecraft.func_71410_x().func_110432_I().func_111285_a();
                    project.markDirty();
                }
                if (project == null) {
                    WindowPopup.popup((Workspace)((Workspace)((WindowOpenProject)this.parentFragment).parent), (double)0.4, (double)140.0, null, (String[])new String[]{I18n.func_135052_a((String)"window.open.failed", (Object[])new Object[0])});
                } else {
                    InputStream in;
                    if (project.tampered) {
                        WindowPopup.popup((Workspace)((Workspace)((WindowOpenProject)this.parentFragment).parent), (double)0.5, (double)160.0, null, (String[])new String[]{I18n.func_135052_a((String)"window.open.tampered", (Object[])new Object[0])});
                    }
                    if (project.isOldTabula) {
                        WindowPopup.popup((Workspace)((Workspace)((WindowOpenProject)this.parentFragment).parent), (double)0.5, (double)300.0, null, (String[])new String[]{I18n.func_135052_a((String)"window.open.oldTabula1", (Object[])new Object[0]), I18n.func_135052_a((String)"window.open.oldTabula2", (Object[])new Object[0]), I18n.func_135052_a((String)"window.open.oldTabula3", (Object[])new Object[0]), I18n.func_135052_a((String)"window.open.oldTabula4", (Object[])new Object[0])});
                    }
                    Project ghost = null;
                    if (loadAsGhost) {
                        ghost = project;
                        project = new Project();
                        project.name = "New Hat";
                        project.author = Minecraft.func_71410_x().func_110432_I().func_111285_a();
                        project.markDirty();
                    } else if (ghostOpacity > 0.0f && (in = Hats.class.getResourceAsStream("/HatTemplate.tbl")) != null && (ghost = ImportList.IMPORTER_TABULA.createProject(in)) != null) {
                        ghost.projVersion = ImportList.IMPORTER_TABULA.getProjectVersion();
                        ghost.load();
                    }
                    ((WindowOpenProject)this.parentFragment).tabulaWorkspace.openProject(project, ghost, ghost == null ? 0.0f : ghostOpacity);
                }
            }

            private static void scourForHats(ArrayList<File> allFiles, File dir) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (file.isDirectory()) {
                        ViewOpenProject.scourForHats(allFiles, file);
                        continue;
                    }
                    if (!ImportList.isFileSupported((File)file)) continue;
                    allFiles.add(file);
                }
            }
        }
    }
}

