/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.entity.EntityHat;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.packet.PacketEntityHatEntityDetails;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderHatEntity
extends EntityRenderer<EntityHat> {
    protected RenderHatEntity(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(EntityHat hat, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (hat.hatPart.name.isEmpty() && hat.hatPart.count <= 0) {
            if (hat.hatPart.count == -1) {
                hat.hatPart.count = 0;
                Hats.channel.sendToServer((AbstractPacket)new PacketEntityHatEntityDetails(hat.func_145782_y(), hat.hatPart.write(new CompoundNBT())));
            }
            return;
        }
        if (hat.age < 1 || Hats.eventHandlerClient.renderCount >= Hats.configClient.maxHatRenders) {
            return;
        }
        HatInfo hatInfo = HatResourceHandler.getInfoAndSetToPart(hat.hatPart);
        if (hatInfo != null) {
            stack.func_227860_a_();
            stack.func_227861_a_((double)(-hat.func_213311_cf() / 2.0f), 0.0, (double)(-hat.func_213311_cf() / 2.0f));
            stack.func_227861_a_((double)((hat.hatDims[1] - hat.hatDims[0]) / 32.0f), 0.0, (double)((hat.hatDims[5] - hat.hatDims[4]) / 32.0f));
            float scale = 0.2f + MathHelper.func_76131_a((float)(((float)(hat.age - 2) + partialTicks) / 10.0f), (float)0.0f, (float)0.8f);
            if (hat.age >= Hats.configServer.hatEntityLifespan - 20) {
                scale = 1.0f - MathHelper.func_76131_a((float)(((float)(hat.age - (Hats.configServer.hatEntityLifespan - 20)) + partialTicks) / 20.0f), (float)0.0f, (float)1.0f);
            }
            stack.func_227862_a_(-scale, -scale, scale);
            float halfHatHeight = (hat.hatDims[3] - hat.hatDims[2]) / 16.0f / 2.0f;
            stack.func_227861_a_(0.0, (double)(-halfHatHeight), 0.0);
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(hat.lastRotX + (hat.rotX - hat.lastRotX) * partialTicks));
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(hat.lastRotY + (hat.rotY - hat.lastRotY) * partialTicks));
            stack.func_227861_a_(0.0, (double)halfHatHeight, 0.0);
            stack.func_227861_a_(0.0, (double)(-hat.hatDims[3] / 16.0f), 0.0);
            hatInfo.render(stack, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, true);
            stack.func_227865_b_();
            ++Hats.eventHandlerClient.renderCount;
        }
        super.func_225623_a_((Entity)hat, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    public ResourceLocation getEntityTexture(EntityHat entity) {
        return AtlasTexture.field_110575_b;
    }

    public static class RenderFactory
    implements IRenderFactory<EntityHat> {
        public EntityRenderer<? super EntityHat> createRenderFor(EntityRendererManager manager) {
            return new RenderHatEntity(manager);
        }
    }
}

