/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.config;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.EnumRarity;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.RandomStringUtils;

public class ConfigServer
extends ConfigBase {
    @CategoryDivider(name="hatRandomisation")
    public String randSeed = "";
    @Prop(min=0.0, max=1.0)
    public double hatChance = 0.1;
    @Prop(validator="overrideChance")
    public List<String> entityOverrideChance = new ArrayList<String>();
    public List<String> disabledMobs = new ArrayList<String>();
    @Prop(validator="numbersOnly")
    public List<String> rarityWeight = new ArrayList<String>(){
        {
            this.add("21");
            this.add("13");
            this.add("8");
            this.add("5");
            this.add("3");
        }
    };
    @Prop(validator="numbersOnly")
    public List<String> rarityCost = new ArrayList<String>(){
        {
            this.add("10");
            this.add("20");
            this.add("40");
            this.add("70");
            this.add("110");
        }
    };
    @Prop(min=0.0, max=1.0)
    public double bossHatChanceBonus = 0.1;
    @Prop(min=0.0, max=1.0)
    public double bossRarityBonus = 0.2;
    @CategoryDivider(name="gameplay")
    public boolean allowFileTransfer = true;
    @Prop(min=0.0)
    public double accessoryCostMultiplier = 1.5;
    @Prop(min=0.0)
    public double salesCostMultiplier = 10.0;
    @Prop(min=0.0, max=2.0)
    public int enabledGuiStyle = 2;
    public boolean sendNewHatToastPrompt = true;
    public boolean enableCreativeModeHatHunting = false;
    @Prop(min=0.0)
    public int hatEntityLifespan = 6000;
    public boolean hatLauncherReplacesPlayerHat = true;
    public boolean hatLauncherDoesNotRemoveHatFromInventory = true;
    public transient HashMap<ResourceLocation, Integer> entityOverrideChanceParsed = new HashMap();
    public transient ArrayList<Double> rarityMeasure = new ArrayList();
    public transient ArrayList<Double> rarityIndividual = new ArrayList();
    public transient EnumMap<EnumRarity, Integer> tokensByRarity = new EnumMap(EnumRarity.class);

    public ConfigServer() {
        super(ModLoadingContext.get().getActiveContainer().getModId() + "-server.toml");
    }

    public synchronized void onConfigLoaded() {
        int i;
        if (EffectiveSide.get().isClient() && ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().func_71264_H()) {
            return;
        }
        if (this.randSeed.isEmpty()) {
            this.randSeed = RandomStringUtils.randomAscii((int)20);
            this.save();
        }
        this.parseOverrideChance();
        EnumRarity[] rarities = EnumRarity.values();
        int totalRarities = rarities.length;
        this.rarityMeasure.clear();
        this.rarityIndividual.clear();
        if (this.rarityWeight.size() != totalRarities) {
            Hats.LOGGER.warn("We don't have (exactly) " + totalRarities + " different rarity weights! Any shortage will be replaced with 0");
        }
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (int i2 = 0; i2 < Math.min(this.rarityWeight.size(), totalRarities); ++i2) {
            weights.add(Integer.parseInt(this.rarityWeight.get(i2)));
        }
        while (weights.size() < totalRarities) {
            weights.add(0);
        }
        int total = 0;
        for (Integer weight : weights) {
            total += weight.intValue();
        }
        if (total == 0) {
            Hats.LOGGER.warn("We can't have 0 weight! Forcing 1 weight to COMMON");
            weights.remove(0);
            weights.add(0, 1);
            total = 1;
        }
        double stack = 0.0;
        for (Integer weight : weights) {
            this.rarityIndividual.add((double)weight.intValue() / (double)total);
            this.rarityMeasure.add((stack += (double)weight.intValue()) / (double)total);
        }
        this.tokensByRarity.clear();
        if (this.rarityCost.size() != totalRarities) {
            Hats.LOGGER.warn("We don't have (exactly) " + totalRarities + " different rarity costs! Any shortage will be replaced with 0");
        }
        ArrayList<Integer> costs = new ArrayList<Integer>();
        for (i = 0; i < Math.min(this.rarityCost.size(), totalRarities); ++i) {
            costs.add(Integer.parseInt(this.rarityCost.get(i)));
        }
        while (costs.size() < totalRarities) {
            costs.add(0);
        }
        for (i = 0; i < rarities.length; ++i) {
            this.tokensByRarity.put(rarities[i], (Integer)costs.get(i));
        }
        HatHandler.allocateHatPools();
    }

    public boolean numbersOnly(Object o) {
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o) >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean overrideChance(Object o) {
        String[] split;
        if (o instanceof String && (split = ((String)o).split(",")).length == 2) {
            try {
                new ResourceLocation(split[0]);
                int chance = Integer.parseInt(split[1]);
                return chance >= 0 && chance <= 100;
            }
            catch (NumberFormatException | ResourceLocationException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public void parseOverrideChance() {
        this.entityOverrideChanceParsed.clear();
        for (String s : this.entityOverrideChance) {
            String[] split = s.split(",");
            this.entityOverrideChanceParsed.put(new ResourceLocation(split[0]), Integer.parseInt(split[1]));
        }
    }

    @Nonnull
    public String getModId() {
        return "hats";
    }

    @Nonnull
    public String getConfigName() {
        return "Hats";
    }

    @Nonnull
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

