/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.entity;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.hats.advancement.Advancements;
import me.ichun.mods.hats.common.packet.PacketEntityHatDetails;
import me.ichun.mods.hats.common.packet.PacketEntityHatEntityDetails;
import me.ichun.mods.hats.common.packet.PacketRehatify;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityHat
extends Entity {
    @Nonnull
    public HatsSavedData.HatPart hatPart;
    public UUID lastInteractedEntity;
    public boolean leftEntity;
    public int age = 0;
    public EntitySize hatSize = EntitySize.func_220311_c((float)0.1f, (float)0.1f);
    public float[] hatDims = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public int knockback = 0;
    public boolean wasCollided = false;
    public boolean isRogue = false;
    public float lastRotX;
    public float lastRotY;
    public float rotX;
    public float rotY;
    public float rotFactorX;
    public float rotFactorY;

    public EntityHat(EntityType<?> type, World world) {
        super(type, world);
        this.hatPart = new HatsSavedData.HatPart();
        this.rotFactorX = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 45.0f;
        this.rotFactorY = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 45.0f;
    }

    public EntityHat setHatPart(HatsSavedData.HatPart part) {
        this.hatPart = part;
        this.calculateNewHatSize();
        return this;
    }

    public EntityHat setLastInteracted(LivingEntity living) {
        this.lastInteractedEntity = living.func_110124_au();
        this.leftEntity = false;
        this.age = 0;
        return this;
    }

    public void setKnockbackStrength(int i) {
        this.knockback = i;
    }

    public void calculateNewHatSize() {
        HatInfo info = HatResourceHandler.getInfoAndSetToPart(this.hatPart);
        if (info != null) {
            this.hatDims = info.getDimensions();
            this.hatSize = EntitySize.func_220311_c((float)(Math.max(Math.abs(this.hatDims[1] - this.hatDims[0]), Math.abs(this.hatDims[5] - this.hatDims[4])) / 16.0f), (float)(Math.abs(this.hatDims[3] - this.hatDims[2]) / 16.0f));
        } else {
            this.hatSize = EntitySize.func_220311_c((float)0.0f, (float)0.0f);
        }
        this.func_213323_x_();
    }

    public void setThrowableHeading(double motionX, double motionY, double motionZ, float magnitude, float recoil) {
        float var9 = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)var9;
        motionY /= (double)var9;
        motionZ /= (double)var9;
        motionX += this.field_70146_Z.nextGaussian() * 0.0075 * (double)recoil;
        motionY += this.field_70146_Z.nextGaussian() * 0.0075 * (double)recoil;
        motionZ += this.field_70146_Z.nextGaussian() * 0.0075 * (double)recoil;
        this.func_213293_j(motionX *= (double)magnitude, motionY *= (double)magnitude, motionZ *= (double)magnitude);
        float var10 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, var10) * 180.0 / Math.PI);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.hatSize;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        ++this.age;
        if (this.age > Hats.configServer.hatEntityLifespan && !this.field_70170_p.field_72995_K) {
            this.func_241204_bJ_();
            return;
        }
        if (this.field_70173_aa == 1) {
            this.calculateNewHatSize();
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.lastRotX = this.rotX;
        this.lastRotY = this.rotY;
        this.wasCollided = this.field_70123_F || this.field_70124_G;
        float f = this.func_70047_e();
        if (this.func_70090_H() && this.func_233571_b_((ITag)FluidTags.field_206959_a) > (double)f) {
            this.applyFloatMotion();
        } else if (this.func_180799_ab() && this.func_233571_b_((ITag)FluidTags.field_206960_b) > (double)f) {
            this.applyLavaMotion();
        }
        Vector3d posEye = this.func_213303_ch().func_72441_c(0.0, (double)this.func_70047_e(), 0.0);
        if (!this.field_70170_p.field_72995_K) {
            EntityRayTraceResult entResult;
            List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), null);
            if (!this.leftEntity) {
                this.leftEntity = true;
                for (Entity entity : list) {
                    if (!entity.func_110124_au().equals(this.lastInteractedEntity)) continue;
                    this.leftEntity = false;
                }
            }
            LivingEntity collidedEnt = null;
            for (Entity entity1 : list) {
                if (!this.canPutOnHat(entity1)) continue;
                collidedEnt = (LivingEntity)entity1;
                break;
            }
            if (collidedEnt == null && (entResult = ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)posEye, (Vector3d)posEye.func_178787_e(this.func_213322_ci()), (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), this::canPutOnHat)) != null) {
                collidedEnt = (LivingEntity)entResult.func_216348_a();
            }
            if (collidedEnt != null) {
                Entity shooter;
                Vector3d vector3d;
                if (this.func_70027_ad()) {
                    collidedEnt.func_70015_d(100);
                }
                if (this.knockback > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockback * 0.6)).func_189985_c() > 0.0) {
                    collidedEnt.func_70024_g(vector3d.field_72450_a, (double)this.knockback * 0.2, vector3d.field_72449_c);
                    this.knockback = 0;
                    ((ServerChunkProvider)this.func_130014_f_().func_72863_F()).func_217218_b((Entity)collidedEnt, (IPacket)new SEntityVelocityPacket((Entity)collidedEnt));
                }
                if ((shooter = ((ServerWorld)this.field_70170_p).func_217461_a(this.lastInteractedEntity)) instanceof ServerPlayerEntity) {
                    Advancements.CriteriaTriggers.CHANGE_MOB_HAT.trigger((ServerPlayerEntity)shooter);
                    if (collidedEnt instanceof PigEntity && "iChun".equals(collidedEnt.func_200200_C_().func_150261_e())) {
                        Advancements.CriteriaTriggers.PIG_CHUN_HAT.trigger((ServerPlayerEntity)shooter);
                    }
                }
                LivingEntity collidedEntFinal = collidedEnt;
                HatsSavedData.HatPart hatPart = HatHandler.getHatPart(collidedEnt);
                HatsSavedData.HatPart oriHat = hatPart.createCopy();
                hatPart.copy(this.hatPart);
                HashMap<Integer, HatsSavedData.HatPart> entIdToHat = new HashMap<Integer, HatsSavedData.HatPart>();
                entIdToHat.put(collidedEnt.func_145782_y(), hatPart);
                if (!hatPart.name.isEmpty() || !oriHat.name.isEmpty()) {
                    Hats.channel.sendTo((AbstractPacket)new PacketRehatify(collidedEnt.func_145782_y()), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> collidedEntFinal));
                }
                Hats.channel.sendTo((AbstractPacket)new PacketEntityHatDetails(entIdToHat), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> collidedEntFinal));
                if (collidedEnt instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)collidedEnt;
                    if (HatHandler.useInventory((PlayerEntity)player)) {
                        HatHandler.addHat(player, this.hatPart);
                        if (Hats.configServer.hatLauncherDoesNotRemoveHatFromInventory) {
                            oriHat = new HatsSavedData.HatPart();
                        } else {
                            HatHandler.removeOneFromInventory(player, oriHat);
                        }
                    }
                    if (this.isRogue) {
                        Advancements.CriteriaTriggers.ROGUE_HAT.trigger(player);
                    }
                }
                if (!oriHat.name.isEmpty() && oriHat.count > 0) {
                    this.setLastInteracted(collidedEnt);
                    this.isRogue = true;
                    this.hatPart.copy(oriHat);
                    Hats.channel.sendTo((AbstractPacket)new PacketEntityHatEntityDetails(this.func_145782_y(), this.hatPart.write(new CompoundNBT())), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this));
                    this.func_213317_d(new Vector3d(this.field_70146_Z.nextGaussian() * (double)0.2f, (double)(0.2f + this.field_70146_Z.nextFloat() * 0.2f), this.field_70146_Z.nextGaussian() * (double)0.2f));
                    ((ServerChunkProvider)this.func_130014_f_().func_72863_F()).func_217218_b((Entity)this, (IPacket)new SEntityVelocityPacket((Entity)this));
                } else {
                    this.func_241204_bJ_();
                    return;
                }
            }
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (!this.wasCollided && (this.field_70123_F || this.field_70124_G) && !this.hatPart.name.isEmpty()) {
            if (!this.field_70170_p.field_72995_K) {
                EntityHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)Hats.Sounds.BONK.get()), (SoundCategory)SoundCategory.AMBIENT, (float)0.5f, (float)(0.85f + (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.075f));
                this.isRogue = false;
            } else {
                this.rotFactorX += (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 45.0f;
                this.rotFactorY += (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 45.0f;
            }
        }
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.02f, 0.0));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.8, 0.8, 0.8));
            this.rotFactorX *= 0.8f;
            this.rotFactorY *= 0.8f;
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.98, 0.98, 0.98));
            this.rotFactorX *= 0.98f;
            this.rotFactorY *= 0.98f;
        }
        this.rotX += this.rotFactorX;
        this.rotY += this.rotFactorY;
    }

    private boolean canPutOnHat(Entity e) {
        return !(!(e instanceof LivingEntity) || !HatHandler.canWearHat((LivingEntity)e) || e.func_110124_au().equals(this.lastInteractedEntity) && !this.leftEntity || e instanceof PlayerEntity && !Hats.configServer.hatLauncherReplacesPlayerHat);
    }

    private void applyFloatMotion() {
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a * (double)0.99f, vector3d.field_72448_b + (double)(vector3d.field_72448_b < (double)0.06f ? 5.0E-4f : 0.0f), vector3d.field_72449_c * (double)0.99f);
    }

    private void applyLavaMotion() {
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a * (double)0.95f, vector3d.field_72448_b + (double)(vector3d.field_72448_b < (double)0.06f ? 5.0E-4f : 0.0f), vector3d.field_72449_c * (double)0.95f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityHat.func_184183_bd() * 2.0) * d0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT tag) {
        this.hatPart = new HatsSavedData.HatPart();
        this.hatPart.read(tag.func_74775_l("hatPart"));
        this.lastInteractedEntity = tag.func_186857_a("lastInteractedEntity");
        this.leftEntity = tag.func_74767_n("leftEntity");
        this.age = tag.func_74762_e("age");
    }

    protected void func_213281_b(CompoundNBT tag) {
        tag.func_218657_a("hatPart", (INBT)this.hatPart.write(new CompoundNBT()));
        tag.func_186854_a("lastInteractedEntity", this.lastInteractedEntity);
        tag.func_74757_a("leftEntity", this.leftEntity);
        tag.func_74768_a("age", this.age);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

