/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.hats;

import com.google.common.base.Splitter;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.common.module.tabula.formats.ImportList;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class HatResourceHandler {
    public static final ConcurrentHashMap<String, HatInfo> HATS = new ConcurrentHashMap();
    private static final ArrayList<HatInfo> HAT_ACCESSORIES = new ArrayList();
    public static ArrayList<HatsSavedData.HatPart> HAT_PARTS = new ArrayList();
    private static Path hatsDir;
    private static boolean init;

    public static synchronized boolean init() {
        if (!init) {
            init = true;
            try {
                File extractedMarker;
                hatsDir = FMLPaths.MODSDIR.get().resolve("hats");
                if (!Files.exists(hatsDir, new LinkOption[0])) {
                    Files.createDirectory(hatsDir, new FileAttribute[0]);
                }
                if (!(extractedMarker = new File(hatsDir.toFile(), "files.extracted")).exists()) {
                    InputStream in = Hats.class.getResourceAsStream("/hats.zip");
                    if (in != null) {
                        ZipInputStream zipStream = new ZipInputStream(in);
                        ZipEntry entry = null;
                        while ((entry = zipStream.getNextEntry()) != null) {
                            int len;
                            File file = new File(hatsDir.toFile(), entry.getName());
                            if (file.exists() && file.length() > 3L) continue;
                            if (entry.isDirectory()) {
                                if (file.exists()) continue;
                                file.mkdirs();
                                continue;
                            }
                            FileOutputStream out = new FileOutputStream(file);
                            byte[] buffer = new byte[8192];
                            while ((len = zipStream.read(buffer)) != -1) {
                                out.write(buffer, 0, len);
                            }
                            out.close();
                        }
                        zipStream.close();
                    }
                    FileUtils.writeStringToFile((File)extractedMarker, (String)"", (Charset)StandardCharsets.UTF_8);
                }
            }
            catch (IOException e) {
                Hats.LOGGER.fatal("Error initialising Hats resources!");
                e.printStackTrace();
                return false;
            }
        }
        return init;
    }

    public static Path getHatsDir() {
        return hatsDir;
    }

    public static synchronized void loadAllHats() {
        HATS.clear();
        HAT_ACCESSORIES.clear();
        int count = 0;
        File dir = HatResourceHandler.getHatsDir().toFile();
        int accessoryCount = HAT_ACCESSORIES.size();
        HatResourceHandler.accessoriseHatInfos();
        int hatCount = HATS.size();
        HAT_PARTS = HatResourceHandler.getAllHatsAsHatParts(1);
        Hats.LOGGER.info("Loaded {} files. {} hats, {} accessories.", (Object)(count += HatResourceHandler.scourForHats(dir)), (Object)hatCount, (Object)accessoryCount);
    }

    public static synchronized boolean loadSingularHat(File file) {
        if (file.getName().endsWith(".tbl") && HatResourceHandler.readHat(file)) {
            HatResourceHandler.accessoriseHatInfos();
            HAT_PARTS = HatResourceHandler.getAllHatsAsHatParts(1);
            Hats.LOGGER.info("Loaded hat: {}", (Object)file);
            return true;
        }
        return false;
    }

    private static int scourForHats(File dir) {
        File[] files;
        int count = 0;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                count += HatResourceHandler.scourForHats(file);
                continue;
            }
            if (!file.getName().endsWith(".tbl") || !HatResourceHandler.readHat(file)) continue;
            ++count;
        }
        return count;
    }

    public static boolean readHat(File file) {
        Project project = ImportList.createProjectFromFile((File)file);
        if (project == null) {
            Hats.LOGGER.warn("Error reading Tabula file: {}", (Object)file);
            return false;
        }
        if (project.getTextureBytes() == null) {
            Hats.LOGGER.warn("Tabula file has no texture, rejecting: {}", (Object)file);
            return false;
        }
        if (project.tampered) {
            Hats.LOGGER.warn("This hat file was tampered (which will be loaded anyway): {}", (Object)file);
        }
        if (project.isOldTabula) {
            HatResourceHandler.repairOldHat(file, project);
            Hats.LOGGER.warn("Loaded an old Tabula file. Updating to new Tabula & Hats format: {}", (Object)file);
        }
        String hatName = file.getName().substring(0, file.getName().length() - 4);
        HatInfo hatInfo = HatResourceHandler.createHatInfoFor(hatName, project);
        if (hatInfo.accessoryFor == null) {
            HATS.put(hatName, hatInfo);
        } else {
            HAT_ACCESSORIES.add(hatInfo);
        }
        return true;
    }

    private static HatInfo createHatInfoFor(@Nonnull String name, @Nonnull Project project) {
        return new HatInfo(name, project);
    }

    public static void accessoriseHatInfos() {
        HashMap<String, ArrayList> accessoriesByHat = new HashMap<String, ArrayList>();
        for (HatInfo hatAccessory : HAT_ACCESSORIES) {
            accessoriesByHat.computeIfAbsent(hatAccessory.accessoryFor, k -> new ArrayList()).add(hatAccessory);
        }
        accessoriesByHat.forEach((hatName, hatInfos) -> {
            block3: {
                block2: {
                    if (!HATS.containsKey(hatName)) break block2;
                    HATS.get(hatName).accessorise((ArrayList<HatInfo>)hatInfos);
                    if (hatInfos.isEmpty()) break block3;
                    for (HatInfo orphan : hatInfos) {
                        Hats.LOGGER.warn("We couldn't find the hat parent for {}", (Object)orphan.project.saveFile);
                    }
                    break block3;
                }
                for (HatInfo orphan : hatInfos) {
                    Hats.LOGGER.warn("We couldn't find the hat base for {}", (Object)orphan.project.saveFile);
                }
            }
        });
        HAT_ACCESSORIES.clear();
    }

    public static HatInfo getInfo(HatsSavedData.HatPart part) {
        return HATS.get(part.name);
    }

    public static HatInfo getInfoAndSetToPart(HatsSavedData.HatPart part) {
        HatInfo hatInfo = HatResourceHandler.getInfo(part);
        if (hatInfo != null) {
            hatInfo.matchPart(part);
            return hatInfo;
        }
        return null;
    }

    public static ArrayList<HatsSavedData.HatPart> getAllHatsAsHatParts(int count) {
        ArrayList<HatsSavedData.HatPart> hatParts = new ArrayList<HatsSavedData.HatPart>();
        HATS.forEach((s, info) -> hatParts.add(info.getAsHatPart(count)));
        return hatParts;
    }

    public static void combineLists(ArrayList<HatsSavedData.HatPart> primary, ArrayList<HatsSavedData.HatPart> secondary) {
        for (HatsSavedData.HatPart invPart : secondary) {
            for (HatsSavedData.HatPart hatPart : primary) {
                if (hatPart.add(invPart)) break;
            }
        }
    }

    public static HashSet<String> compileHatNames() {
        HashSet<String> names = new HashSet<String>();
        HATS.forEach((s, info) -> info.addFullNames(names));
        return names;
    }

    public static HatInfo getInfoFromFullName(String name) {
        List accNames;
        HatInfo parentInfo;
        Splitter ON_COLON = Splitter.on((String)":").trimResults().omitEmptyStrings();
        Splitter ON_PIPE = Splitter.on((String)"|").trimResults().omitEmptyStrings();
        List names = ON_COLON.splitToList((CharSequence)name);
        if (names.size() == 1) {
            return HATS.get(names.get(0));
        }
        if (names.size() == 2 && (parentInfo = HATS.get(names.get(0))) != null && !(accNames = ON_PIPE.splitToList((CharSequence)names.get(1))).isEmpty()) {
            return parentInfo.getInfoFor((String)accNames.get(accNames.size() - 1));
        }
        return null;
    }

    private static void repairOldHat(File file, Project project) {
        project.name = file.getName().substring(0, file.getName().length() - 4);
        project.author = "";
        project.isOldTabula = false;
        project.isDirty = true;
        ArrayList allParts = project.getAllParts();
        for (Project.Part part : allParts) {
            part.rotPY -= 16.0f;
        }
        project.save(file);
    }

    private static void parseMeta(File file, Project project) {
        boolean hasForcePool = false;
        boolean hasPool = false;
        for (int i = project.notes.size() - 1; i >= 0; --i) {
            String note = (String)project.notes.get(i);
            if (note.startsWith("Hats:{")) {
                project.notes.remove(i);
                try {
                    JsonObject element = new JsonParser().parse(note.substring(5).trim()).getAsJsonObject();
                    if (element.has("uuid")) {
                        project.notes.add("hats-contributor-uuid:" + element.get("uuid").getAsString());
                    }
                    if (element.has("isMiniMe")) {
                        project.notes.add("hats-contributor-mini-me:" + element.get("isMiniMe").getAsBoolean());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (note.startsWith("hats-rarity")) {
                hasForcePool = true;
            }
            if (!note.startsWith("hats-pool")) continue;
            hasPool = true;
        }
        if (!hasForcePool) {
            project.notes.add("hats-rarity:legendary");
        }
        if (!hasPool) {
            project.notes.add("hats-pool:contributors");
        }
        project.save(file);
    }
}

