/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.hats.advancement;

import com.mojang.util.UUIDTypeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.common.advancement.criterion.CodeDefinedTrigger;
import me.ichun.mods.ichunutil.common.advancement.criterion.ValueAtOrAboveTrigger;
import me.ichun.mods.ichunutil.common.data.AdvancementGen;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.criterion.EnchantedItemTrigger;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.KilledTrigger;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="hats", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Advancements
implements Consumer<Consumer<Advancement>> {
    public static final HashMap<Integer, ResourceLocation> DAMAGE_TO_TEXTURE_MAP = new HashMap<Integer, ResourceLocation>(){
        {
            this.put(1, new ResourceLocation("hats", "textures/advancements/hat.png"));
            this.put(2, new ResourceLocation("hats", "textures/advancements/hat10.png"));
            this.put(3, new ResourceLocation("hats", "textures/advancements/hat25.png"));
            this.put(4, new ResourceLocation("hats", "textures/advancements/hat50.png"));
            this.put(5, new ResourceLocation("hats", "textures/advancements/acc1.png"));
            this.put(6, new ResourceLocation("hats", "textures/advancements/acc10.png"));
            this.put(7, new ResourceLocation("hats", "textures/advancements/acc25.png"));
            this.put(8, new ResourceLocation("hats", "textures/advancements/acc50.png"));
            this.put(9, new ResourceLocation("hats", "textures/advancements/hat_count10.png"));
            this.put(10, new ResourceLocation("hats", "textures/advancements/hat_count25.png"));
            this.put(11, new ResourceLocation("hats", "textures/advancements/hat_count50.png"));
            this.put(12, new ResourceLocation("hats", "textures/advancements/vars50.png"));
            this.put(13, new ResourceLocation("hats", "textures/advancements/vars75.png"));
            this.put(14, new ResourceLocation("hats", "textures/advancements/vars100.png"));
            this.put(15, new ResourceLocation("hats", "textures/advancements/personalise.png"));
            this.put(16, new ResourceLocation("hats", "textures/advancements/colourise.png"));
            this.put(17, new ResourceLocation("hats", "textures/advancements/three_feathers_one_hat.png"));
            this.put(18, new ResourceLocation("hats", "textures/advancements/acc_on_acc.png"));
            this.put(19, new ResourceLocation("hats", "textures/advancements/non_vanilla.png"));
        }
    };
    public static final ResourceLocation ALL_VARIANTS = new ResourceLocation("hats", "hats/variants_100");

    @Override
    public void accept(Consumer<Advancement> consumer) {
        Advancement root = Advancement.Builder.func_200278_a().func_215092_a(Advancements.getItemWithDamage(1), (ITextComponent)new TranslationTextComponent("hats.advancement.root.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.root.description"), new ResourceLocation("textures/block/basalt_side.png"), FrameType.TASK, false, false, false).func_200275_a("killed_something", (ICriterionInstance)KilledTrigger.Instance.func_203927_c()).func_203904_a(consumer, "hats:hats/root");
        Advancement hatsUnlocked1 = Advancement.Builder.func_200278_a().func_203905_a(root).func_203902_a((IItemProvider)Items.field_151041_m, (ITextComponent)new TranslationTextComponent("hats.advancement.hatsUnlocked1.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.hatsUnlocked1.description"), null, FrameType.TASK, true, true, false).func_200275_a("hats_unlocked", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.HATS_UNLOCKED.func_192163_a(), (int)1)).func_203904_a(consumer, "hats:hats/hats_unlocked_1");
        Advancement hatsUnlocked10 = Advancement.Builder.func_200278_a().func_203905_a(hatsUnlocked1).func_215092_a(Advancements.getItemWithDamage(2), (ITextComponent)new TranslationTextComponent("hats.advancement.hatsUnlocked10.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.hatsUnlocked10.description"), null, FrameType.TASK, true, true, false).func_200275_a("hats_unlocked", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.HATS_UNLOCKED.func_192163_a(), (int)10)).func_203904_a(consumer, "hats:hats/hats_unlocked_10");
        Advancement hatsUnlocked25 = Advancement.Builder.func_200278_a().func_203905_a(hatsUnlocked10).func_215092_a(Advancements.getItemWithDamage(3), (ITextComponent)new TranslationTextComponent("hats.advancement.hatsUnlocked25.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.hatsUnlocked25.description"), null, FrameType.TASK, true, true, false).func_200275_a("hats_unlocked", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.HATS_UNLOCKED.func_192163_a(), (int)25)).func_203904_a(consumer, "hats:hats/hats_unlocked_25");
        Advancement hatsUnlocked50 = Advancement.Builder.func_200278_a().func_203905_a(hatsUnlocked25).func_215092_a(Advancements.getItemWithDamage(4), (ITextComponent)new TranslationTextComponent("hats.advancement.hatsUnlocked50.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.hatsUnlocked50.description"), null, FrameType.TASK, true, true, false).func_200275_a("hats_unlocked", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.HATS_UNLOCKED.func_192163_a(), (int)50)).func_203904_a(consumer, "hats:hats/hats_unlocked_50");
        Advancement variants50 = Advancement.Builder.func_200278_a().func_203905_a(hatsUnlocked50).func_215092_a(Advancements.getItemWithDamage(12), (ITextComponent)new TranslationTextComponent("hats.advancement.variants50.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.variants50.description"), null, FrameType.GOAL, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)500)).func_200275_a("variants", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.VARIANTS.func_192163_a(), (int)50)).func_203904_a(consumer, "hats:hats/variants_50");
        Advancement variants75 = Advancement.Builder.func_200278_a().func_203905_a(variants50).func_215092_a(Advancements.getItemWithDamage(13), (ITextComponent)new TranslationTextComponent("hats.advancement.variants75.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.variants75.description"), null, FrameType.GOAL, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)1000)).func_200275_a("variants", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.VARIANTS.func_192163_a(), (int)75)).func_203904_a(consumer, "hats:hats/variants_75");
        Advancement variants100 = Advancement.Builder.func_200278_a().func_203905_a(variants75).func_215092_a(Advancements.getItemWithDamage(14), (ITextComponent)new TranslationTextComponent("hats.advancement.variants100.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.variants100.description"), null, FrameType.CHALLENGE, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)5000)).func_200275_a("variants", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.VARIANTS.func_192163_a(), (int)100)).func_203904_a(consumer, ALL_VARIANTS.toString());
        Advancement accUnlocked1 = Advancement.Builder.func_200278_a().func_203905_a(hatsUnlocked1).func_215092_a(Advancements.getItemWithDamage(5), (ITextComponent)new TranslationTextComponent("hats.advancement.accUnlocked1.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.accUnlocked1.description"), null, FrameType.TASK, true, true, false).func_200275_a("acc_unlocked", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.ACC_UNLOCKED.func_192163_a(), (int)1)).func_203904_a(consumer, "hats:hats/acc_unlocked_1");
        Advancement accUnlocked10 = Advancement.Builder.func_200278_a().func_203905_a(accUnlocked1).func_215092_a(Advancements.getItemWithDamage(6), (ITextComponent)new TranslationTextComponent("hats.advancement.accUnlocked10.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.accUnlocked10.description"), null, FrameType.TASK, true, true, false).func_200275_a("acc_unlocked", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.ACC_UNLOCKED.func_192163_a(), (int)10)).func_203904_a(consumer, "hats:hats/acc_unlocked_10");
        Advancement accUnlocked25 = Advancement.Builder.func_200278_a().func_203905_a(accUnlocked10).func_215092_a(Advancements.getItemWithDamage(7), (ITextComponent)new TranslationTextComponent("hats.advancement.accUnlocked25.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.accUnlocked25.description"), null, FrameType.TASK, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)100)).func_200275_a("acc_unlocked", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.ACC_UNLOCKED.func_192163_a(), (int)25)).func_203904_a(consumer, "hats:hats/acc_unlocked_25");
        Advancement accUnlocked50 = Advancement.Builder.func_200278_a().func_203905_a(accUnlocked25).func_215092_a(Advancements.getItemWithDamage(8), (ITextComponent)new TranslationTextComponent("hats.advancement.accUnlocked50.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.accUnlocked50.description"), null, FrameType.GOAL, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)500)).func_200275_a("acc_unlocked", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.ACC_UNLOCKED.func_192163_a(), (int)50)).func_203904_a(consumer, "hats:hats/acc_unlocked_50");
        Advancement hatCount10 = Advancement.Builder.func_200278_a().func_203905_a(hatsUnlocked1).func_215092_a(Advancements.getItemWithDamage(9), (ITextComponent)new TranslationTextComponent("hats.advancement.hatCount10.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.hatCount10.description"), null, FrameType.TASK, true, true, false).func_200275_a("hat_count", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.HAT_COUNT.func_192163_a(), (int)10)).func_203904_a(consumer, "hats:hats/hat_count_10");
        Advancement hatCount25 = Advancement.Builder.func_200278_a().func_203905_a(hatCount10).func_215092_a(Advancements.getItemWithDamage(10), (ITextComponent)new TranslationTextComponent("hats.advancement.hatCount25.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.hatCount25.description"), null, FrameType.TASK, true, true, false).func_200275_a("hat_count", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.HAT_COUNT.func_192163_a(), (int)25)).func_203904_a(consumer, "hats:hats/hat_count_25");
        Advancement hatCount50 = Advancement.Builder.func_200278_a().func_203905_a(hatCount25).func_215092_a(Advancements.getItemWithDamage(11), (ITextComponent)new TranslationTextComponent("hats.advancement.hatCount50.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.hatCount50.description"), null, FrameType.CHALLENGE, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)500)).func_200275_a("hat_count", (ICriterionInstance)ValueAtOrAboveTrigger.Instance.count((ResourceLocation)CriteriaTriggers.HAT_COUNT.func_192163_a(), (int)50)).func_203904_a(consumer, "hats:hats/hat_count_50");
        Advancement killBossWithHat = Advancement.Builder.func_200278_a().func_203905_a(hatsUnlocked10).func_203902_a((IItemProvider)Blocks.field_196716_eW, (ITextComponent)new TranslationTextComponent("hats.advancement.killBossWithHat.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.killBossWithHat.description"), null, FrameType.CHALLENGE, true, true, false).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)new ResourceLocation("hats", "hat_launcher"))).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.KILL_BOSS_WITH_HAT.func_192163_a())).func_203904_a(consumer, "hats:hats/kill_boss_with_hat");
        Advancement craftHatLauncher = Advancement.Builder.func_200278_a().func_203905_a(killBossWithHat).func_215092_a(Advancements.getItemWithDamage(0), (ITextComponent)new TranslationTextComponent("hats.advancement.craftHatLauncher.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.craftHatLauncher.description"), null, FrameType.TASK, true, true, false).func_200275_a("get_launcher", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)Hats.Items.HAT_LAUNCHER.get()})).func_203904_a(consumer, "hats:hats/craft_hat_launcher");
        Advancement enchantHatLauncher = Advancement.Builder.func_200278_a().func_203905_a(craftHatLauncher).func_215092_a(Advancements.getItemEnchanted(), (ITextComponent)new TranslationTextComponent("hats.advancement.enchantHatLauncher.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.enchantHatLauncher.description"), null, FrameType.TASK, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)100)).func_200275_a("code_trigger", (ICriterionInstance)new EnchantedItemTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Hats.Items.HAT_LAUNCHER.get()).func_200310_b(), MinMaxBounds.IntBound.field_211347_e)).func_203904_a(consumer, "hats:hats/enchant_hat_launcher");
        Advancement changeMobHat = Advancement.Builder.func_200278_a().func_203905_a(craftHatLauncher).func_203902_a((IItemProvider)Blocks.field_196708_eQ, (ITextComponent)new TranslationTextComponent("hats.advancement.changeMobHat.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.changeMobHat.description"), null, FrameType.TASK, true, true, false).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.CHANGE_MOB_HAT.func_192163_a())).func_203904_a(consumer, "hats:hats/change_mob_hat");
        Advancement rogueHat = Advancement.Builder.func_200278_a().func_203905_a(changeMobHat).func_203902_a((IItemProvider)Blocks.field_196714_eU, (ITextComponent)new TranslationTextComponent("hats.advancement.rogueHat.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.rogueHat.description"), null, FrameType.CHALLENGE, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)100)).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.ROGUE_HAT.func_192163_a())).func_203904_a(consumer, "hats:hats/rogue_hat");
        Advancement pigChunHat = Advancement.Builder.func_200278_a().func_203905_a(rogueHat).func_215092_a(Advancements.getiChunHead(), (ITextComponent)new TranslationTextComponent("hats.advancement.pigChunHat.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.pigChunHat.description"), null, FrameType.CHALLENGE, true, true, true).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)500)).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.PIG_CHUN_HAT.func_192163_a())).func_203904_a(consumer, "hats:hats/pig_chun_hat");
        Advancement wearHat = Advancement.Builder.func_200278_a().func_203905_a(hatsUnlocked1).func_215092_a(Advancements.getItemWithDamage(1), (ITextComponent)new TranslationTextComponent("hats.advancement.wearHat.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.wearHat.description"), null, FrameType.TASK, true, true, false).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.WEAR_HAT.func_192163_a())).func_203904_a(consumer, "hats:hats/wear_hat");
        Advancement wearHatWithAccessory = Advancement.Builder.func_200278_a().func_203905_a(wearHat).func_215092_a(Advancements.getItemWithDamage(15), (ITextComponent)new TranslationTextComponent("hats.advancement.wearHatWithAccessory.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.wearHatWithAccessory.description"), null, FrameType.GOAL, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)50)).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.WEAR_HAT_WITH_ACCESSORY.func_192163_a())).func_203904_a(consumer, "hats:hats/wear_hat_with_accessory");
        Advancement colouriseHat = Advancement.Builder.func_200278_a().func_203905_a(wearHat).func_215092_a(Advancements.getItemWithDamage(16), (ITextComponent)new TranslationTextComponent("hats.advancement.colouriseHat.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.colouriseHat.description"), null, FrameType.GOAL, true, true, false).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)50)).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.COLOURISE_HAT.func_192163_a())).func_203904_a(consumer, "hats:hats/colourise_hat");
        Advancement hatWithThreeOrMoreAccessories = Advancement.Builder.func_200278_a().func_203905_a(accUnlocked1).func_215092_a(Advancements.getItemWithDamage(17), (ITextComponent)new TranslationTextComponent("hats.advancement.hatWithThreeOrMoreAccessories.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.hatWithThreeOrMoreAccessories.description"), null, FrameType.CHALLENGE, true, true, true).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)50)).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.HAT_WITH_THREE_OR_MORE_ACCESSORIES.func_192163_a())).func_203904_a(consumer, "hats:hats/hat_with_three_or_more_accessories");
        Advancement accessoryInAccessory = Advancement.Builder.func_200278_a().func_203905_a(accUnlocked1).func_215092_a(Advancements.getItemWithDamage(18), (ITextComponent)new TranslationTextComponent("hats.advancement.accessoryInAccessory.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.accessoryInAccessory.description"), null, FrameType.TASK, true, true, true).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.ACCESSORY_IN_ACCESSORY.func_192163_a())).func_203904_a(consumer, "hats:hats/accessory_in_accessory");
        Advancement nonVanillaHat = Advancement.Builder.func_200278_a().func_203905_a(hatsUnlocked1).func_215092_a(Advancements.getItemWithDamage(19), (ITextComponent)new TranslationTextComponent("hats.advancement.nonVanillaHat.title"), (ITextComponent)new TranslationTextComponent("hats.advancement.nonVanillaHat.description"), null, FrameType.TASK, true, true, true).func_200275_a("code_trigger", (ICriterionInstance)CodeDefinedTrigger.Instance.create((ResourceLocation)CriteriaTriggers.NON_VANILLA_HAT.func_192163_a())).func_203904_a(consumer, "hats:hats/non_vanilla_hat");
    }

    private static ItemStack getItemWithDamage(int i) {
        ItemStack is = new ItemStack((IItemProvider)Hats.Items.HAT_LAUNCHER.get());
        is.func_196085_b(i);
        is.func_77978_p().func_82580_o("hats_hatPart");
        return is;
    }

    private static ItemStack getItemEnchanted() {
        ItemStack is = Advancements.getItemWithDamage(0);
        is.func_77966_a(Enchantments.field_185309_u, 1);
        return is;
    }

    private static ItemStack getiChunHead() {
        ItemStack is = new ItemStack((IItemProvider)Items.field_196184_dx);
        CompoundNBT tag = new CompoundNBT();
        tag.func_186854_a("Id", UUIDTypeAdapter.fromString((String)"0b7509f0-2458-4160-9ce1-2772b9a45ac2"));
        CompoundNBT props = new CompoundNBT();
        ListNBT tex = new ListNBT();
        CompoundNBT actualTex = new CompoundNBT();
        actualTex.func_74778_a("Value", "ewogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTVmM2M3MGJiNmMxNGU0MjM5Y2IxMzA5YWNjMDUzZTBiOGE3YjFkYTNlMzhlN2RhMTVlNzVkNjE3YWY5OTZmNSIKICAgIH0KICB9Cn0=");
        tex.add((Object)actualTex);
        props.func_218657_a("textures", (INBT)tex);
        tag.func_218657_a("Properties", (INBT)props);
        is.func_196082_o().func_218657_a("SkullOwner", (INBT)tag);
        return is;
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new AdvancementGen(gen, (Consumer)new Advancements()));
        }
    }

    public static void triggerHatCount(ServerPlayerEntity player, int count) {
        CriteriaTriggers.HAT_COUNT.test(player, count);
    }

    public static void checkHatsAndAccessoriesUnlocked(ServerPlayerEntity player) {
        if (HatHandler.useInventory((PlayerEntity)player)) {
            List<HatsSavedData.HatPart> playerInventory = HatHandler.getPlayerInventory((PlayerEntity)player);
            playerInventory = playerInventory.stream().filter(hatPart -> {
                HatInfo info = HatResourceHandler.getInfo(hatPart);
                return info == null || info.contributorUUID == null;
            }).collect(Collectors.toList());
            int hatCount = playerInventory.size();
            int accessoriesCount = 0;
            for (HatsSavedData.HatPart hatPart2 : playerInventory) {
                accessoriesCount += hatPart2.accessoriesUnlocked();
            }
            CriteriaTriggers.HATS_UNLOCKED.test(player, hatCount);
            CriteriaTriggers.ACC_UNLOCKED.test(player, accessoriesCount);
            List<HatsSavedData.HatPart> hatPartSource = new ArrayList<HatsSavedData.HatPart>(HatResourceHandler.HAT_PARTS);
            hatPartSource = hatPartSource.stream().filter(hatPart -> {
                HatInfo info = HatResourceHandler.getInfo(hatPart);
                return info == null || info.contributorUUID == null;
            }).collect(Collectors.toList());
            int variantCount = hatPartSource.size();
            for (HatsSavedData.HatPart hatPart3 : hatPartSource) {
                variantCount += hatPart3.accessoriesUnlocked();
            }
            int variantPercent = (int)Math.floor((float)(hatCount + accessoriesCount) / (float)variantCount * 100.0f);
            CriteriaTriggers.VARIANTS.test(player, variantPercent);
        }
    }

    public static class CriteriaTriggers {
        public static final ValueAtOrAboveTrigger HATS_UNLOCKED = CriteriaTriggers.register(new ValueAtOrAboveTrigger(new ResourceLocation("hats", "hats_unlocked")));
        public static final ValueAtOrAboveTrigger ACC_UNLOCKED = CriteriaTriggers.register(new ValueAtOrAboveTrigger(new ResourceLocation("hats", "acc_unlocked")));
        public static final ValueAtOrAboveTrigger VARIANTS = CriteriaTriggers.register(new ValueAtOrAboveTrigger(new ResourceLocation("hats", "variants")));
        public static final ValueAtOrAboveTrigger HAT_COUNT = CriteriaTriggers.register(new ValueAtOrAboveTrigger(new ResourceLocation("hats", "hat_count")));
        public static final CodeDefinedTrigger KILL_BOSS_WITH_HAT = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "kill_boss_with_hat")));
        public static final CodeDefinedTrigger CHANGE_MOB_HAT = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "change_mob_hat")));
        public static final CodeDefinedTrigger ROGUE_HAT = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "rogue_hat")));
        public static final CodeDefinedTrigger PIG_CHUN_HAT = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "pig_chun_hat")));
        public static final CodeDefinedTrigger WEAR_HAT = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "wear_hat")));
        public static final CodeDefinedTrigger WEAR_HAT_WITH_ACCESSORY = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "wear_hat_with_accessory")));
        public static final CodeDefinedTrigger COLOURISE_HAT = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "colourise_hat")));
        public static final CodeDefinedTrigger HAT_WITH_THREE_OR_MORE_ACCESSORIES = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "hat_with_three_or_more_accessories")));
        public static final CodeDefinedTrigger ACCESSORY_IN_ACCESSORY = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "accessory_in_accessory")));
        public static final CodeDefinedTrigger NON_VANILLA_HAT = CriteriaTriggers.register(new CodeDefinedTrigger(new ResourceLocation("hats", "non_vanilla_hat")));

        private static <T extends ICriterionTrigger<?>> T register(T criterion) {
            return (T)net.minecraft.advancements.CriteriaTriggers.func_192118_a(criterion);
        }

        public static void init() {
        }
    }
}

