/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.client.render.ItemRenderHatLauncher;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.entity.EntityHat;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.packet.PacketEntityHatDetails;
import me.ichun.mods.hats.common.packet.PacketEntityHatEntityDetails;
import me.ichun.mods.hats.common.packet.PacketRehatify;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.item.DualHandedItem;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.PacketDistributor;

public class ItemHatLauncher
extends Item
implements DualHandedItem {
    public static final String STACK_HAT_PART_TAG = "hats_hatPart";

    public ItemHatLauncher(Item.Properties properties) {
        super((Item.Properties)DistExecutor.unsafeRunForDist(() -> () -> ItemHatLauncher.attachISTER(properties), () -> () -> properties));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Item.Properties attachISTER(Item.Properties properties) {
        return properties.setISTER(() -> () -> ItemRenderHatLauncher.INSTANCE);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.field_72995_K && !Hats.eventHandlerClient.serverHasMod) {
            return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
        }
        ItemStack is = player.func_184586_b(hand);
        if (DualHandedItem.getUsableDualHandedItem((LivingEntity)player) == is) {
            HatsSavedData.HatPart part = null;
            if (!player.func_225608_bj_()) {
                part = HatHandler.getHatPart(is).createCopy();
                if (part.name.equals(":random")) {
                    if (world.field_72995_K) {
                        ArrayList source = HatHandler.getHatSource(player).stream().filter(hatPart -> hatPart.count > 0).collect(Collectors.toCollection(ArrayList::new));
                        if (source.isEmpty()) {
                            part = null;
                        }
                    } else {
                        part = HatHandler.getRandomHat(player);
                    }
                } else if (!HatHandler.playerHasHat(player, part, true)) {
                    part = null;
                }
            }
            if (part != null && !part.name.isEmpty() && part.count > 0) {
                if (!world.field_72995_K) {
                    EntityHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)Hats.Sounds.TUBE.get()), (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (float)(0.9f + (player.func_70681_au().nextFloat() * 2.0f - 1.0f) * 0.075f));
                    EntityHat hat = new EntityHat((EntityType)Hats.EntityTypes.HAT.get(), player.field_70170_p).setHatPart(part).setLastInteracted((LivingEntity)player);
                    double pX = player.func_226277_ct_();
                    double pZ = player.func_226281_cx_();
                    Vector3d rot = EntityHelper.getVectorForRotation((float)0.0f, (float)(player.field_70177_z + 90.0f));
                    switch (DualHandedItem.getHandSide((LivingEntity)player, (ItemStack)DualHandedItem.getUsableDualHandedItem((LivingEntity)player))) {
                        case RIGHT: {
                            pX += rot.field_72450_a * 0.25;
                            pZ += rot.field_72449_c * 0.25;
                            break;
                        }
                        case LEFT: {
                            pX -= rot.field_72450_a * 0.25;
                            pZ -= rot.field_72449_c * 0.25;
                        }
                    }
                    hat.func_70012_b(pX, player.func_226278_cu_() + (double)player.func_70047_e() - (double)((hat.hatDims[1] - hat.hatDims[0]) / 32.0f / 1.8f), pZ, player.field_70177_z, player.field_70125_A);
                    int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)is);
                    if (k > 0) {
                        hat.setKnockbackStrength(k);
                    }
                    float momentum = 0.5f;
                    int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)is);
                    if (j > 0) {
                        momentum = (float)((double)momentum + (double)j * 0.25);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)is) > 0) {
                        hat.func_70015_d(100);
                    }
                    hat.setThrowableHeading(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)), -MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)), MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)), momentum, 0.4f);
                    player.field_70170_p.func_217376_c((Entity)hat);
                    Hats.channel.sendTo((AbstractPacket)new PacketEntityHatEntityDetails(hat.func_145782_y(), hat.hatPart.write(new CompoundNBT())), PacketDistributor.TRACKING_ENTITY.with(() -> hat));
                    if (HatHandler.useInventory(player)) {
                        HatHandler.removeOneFromInventory((ServerPlayerEntity)player, part);
                    }
                } else {
                    Hats.eventHandlerClient.nudgeHand(player);
                }
            } else {
                EntityRayTraceResult entityRayTraceResult;
                Entity entity;
                boolean flag = false;
                RayTraceResult entityLook = EntityHelper.getEntityLook((Entity)player, (double)4.0);
                if (entityLook.func_216346_c() == RayTraceResult.Type.ENTITY && (entity = (entityRayTraceResult = (EntityRayTraceResult)entityLook).func_216348_a()) instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)entity;
                    HatsSavedData.HatPart entPart = HatHandler.getHatPart(target);
                    if (!(entPart.name.isEmpty() || target instanceof PlayerEntity && !Hats.configServer.hatLauncherReplacesPlayerHat)) {
                        if (!player.field_70170_p.field_72995_K) {
                            EntityHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)Hats.Sounds.TUBE.get()), (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (float)(0.9f + (player.func_70681_au().nextFloat() * 2.0f - 1.0f) * 0.075f));
                            EntityHat hat = new EntityHat((EntityType)Hats.EntityTypes.HAT.get(), target.field_70170_p).setHatPart(entPart.createCopy()).setLastInteracted(target);
                            hat.func_70012_b(target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e() - (double)((hat.hatDims[1] - hat.hatDims[0]) / 32.0f / 1.8f), target.func_226281_cx_(), target.field_70177_z, target.field_70125_A);
                            hat.func_213317_d(new Vector3d(target.func_70681_au().nextGaussian() * (double)0.2f, (double)(0.2f + target.func_70681_au().nextFloat() * 0.2f), target.func_70681_au().nextGaussian() * (double)0.2f));
                            target.field_70170_p.func_217376_c((Entity)hat);
                            entPart.copy(new HatsSavedData.HatPart());
                            HashMap<Integer, HatsSavedData.HatPart> entIdToHat = new HashMap<Integer, HatsSavedData.HatPart>();
                            entIdToHat.put(target.func_145782_y(), entPart);
                            Hats.channel.sendTo((AbstractPacket)new PacketEntityHatDetails(entIdToHat), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target));
                            Hats.channel.sendTo((AbstractPacket)new PacketRehatify(target.func_145782_y()), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target));
                            Hats.channel.sendTo((AbstractPacket)new PacketEntityHatEntityDetails(hat.func_145782_y(), hat.hatPart.write(new CompoundNBT())), PacketDistributor.TRACKING_ENTITY.with(() -> hat));
                        }
                        player.func_226292_a_(hand, true);
                        flag = true;
                    }
                }
                if (!flag) {
                    if (!world.field_72995_K) {
                        EntityHelper.playSound((Entity)player, (SoundEvent)SoundEvents.field_187909_gi, (SoundCategory)SoundCategory.PLAYERS, (float)0.6f, (float)(0.9f + (player.func_70681_au().nextFloat() * 2.0f - 1.0f) * 0.075f));
                    } else {
                        this.openHatsGui(player, is);
                    }
                }
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        HatsSavedData.HatPart entPart = HatHandler.getHatPart(target);
        if (!(entPart.name.isEmpty() || target instanceof PlayerEntity && !Hats.configServer.hatLauncherReplacesPlayerHat)) {
            if (!attacker.field_70170_p.field_72995_K) {
                EntityHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)Hats.Sounds.TUBE.get()), (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (float)(0.9f + (attacker.func_70681_au().nextFloat() * 2.0f - 1.0f) * 0.075f));
                EntityHat hat = new EntityHat((EntityType)Hats.EntityTypes.HAT.get(), target.field_70170_p).setHatPart(entPart.createCopy()).setLastInteracted(target);
                hat.func_70012_b(target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e() - (double)((hat.hatDims[1] - hat.hatDims[0]) / 32.0f / 1.8f), target.func_226281_cx_(), target.field_70177_z, target.field_70125_A);
                hat.func_213317_d(new Vector3d(target.func_70681_au().nextGaussian() * (double)0.2f, (double)(0.2f + target.func_70681_au().nextFloat() * 0.2f), target.func_70681_au().nextGaussian() * (double)0.2f));
                target.field_70170_p.func_217376_c((Entity)hat);
                entPart.copy(new HatsSavedData.HatPart());
                HashMap<Integer, HatsSavedData.HatPart> entIdToHat = new HashMap<Integer, HatsSavedData.HatPart>();
                entIdToHat.put(target.func_145782_y(), entPart);
                Hats.channel.sendTo((AbstractPacket)new PacketEntityHatDetails(entIdToHat), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target));
                Hats.channel.sendTo((AbstractPacket)new PacketRehatify(target.func_145782_y()), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target));
                Hats.channel.sendTo((AbstractPacket)new PacketEntityHatEntityDetails(hat.func_145782_y(), hat.hatPart.write(new CompoundNBT())), PacketDistributor.TRACKING_ENTITY.with(() -> hat));
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openHatsGui(@Nonnull PlayerEntity player, @Nonnull ItemStack is) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == player) {
            mc.func_147108_a((Screen)new WorkspaceHats(mc.field_71462_r, true, (LivingEntity)player, is));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185309_u || enchantment == Enchantments.field_185310_v || enchantment == Enchantments.field_185311_w;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 22;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)book);
        for (Enchantment enchantment : enchantments.keySet()) {
            if (this.canApplyAtEnchantingTable(stack, enchantment)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        HatsSavedData.HatPart defPart = new HatsSavedData.HatPart(":random");
        HatsSavedData.HatPart.CapProvider capProvider = new HatsSavedData.HatPart.CapProvider(defPart);
        if (nbt != null) {
            capProvider.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        defPart.isShowing = true;
        stack.func_196082_o().func_218657_a(STACK_HAT_PART_TAG, (INBT)defPart.write(new CompoundNBT()));
        return capProvider;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }
}

