/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.packet.PacketHatFragment;
import me.ichun.mods.hats.common.packet.PacketHatsList;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowConfirmation;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowPopup;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketHatsListResponse
extends AbstractPacket {
    public HashSet<String> serverMissing = new HashSet();
    public HashSet<String> clientMissing = new HashSet();

    public PacketHatsListResponse() {
    }

    public PacketHatsListResponse(HashSet<String> serverMissing, HashSet<String> clientMissing) {
        this.serverMissing = serverMissing;
        this.clientMissing = clientMissing;
    }

    public void writeTo(PacketBuffer buf) {
        buf.writeInt(this.serverMissing.size());
        this.serverMissing.forEach(arg_0 -> ((PacketBuffer)buf).func_180714_a(arg_0));
        buf.writeInt(this.clientMissing.size());
        this.clientMissing.forEach(arg_0 -> ((PacketBuffer)buf).func_180714_a(arg_0));
    }

    public void readFrom(PacketBuffer buf) {
        int i;
        int count = buf.readInt();
        for (i = 0; i < count; ++i) {
            this.serverMissing.add(this.readString(buf));
        }
        count = buf.readInt();
        for (i = 0; i < count; ++i) {
            this.clientMissing.add(this.readString(buf));
        }
    }

    public void process(NetworkEvent.Context context) {
        context.enqueueWork(this::handleClient);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof WorkspaceHats) {
            WorkspaceHats workspaceHats = (WorkspaceHats)mc.field_71462_r;
            if (this.serverMissing.isEmpty() && this.clientMissing.isEmpty()) {
                for (int i = 0; i < workspaceHats.windows.size(); ++i) {
                    Window window = (Window)workspaceHats.windows.get(i);
                    if (!(window instanceof WindowPopup)) continue;
                    workspaceHats.removeWindow(window);
                    break;
                }
                workspaceHats.popup(0.55, 0.55, w -> {}, I18n.func_135052_a((String)"hats.gui.window.management.sync.noDifferences", (Object[])new Object[0]));
            } else {
                ArrayList<String> serverMissingList = new ArrayList<String>(this.serverMissing);
                ArrayList<String> clientMissingList = new ArrayList<String>(this.clientMissing);
                Collections.sort(serverMissingList);
                Collections.sort(clientMissingList);
                StringBuilder sb = new StringBuilder(I18n.func_135052_a((String)"hats.gui.window.management.sync.issue", (Object[])new Object[0])).append("\n\n");
                if (!serverMissingList.isEmpty()) {
                    sb.append(I18n.func_135052_a((String)"hats.gui.window.management.sync.serverMissing", (Object[])new Object[0])).append("\n");
                    for (String s : serverMissingList) {
                        sb.append(s);
                        sb.append("\n");
                    }
                    sb.append("\n");
                }
                if (!clientMissingList.isEmpty()) {
                    sb.append(I18n.func_135052_a((String)"hats.gui.window.management.sync.clientMissing", (Object[])new Object[0])).append("\n");
                    for (String s : clientMissingList) {
                        sb.append(s);
                        sb.append("\n");
                    }
                    sb.append("\n");
                }
                sb.append(I18n.func_135052_a((String)"hats.gui.window.management.sync.syncReq", (Object[])new Object[0]));
                WindowConfirmation.popup((Workspace)workspaceHats, (double)0.8, (double)0.8, (String)sb.toString(), w -> {
                    Hats.channel.sendToServer((AbstractPacket)new PacketHatsList(this.clientMissing, true));
                    for (String s : serverMissingList) {
                        HatInfo info = HatResourceHandler.getInfoFromFullName(s);
                        if (info == null || info.project.saveFile == null) continue;
                        try {
                            int maxFile = 31000;
                            String origin = Minecraft.func_71410_x().func_110432_I().func_111285_a();
                            String md5 = IOUtil.getMD5Checksum((File)info.project.saveFile);
                            byte[] data = Files.readAllBytes(info.project.saveFile.toPath());
                            String fileName = info.project.saveFile.getName();
                            int fileSize = data.length;
                            int packetsToSend = (int)Math.ceil((float)fileSize / 31000.0f);
                            int packetCount = 0;
                            int offset = 0;
                            while (fileSize > 0) {
                                int index;
                                byte[] fileBytes = new byte[Math.min(fileSize, 31000)];
                                for (index = 0; index < fileBytes.length; ++index) {
                                    fileBytes[index] = data[index + offset];
                                }
                                Hats.channel.sendToServer((AbstractPacket)new PacketHatFragment(fileName, packetsToSend, packetCount, fileBytes, origin, md5));
                                ++packetCount;
                                fileSize -= fileBytes.length;
                                offset += index;
                            }
                        }
                        catch (Exception e) {
                            Hats.LOGGER.error("Error creating hat as packet fragment: {}", (Object)s);
                            e.printStackTrace();
                        }
                    }
                }, w -> {});
            }
        }
    }
}

