/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import me.ichun.mods.ichunutil.common.head.HeadInfo;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.io.FileUtils;

public class PacketHeadInfos
extends AbstractPacket {
    public HashSet<String> headInfos = new HashSet();

    public PacketHeadInfos() {
    }

    public PacketHeadInfos(HashSet<String> heads) {
        this.headInfos = heads;
    }

    public void writeTo(PacketBuffer buf) {
        buf.writeInt(this.headInfos.size());
        this.headInfos.forEach(arg_0 -> ((PacketBuffer)buf).func_180714_a(arg_0));
    }

    public void readFrom(PacketBuffer buf) {
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.headInfos.add(this.readString(buf));
        }
    }

    public void process(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            for (String json : this.headInfos) {
                try {
                    HeadInfo info = (HeadInfo)HeadHandler.GSON.fromJson(json, HeadInfo.class);
                    if (info != null && info.forClass != null && HeadHandler.readHeadInfoJson((String)json)) {
                        String className = info.forClass.substring(info.forClass.lastIndexOf(".") + 1);
                        File file = new File(HeadHandler.getHeadsDir().resolve("FromServer").toFile(), className);
                        file.mkdirs();
                        File file2 = new File(file, className);
                        FileUtils.writeStringToFile((File)file2, (String)json, (Charset)StandardCharsets.UTF_8);
                        Hats.LOGGER.info("Received HeadInfo from server for class: {}", (Object)info.forClass);
                        continue;
                    }
                    Hats.LOGGER.warn("Received erroneous HeadInfo from server: {}", (Object)json);
                }
                catch (JsonSyntaxException | IOException | ClassNotFoundException e) {
                    Hats.LOGGER.warn("Received erroneous HeadInfo from server: {}", (Object)json);
                    e.printStackTrace();
                }
            }
        });
    }
}

