/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.genetics.Genome;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.renderer.TextureLayer;

public class HorseDebug {
    public static boolean showDebug(EntityPlayer player) {
        if (!HorseConfig.enableDebugInfo()) {
            return false;
        }
        return HorseDebug.showBasicDebug(player) || HorseDebug.showGeneDebug(player);
    }

    public static boolean showBasicDebug(EntityPlayer player) {
        ItemStack itemStack = player.func_184592_cb();
        if (itemStack != null && itemStack.func_77973_b() == Items.field_151055_y) {
            return true;
        }
        ItemStack inHand = player.func_184614_ca();
        return inHand != null && inHand.func_77973_b() == Items.field_151055_y;
    }

    public static boolean showGeneDebug(EntityPlayer player) {
        ItemStack itemStack = player.func_184592_cb();
        if (itemStack != null && itemStack.func_77973_b() == Items.field_190929_cY) {
            return true;
        }
        ItemStack inHand = player.func_184614_ca();
        return inHand != null && inHand.func_77973_b() == Items.field_190929_cY;
    }

    public static ArrayList<String> debugNamedGenes(Genome genome) {
        ArrayList<String> list = new ArrayList<String>();
        for (String gene : genome.listGenes()) {
            String s = gene + ": ";
            s = s + genome.getAllele(gene, 0) + ", ";
            s = s + genome.getAllele(gene, 1);
            list.add(s);
        }
        return list;
    }

    public static ArrayList<String> debugStatGenes(Genome genome) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> iterator = genome.listGenericChromosomes().iterator();
        while (iterator.hasNext()) {
            String stat;
            String s = stat = iterator.next();
            s = s + ": " + genome.countBits(genome.getChromosome(stat));
            s = s + " (";
            int val = genome.getChromosome(stat);
            for (int i = 16; i > 0; --i) {
                s = s + (val >>> 2 * i - 1 & 1);
                s = s + (val >>> 2 * i - 2 & 1);
                if (i <= 1) continue;
                s = s + " ";
            }
            s = s + ")";
            list.add(s);
        }
        return list;
    }

    private void addSubStats(Genome genome, List<String> list) {
        Iterator<String> iterator = genome.listStats().iterator();
        while (iterator.hasNext()) {
            String stat;
            String s = stat = iterator.next();
            s = s + ": " + genome.getStatValue(stat);
            s = s + " (";
            int val = genome.getRawStat(stat);
            s = s + Genome.chrToStr(val);
            s = s + ")";
            list.add(s);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderOverlayEvent(RenderGameOverlayEvent.Text event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!HorseDebug.showDebug((EntityPlayer)player)) {
            return;
        }
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && mouseOver.field_72308_g != null && mouseOver.field_72308_g instanceof IGeneticEntity) {
            IGeneticEntity entity = (IGeneticEntity)mouseOver.field_72308_g;
            if (HorseDebug.showGeneDebug((EntityPlayer)player)) {
                for (String s : HorseDebug.debugStatGenes(entity.getGenes())) {
                    event.getLeft().add(s);
                }
            }
            if (HorseDebug.showBasicDebug((EntityPlayer)player) && entity instanceof EntityAgeable) {
                event.getLeft().add("Growing age: " + ((EntityAgeable)entity).func_70874_b());
            }
            if (HorseDebug.showBasicDebug((EntityPlayer)player) && entity instanceof AbstractHorseGenetic) {
                event.getLeft().add("Display age: " + ((AbstractHorseGenetic)entity).getDisplayAge());
                event.getLeft().add("Pregnant since: " + ((AbstractHorseGenetic)entity).getPregnancyStart());
            }
            if (HorseDebug.showBasicDebug((EntityPlayer)player)) {
                for (TextureLayer l : entity.getGenes().getVariantTexturePaths()) {
                    if (l == null) continue;
                    event.getLeft().add(l.toString());
                }
            }
            if (HorseDebug.showGeneDebug((EntityPlayer)player)) {
                for (String s : HorseDebug.debugNamedGenes(entity.getGenes())) {
                    event.getRight().add(s);
                }
            }
        }
    }
}

