/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sekelsta.horse_colors.genetics.Genome;

@SideOnly(value=Side.CLIENT)
public class GeneBookScreen
extends GuiScreen {
    private static final ResourceLocation BOOK_GUI_TEXTURES = new ResourceLocation("horse_colors:textures/gui/book.png");
    private static final int linesPerPage = 14;
    private static final int lineWrapWidth = 124;
    private static final int bookWidth = 360;
    private static final int bookHeight = 192;
    private static final int pageWidth = 130;
    private static final int pageCrease = 10;
    int currPage = 0;
    private Genome genome;
    private List<List<String>> contents;
    private List<String> pages;
    private ChangePageButton buttonNextPage;
    private ChangePageButton buttonPreviousPage;
    private GuiButton buttonDone;
    private final boolean pageTurnSounds = true;

    public GeneBookScreen(Genome genomeIn) {
        this.genome = genomeIn;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BOOK_GUI_TEXTURES);
        int x = (this.field_146294_l - 360) / 2;
        int y = 2;
        GeneBookScreen.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)360, (int)192, (float)512.0f, (float)256.0f);
        this.renderPage(this.currPage, this.field_146294_l / 2 - 130 - 10);
        if (this.getPageCount() > this.currPage + 1) {
            this.renderPage(this.currPage + 1, this.field_146294_l / 2 + 10);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void renderPage(int pagenum, int x) {
        String pageindicator = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{pagenum + 1, this.getPageCount()});
        String pagetext = this.getPageText(pagenum);
        int j1 = this.getTextWidth(pageindicator);
        this.field_146289_q.func_78276_b(pageindicator, x - j1 + 130, 18, 0);
        this.field_146289_q.func_78279_b(pagetext, x, 32, 124, 0);
    }

    public void func_73866_w_() {
        this.contents = this.genome.getBookContents();
        this.pages = new ArrayList<String>();
        for (int ch = 0; ch < this.contents.size(); ++ch) {
            String s = "";
            int lines = 0;
            for (int ln = 0; ln < this.contents.get(ch).size(); ++ln) {
                String text = this.contents.get(ch).get(ln);
                int wrapped = this.field_146289_q.func_78271_c(text, 124).size();
                if (lines + wrapped > 14 && lines > 0) {
                    this.pages.add(s);
                    s = "";
                    lines = 0;
                }
                lines += wrapped;
                s = s + text + "\n";
            }
            this.pages.add(s);
        }
        this.addDoneButton();
        this.addChangePageButtons();
    }

    protected void addDoneButton() {
        this.buttonDone = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
    }

    protected void addChangePageButtons() {
        int x1 = (this.field_146294_l - 360) / 2;
        int x2 = (this.field_146294_l + 360) / 2;
        int j = 2;
        int y = 159;
        this.buttonNextPage = (ChangePageButton)this.func_189646_b(new ChangePageButton(1, x2 - 43 - 24, y, true));
        this.buttonPreviousPage = (ChangePageButton)this.func_189646_b(new ChangePageButton(2, x1 + 43, y, false));
        this.updateButtons();
    }

    private int getPageCount() {
        return this.pages.size();
    }

    protected void previousPage() {
        this.currPage = Math.max(this.currPage - 2, 0);
        this.updateButtons();
    }

    protected void nextPage() {
        if (this.currPage < this.getPageCount() - 2) {
            this.currPage += 2;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currPage < this.getPageCount() - 2;
        this.buttonPreviousPage.field_146125_m = this.currPage > 0;
    }

    private String getPageText(int pagenum) {
        if (this.pages.size() > 0) {
            return this.pages.get(pagenum);
        }
        return "";
    }

    private int getTextWidth(String text) {
        return this.field_146289_q.func_78256_a(text);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                this.nextPage();
            } else if (button.field_146127_k == 2) {
                this.previousPage();
            }
            this.updateButtons();
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class ChangePageButton
    extends GuiButton {
        private final boolean isForward;

        public ChangePageButton(int buttonId, int x, int y, boolean isForwardIn) {
            super(buttonId, x, y, 23, 13, "");
            this.isForward = isForwardIn;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BOOK_GUI_TEXTURES);
                int i = 0;
                int j = 192;
                if (flag) {
                    i += 23;
                }
                if (!this.isForward) {
                    j += 13;
                }
                ChangePageButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)i, (float)j, (int)23, (int)13, (float)512.0f, (float)256.0f);
            }
        }
    }
}

