/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import sekelsta.horse_colors.HorseColors;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.DonkeyGeneticEntity;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.entity.MuleGeneticEntity;
import sekelsta.horse_colors.entity.ai.GenderedBreedGoal;
import sekelsta.horse_colors.entity.ai.RandomWalkGroundTie;
import sekelsta.horse_colors.genetics.HorseGenome;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.genetics.Species;
import sekelsta.horse_colors.genetics.breed.BaseEquine;
import sekelsta.horse_colors.genetics.breed.Breed;
import sekelsta.horse_colors.item.ModItems;

public abstract class AbstractHorseGenetic
extends AbstractChestHorse
implements IGeneticEntity {
    protected HorseGenome genes;
    protected static final DataParameter<Integer> HORSE_VARIANT = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_VARIANT2 = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_VARIANT3 = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_VARIANT4 = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_VARIANT5 = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_SPEED = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_JUMP = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_HEALTH = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_MHC1 = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_MHC2 = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_IMMUNE = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_RANDOM = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> DISPLAY_AGE = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> IS_CASTRATED = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> PREGNANT_SINCE = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int trueAge;
    protected static final UUID CSNB_SPEED_UUID = UUID.fromString("84ca527a-5c70-4336-a737-ae3f6d40ef45");
    protected static final UUID CSNB_JUMP_UUID = UUID.fromString("72323326-888b-4e46-bf52-f669600642f7");
    protected static final AttributeModifier CSNB_SPEED_MODIFIER = new AttributeModifier(CSNB_SPEED_UUID, "CSNB speed penalty", -0.6, 2).func_111168_a(false);
    protected static final AttributeModifier CSNB_JUMP_MODIFIER = new AttributeModifier(CSNB_JUMP_UUID, "CSNB jump penalty", -0.6, 2).func_111168_a(false);
    protected static final int HORSE_GENETICS_VERSION = 1;
    protected List<AbstractHorseGenetic> unbornChildren = new ArrayList<AbstractHorseGenetic>();

    public AbstractHorseGenetic(World worldIn) {
        super(worldIn);
        this.setChromosome("random", this.field_70146_Z.nextInt());
        this.setMale(this.field_70146_Z.nextBoolean());
        this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)-1);
    }

    public void copyAbstractHorse(AbstractHorse horse) {
        this.randomize();
        this.func_70012_b(horse.field_70165_t, horse.field_70163_u, horse.field_70161_v, horse.field_70177_z, horse.field_70125_A);
        this.func_110234_j(horse.func_110248_bS());
        this.func_110238_s(horse.func_110252_cg());
        this.func_70873_a(horse.func_70874_b());
        this.trueAge = horse.func_70874_b();
        ContainerHorseChest inv = (ContainerHorseChest)ReflectionHelper.getPrivateValue(AbstractHorse.class, (Object)horse, (String[])new String[]{"horseChest", "field_110296_bG"});
        this.field_110296_bG.func_70299_a(0, inv.func_70301_a(0));
        this.field_110296_bG.func_70299_a(1, inv.func_70301_a(1));
        this.func_110232_cE();
        double health = horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(health);
        double jump = horse.func_110148_a(field_110271_bv).func_111125_b();
        this.func_110148_a(field_110271_bv).func_111128_a(jump);
        double speed = horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed);
        this.useGeneticAttributes();
    }

    @Override
    public HorseGenome getGenes() {
        return this.genes;
    }

    public abstract boolean fluffyTail();

    public abstract boolean longEars();

    public abstract boolean thinMane();

    @Override
    public abstract Species getSpecies();

    public boolean canEquipChest() {
        return true;
    }

    @Override
    public Random getRand() {
        return super.func_70681_au();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRunAroundLikeCrazy((AbstractHorse)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new GenderedBreedGoal((EntityAnimal)this, 1.0, AbstractHorse.class));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new RandomWalkGroundTie((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HORSE_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_VARIANT2, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_VARIANT3, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_VARIANT4, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_VARIANT5, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_SPEED, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_HEALTH, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_MHC1, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_MHC2, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_IMMUNE, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_JUMP, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_RANDOM, (Object)0);
        this.field_70180_af.func_187214_a(DISPLAY_AGE, (Object)0);
        this.field_70180_af.func_187214_a(GENDER, (Object)false);
        this.field_70180_af.func_187214_a(IS_CASTRATED, (Object)false);
        this.field_70180_af.func_187214_a(PREGNANT_SINCE, (Object)-1);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.getEntityData().func_74768_a("HorseGeneticsVersion", 1);
        compound.func_74768_a("Variant", this.getChromosome("0"));
        compound.func_74768_a("Variant2", this.getChromosome("1"));
        compound.func_74768_a("Variant3", this.getChromosome("2"));
        compound.func_74768_a("Variant4", this.getChromosome("3"));
        compound.func_74768_a("Variant5", this.getChromosome("4"));
        compound.func_74768_a("SpeedGenes", this.getChromosome("speed"));
        compound.func_74768_a("JumpGenes", this.getChromosome("jump"));
        compound.func_74768_a("HealthGenes", this.getChromosome("health"));
        compound.func_74768_a("MHC1", this.getChromosome("mhc1"));
        compound.func_74768_a("MHC2", this.getChromosome("mhc2"));
        compound.func_74768_a("Immune", this.getChromosome("immune"));
        compound.func_74768_a("Random", this.getChromosome("random"));
        compound.func_74768_a("true_age", this.trueAge);
        compound.func_74757_a("gender", this.isMale());
        compound.func_74757_a("is_castrated", this.isCastrated());
        compound.func_74768_a("pregnant_since", this.getPregnancyStart());
        if (this.unbornChildren != null) {
            NBTTagList unbornChildrenTag = new NBTTagList();
            for (AbstractHorseGenetic child : this.unbornChildren) {
                NBTTagCompound childNBT = new NBTTagCompound();
                childNBT.func_74778_a("species", child.getSpecies().toString());
                childNBT.func_74778_a("genes", child.getGenes().genesToString());
                unbornChildrenTag.func_74742_a((NBTBase)childNBT);
            }
            compound.func_74782_a("unborn_children", (NBTBase)unbornChildrenTag);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        int spawndata;
        NBTBase nbt;
        super.func_70037_a(compound);
        this.setChromosome("0", compound.func_74762_e("Variant"));
        this.setChromosome("1", compound.func_74762_e("Variant2"));
        this.setChromosome("2", compound.func_74762_e("Variant3"));
        this.setChromosome("3", compound.func_74762_e("Variant4"));
        if (compound.func_74764_b("Variant5")) {
            this.setChromosome("4", compound.func_74762_e("Variant5"));
        } else if (!this.getEntityData().func_74764_b("HorseGeneticsVersion")) {
            this.getEntityData().func_74768_a("HorseGeneticsVersion", 1);
            this.getGenes().datafixAddingFourthChromosome();
        }
        this.setChromosome("speed", compound.func_74762_e("SpeedGenes"));
        this.setChromosome("jump", compound.func_74762_e("JumpGenes"));
        this.setChromosome("health", compound.func_74762_e("HealthGenes"));
        if (compound.func_74764_b("MHC1")) {
            this.setChromosome("mhc1", compound.func_74762_e("MHC1"));
            this.setChromosome("mhc2", compound.func_74762_e("MHC2"));
        } else {
            this.getGenes().setNamedGene("leopard", 0);
            this.setChromosome("mhc1", this.field_70146_Z.nextInt());
            this.setChromosome("mhc2", this.field_70146_Z.nextInt());
        }
        if (compound.func_74764_b("Immune")) {
            this.setChromosome("immune", compound.func_74762_e("Immune"));
        } else {
            for (int i = 0; i < 2; ++i) {
                if (this.getGenes().getAllele("dun", i) == 3) {
                    this.getGenes().setAllele("dun", i, 2);
                }
                if (this.getGenes().getAllele("dun", i) != 1) continue;
                this.getGenes().setAllele("dun", i, 0);
            }
            this.getGenes().setNamedGene("gray_suppression", 0);
            this.setChromosome("immune", this.field_70146_Z.nextInt());
        }
        this.setChromosome("random", compound.func_74762_e("Random"));
        this.trueAge = compound.func_74762_e("true_age");
        if (compound.func_74764_b("gender")) {
            this.setMale(compound.func_74767_n("gender"));
        } else {
            this.setMale(this.field_70146_Z.nextBoolean());
        }
        this.setCastrated(compound.func_74767_n("is_castrated"));
        int pregnantSince = -1;
        if (compound.func_74764_b("pregnant_since")) {
            pregnantSince = compound.func_74762_e("pregnant_since");
        }
        this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)pregnantSince);
        if (compound.func_74764_b("unborn_children") && (nbt = compound.func_74781_a("unborn_children")) instanceof NBTTagList) {
            NBTTagList childListTag = (NBTTagList)nbt;
            for (int i = 0; i < childListTag.func_74745_c(); ++i) {
                NBTBase cnbt = childListTag.func_179238_g(i);
                if (!(cnbt instanceof NBTTagCompound)) continue;
                NBTTagCompound childNBT = (NBTTagCompound)cnbt;
                Species species = Species.valueOf(childNBT.func_74779_i("species"));
                AbstractHorseGenetic child = null;
                switch (species) {
                    case HORSE: {
                        child = new HorseGeneticEntity(this.field_70170_p);
                        break;
                    }
                    case DONKEY: {
                        child = new DonkeyGeneticEntity(this.field_70170_p);
                        break;
                    }
                    case MULE: {
                        child = new MuleGeneticEntity(this.field_70170_p);
                    }
                }
                if (child == null) continue;
                HorseGenome genome = new HorseGenome(((AbstractHorseGenetic)child).getSpecies(), child);
                genome.genesFromString(childNBT.func_74779_i("genes"));
                this.unbornChildren.add(child);
            }
        }
        this.func_110232_cE();
        if (this instanceof HorseGeneticEntity && (spawndata = compound.func_74762_e("VillageSpawn")) != 0) {
            this.initFromVillageSpawn();
        }
    }

    public int getDisplayAge() {
        return (Integer)this.field_70180_af.func_187225_a(DISPLAY_AGE);
    }

    public void setDisplayAge(int age) {
        this.field_70180_af.func_187227_b(DISPLAY_AGE, (Object)age);
    }

    @Override
    public void setChromosome(String name, int variant) {
        switch (name) {
            case "0": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT, (Object)variant);
                this.getGenes().resetTexture();
                return;
            }
            case "1": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT2, (Object)variant);
                this.getGenes().resetTexture();
                return;
            }
            case "2": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT3, (Object)variant);
                this.getGenes().resetTexture();
                return;
            }
            case "3": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT4, (Object)variant);
                this.getGenes().resetTexture();
                return;
            }
            case "4": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT5, (Object)variant);
                this.getGenes().resetTexture();
                return;
            }
            case "speed": {
                this.field_70180_af.func_187227_b(HORSE_SPEED, (Object)variant);
                this.useGeneticAttributes();
                return;
            }
            case "jump": {
                this.field_70180_af.func_187227_b(HORSE_JUMP, (Object)variant);
                this.useGeneticAttributes();
                return;
            }
            case "health": {
                this.field_70180_af.func_187227_b(HORSE_HEALTH, (Object)variant);
                this.useGeneticAttributes();
                return;
            }
            case "mhc1": {
                this.field_70180_af.func_187227_b(HORSE_MHC1, (Object)variant);
                this.useGeneticAttributes();
                return;
            }
            case "mhc2": {
                this.field_70180_af.func_187227_b(HORSE_MHC2, (Object)variant);
                this.useGeneticAttributes();
                return;
            }
            case "immune": {
                this.field_70180_af.func_187227_b(HORSE_IMMUNE, (Object)variant);
                this.useGeneticAttributes();
                return;
            }
            case "random": {
                this.field_70180_af.func_187227_b(HORSE_RANDOM, (Object)variant);
                return;
            }
        }
        HorseColors.logger.error("Unrecognized horse data for setting: " + name + "\n");
    }

    @Override
    public int getChromosome(String name) {
        switch (name) {
            case "0": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT);
            }
            case "1": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT2);
            }
            case "2": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT3);
            }
            case "3": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT4);
            }
            case "4": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT5);
            }
            case "speed": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_SPEED);
            }
            case "jump": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_JUMP);
            }
            case "health": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_HEALTH);
            }
            case "mhc1": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_MHC1);
            }
            case "mhc2": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_MHC2);
            }
            case "immune": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_IMMUNE);
            }
            case "random": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_RANDOM);
            }
        }
        HorseColors.logger.error("Unrecognized horse data for getting: " + name + "\n");
        return 0;
    }

    @Override
    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(GENDER);
    }

    @Override
    public void setMale(boolean gender) {
        if (gender) {
            this.unbornChildren = new ArrayList<AbstractHorseGenetic>();
            this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)-1);
        } else {
            this.setCastrated(false);
        }
        this.field_70180_af.func_187227_b(GENDER, (Object)gender);
    }

    public boolean isCastrated() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CASTRATED);
    }

    public void setCastrated(boolean isCastrated) {
        this.field_70180_af.func_187227_b(IS_CASTRATED, (Object)isCastrated);
    }

    public boolean isPregnant() {
        return this.getPregnancyStart() >= 0;
    }

    public int getPregnancyStart() {
        return (Integer)this.field_70180_af.func_187225_a(PREGNANT_SINCE);
    }

    public float getPregnancyProgress() {
        int passed = this.getDisplayAge() - this.getPregnancyStart();
        int total = HorseConfig.getHorsePregnancyLength();
        return (float)passed / (float)total;
    }

    @Override
    public int getRebreedTicks() {
        return HorseConfig.getHorseRebreedTicks(this.isMale());
    }

    @Override
    public int getBirthAge() {
        return HorseConfig.getHorseBirthAge();
    }

    public ContainerHorseChest getInventory() {
        return this.field_110296_bG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (damageSourceIn != DamageSource.field_76368_d && damageSourceIn != DamageSource.field_76367_g) {
            super.func_184601_bQ(damageSourceIn);
        }
        return null;
    }

    public void func_70873_a(int age) {
        if (age == -24000 && this.func_70874_b() > age) {
            super.func_70873_a(this.getBirthAge());
        } else {
            super.func_70873_a(age);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && player.func_70093_af()) {
                this.func_110199_f(player);
                return true;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(player, hand);
            }
        }
        if (itemstack.func_190926_b()) {
            if (this.func_70631_g_()) {
                return super.func_184645_a(player, hand);
            }
            this.func_110237_h(player);
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151122_aG && (HorseConfig.getBookShowsGenes() || HorseConfig.getBookShowsTraits()) && (this.func_110248_bS() || player.field_71075_bZ.field_75098_d)) {
            ItemStack book = new ItemStack((Item)ModItems.geneBookItem);
            if (book.func_77978_p() == null) {
                book.func_77982_d(new NBTTagCompound());
            }
            book.func_77978_p().func_74778_a("species", this.getSpecies().name());
            book.func_77978_p().func_74778_a("genes", this.getGenes().genesToString());
            if (this.func_145818_k_()) {
                book.func_151001_c(this.func_95999_t());
            }
            if (!player.func_191521_c(book)) {
                this.func_70099_a(book, 0.0f);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (this.func_190678_b(player, itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (itemstack.func_111282_a(player, (EntityLivingBase)this, hand)) {
            return true;
        }
        if (!this.func_110248_bS()) {
            this.func_190687_dF();
            return true;
        }
        if (this.func_70631_g_()) {
            return false;
        }
        if (!this.func_110257_ck() && itemstack.func_77973_b() == Items.field_151141_av) {
            if (HorseConfig.getAutoEquipSaddle()) {
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack saddle = itemstack.func_77979_a(1);
                    this.field_110296_bG.func_70299_a(0, saddle);
                }
            } else {
                this.func_110199_f(player);
            }
            return true;
        }
        if (this.func_190682_f(itemstack) && this.func_190677_dK()) {
            if (HorseConfig.getAutoEquipSaddle() && this.field_110296_bG.func_70301_a(1).func_190926_b()) {
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack armor = itemstack.func_77979_a(1);
                    this.field_110296_bG.func_70299_a(1, armor);
                }
            } else {
                this.func_110199_f(player);
            }
            return true;
        }
        if (!this.func_190695_dh() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && this.canEquipChest()) {
            this.func_110207_m(true);
            this.func_190697_dk();
            this.func_110226_cD();
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        }
        this.func_110237_h(player);
        return true;
    }

    protected void useGeneticAttributes() {
        if (HorseConfig.getUseGeneticStats()) {
            HorseGenome genes = this.getGenes();
            float maxHealth = this.getGenes().getHealth();
            float speedStat = (float)(genes.getStatValue("speed1") + genes.getStatValue("speed2") + genes.getStatValue("speed3")) + (float)genes.getStatValue("athletics1") / 2.0f + (float)genes.getStatValue("athletics2") / 2.0f;
            double movementSpeed = 0.1125 + (double)speedStat * 0.00703125;
            float jumpStat = (float)(genes.getStatValue("jump1") + genes.getStatValue("jump2") + genes.getStatValue("jump3")) + (float)genes.getStatValue("athletics1") / 2.0f + (float)genes.getStatValue("athletics2") / 2.0f;
            double jumpStrength = 0.4 + (double)jumpStat * 0.01875;
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(movementSpeed);
            this.func_110148_a(field_110271_bv).func_111128_a(jumpStrength);
        } else {
            float maxHealth = this.func_110267_cL() + this.getGenes().getBaseHealth();
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.genes = new HorseGenome(this.getSpecies(), this);
        float maxHealth = this.func_110267_cL() + this.getGenes().getBaseHealth();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110203_cN());
        this.func_110148_a(field_110271_bv).func_111128_a(this.func_110245_cM());
    }

    abstract AbstractHorse getChild(EntityAgeable var1);

    public boolean isOppositeGender(AbstractHorseGenetic other) {
        if (!HorseConfig.isGenderEnabled()) {
            return true;
        }
        if (this.isCastrated() || other.isCastrated()) {
            return false;
        }
        return this.isMale() != other.isMale();
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        if (!(ageable instanceof EntityAnimal)) {
            return null;
        }
        EntityAnimal otherAnimal = (EntityAnimal)ageable;
        if (this.isMale() && ageable instanceof AbstractHorseGenetic && !((AbstractHorseGenetic)ageable).isMale()) {
            return ageable.func_90011_a((EntityAgeable)this);
        }
        AbstractHorse child = this.getChild(ageable);
        if (child != null) {
            this.func_190681_a(ageable, child);
        }
        if (child instanceof AbstractHorseGenetic) {
            AbstractHorseGenetic foal = (AbstractHorseGenetic)child;
            if (ageable instanceof AbstractHorseGenetic) {
                AbstractHorseGenetic other = (AbstractHorseGenetic)ageable;
                foal.getGenes().inheritGenes(this.getGenes(), other.getGenes());
            }
            if (foal.getGenes().isEmbryonicLethal()) {
                this.func_70875_t();
                otherAnimal.func_70875_t();
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                return null;
            }
            foal.setMale(this.field_70146_Z.nextBoolean());
            foal.useGeneticAttributes();
            foal.func_70873_a(HorseConfig.getMinAge());
        }
        return child;
    }

    @Override
    public boolean setPregnantWith(EntityAgeable child, EntityAgeable otherParent) {
        if (otherParent instanceof IGeneticEntity) {
            IGeneticEntity otherGenetic = (IGeneticEntity)otherParent;
            if (this.isMale() == otherGenetic.isMale()) {
                return false;
            }
            if (this.isMale() && !otherGenetic.isMale()) {
                return otherGenetic.setPregnantWith(child, (EntityAgeable)this);
            }
        }
        if (this.isMale()) {
            return false;
        }
        if (child instanceof AbstractHorseGenetic) {
            this.unbornChildren.add((AbstractHorseGenetic)child);
            if (!this.field_70170_p.field_72995_K) {
                this.trueAge = Math.max(0, this.trueAge);
                this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)this.trueAge);
            }
            return true;
        }
        return false;
    }

    public boolean shouldRecordAge() {
        return this.getGenes().clientNeedsAge() || this.isPregnant();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.getGenes().resetTexture();
        }
        if (!this.field_70170_p.field_72995_K && this.shouldRecordAge()) {
            this.trueAge = this.field_175504_a < 0 ? this.field_175504_a : Math.max(0, this.trueAge + 1);
            int c = 400;
            if (this.trueAge / 400 != this.getDisplayAge() / 400 || this.trueAge < 0 != this.getDisplayAge() < 0) {
                this.setDisplayAge(this.trueAge);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isPregnant()) {
            if (this.unbornChildren == null || this.unbornChildren.size() == 0) {
                this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)-1);
            }
            int totalLength = HorseConfig.getHorsePregnancyLength();
            int currentLength = this.trueAge - this.getPregnancyStart();
            if (currentLength >= totalLength) {
                for (AbstractHorseGenetic child : this.unbornChildren) {
                    GenderedBreedGoal.spawnChild((EntityAgeable)this, (EntityAgeable)child, this.field_70170_p);
                }
                this.unbornChildren = new ArrayList<AbstractHorseGenetic>();
                this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)-1);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
        if (this.getGenes().isLethalWhite() && this.field_70173_aa > 80) {
            if (!this.func_70644_a(MobEffects.field_76436_u)) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 3));
            }
            if (this.func_110143_aJ() < 2.0f) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 1, 3));
            }
        }
    }

    public void func_70636_d() {
        if (this.unbornChildren != null && this.unbornChildren.size() > 0 && this.getPregnancyStart() < 0) {
            this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)0);
        }
        if (this.getGenes().isHomozygous("leopard", 1) && !this.field_70170_p.field_72995_K) {
            IAttributeInstance speedAttribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            IAttributeInstance jumpAttribute = this.func_110148_a(field_110271_bv);
            float brightness = this.func_70013_c();
            if (brightness > 0.5f) {
                if (speedAttribute.func_111127_a(CSNB_SPEED_UUID) != null) {
                    speedAttribute.func_111124_b(CSNB_SPEED_MODIFIER);
                }
                if (jumpAttribute.func_111127_a(CSNB_JUMP_UUID) != null) {
                    jumpAttribute.func_111124_b(CSNB_JUMP_MODIFIER);
                }
            } else {
                if (speedAttribute.func_111127_a(CSNB_SPEED_UUID) == null) {
                    speedAttribute.func_111121_a(CSNB_SPEED_MODIFIER);
                }
                if (jumpAttribute.func_111127_a(CSNB_JUMP_UUID) == null) {
                    jumpAttribute.func_111121_a(CSNB_JUMP_MODIFIER);
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public Breed getDefaultBreed() {
        return BaseEquine.breed;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData spawnDataIn) {
        spawnDataIn = super.func_180482_a(difficulty, spawnDataIn);
        this.randomize();
        return spawnDataIn;
    }

    private void randomize() {
        this.getGenes().randomize(this.getDefaultBreed());
        this.trueAge = this.field_70146_Z.nextInt(HorseConfig.GROWTH.getMaxAge());
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.trueAge = this.getBirthAge() + this.field_70146_Z.nextInt(-this.getBirthAge() / 2);
        }
        this.setMale(this.field_70146_Z.nextBoolean());
        this.func_70873_a(Math.min(0, this.trueAge));
        this.useGeneticAttributes();
    }

    public void initFromVillageSpawn() {
        this.randomize();
        this.func_110198_t(this.func_190676_dC() / 2);
        if (!this.func_70631_g_() && this.field_70146_Z.nextInt(16) == 0) {
            this.func_110234_j(true);
            ItemStack saddle = new ItemStack(Items.field_151141_av);
            this.field_110296_bG.func_70299_a(0, saddle);
        }
    }

    public float fractionGrown() {
        if (this.func_70631_g_()) {
            if (HorseConfig.getGrowsGradually()) {
                int minAge = HorseConfig.getMinAge();
                int age = Math.min(0, this.getDisplayAge());
                if (this.getDisplayAge() == 0) {
                    age = minAge;
                }
                float fractionGrown = (float)(minAge - age) / (float)minAge;
                return Math.max(0.0f, fractionGrown);
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public void func_98054_a(boolean child) {
        this.func_98055_j(this.getProportionalScale());
    }

    public float getProportionalScale() {
        float ageScale = 0.5f + 0.5f * this.fractionGrown();
        return ageScale / this.getGangliness();
    }

    public float getGangliness() {
        return 0.5f + 0.5f * this.fractionGrown() * this.fractionGrown();
    }
}

