/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.entity.MuleGeneticEntity;
import sekelsta.horse_colors.genetics.Species;
import sekelsta.horse_colors.genetics.breed.Breed;
import sekelsta.horse_colors.genetics.breed.donkey.DefaultDonkey;
import sekelsta.horse_colors.util.Util;

public class DonkeyGeneticEntity
extends AbstractHorseGenetic {
    public DonkeyGeneticEntity(World world) {
        super(world);
    }

    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187580_av;
    }

    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187586_ay;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187588_az;
    }

    @Override
    public boolean fluffyTail() {
        return false;
    }

    @Override
    public boolean longEars() {
        return true;
    }

    @Override
    public boolean thinMane() {
        return true;
    }

    @Override
    public Species getSpecies() {
        return Species.DONKEY;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof AbstractHorseGenetic && !this.isOppositeGender((AbstractHorseGenetic)otherAnimal)) {
            return false;
        }
        if (otherAnimal instanceof DonkeyGeneticEntity || otherAnimal instanceof HorseGeneticEntity || otherAnimal instanceof EntityDonkey || otherAnimal instanceof EntityHorse) {
            return this.func_110200_cJ() && Util.horseCanMate((AbstractHorse)otherAnimal);
        }
        return false;
    }

    @Override
    public AbstractHorse getChild(EntityAgeable ageable) {
        if (ageable instanceof AbstractHorseGenetic) {
            AbstractHorseGenetic child = null;
            AbstractHorseGenetic other = (AbstractHorseGenetic)ageable;
            if (ageable instanceof HorseGeneticEntity) {
                child = new MuleGeneticEntity(this.field_70170_p);
            } else if (ageable instanceof DonkeyGeneticEntity) {
                child = new DonkeyGeneticEntity(this.field_70170_p);
            }
            return child;
        }
        if (ageable instanceof EntityHorse) {
            return new EntityMule(this.field_70170_p);
        }
        if (ageable instanceof EntityDonkey) {
            return new EntityDonkey(this.field_70170_p);
        }
        return null;
    }

    @Override
    public Breed getDefaultBreed() {
        return DefaultDonkey.breed;
    }
}

