/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import java.util.UUID;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.entity.DonkeyGeneticEntity;
import sekelsta.horse_colors.entity.MuleGeneticEntity;
import sekelsta.horse_colors.genetics.Species;
import sekelsta.horse_colors.genetics.breed.Breed;
import sekelsta.horse_colors.genetics.breed.horse.DefaultHorse;
import sekelsta.horse_colors.util.Util;

public class HorseGeneticEntity
extends AbstractHorseGenetic {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> HORSE_ARMOR = EntityDataManager.func_187226_a(HorseGeneticEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> HORSE_ARMOR_STACK = EntityDataManager.func_187226_a(HorseGeneticEntity.class, (DataSerializer)DataSerializers.field_187196_f);

    public HorseGeneticEntity(World worldIn) {
        super(worldIn);
    }

    @Override
    public void copyAbstractHorse(AbstractHorse horse) {
        super.copyAbstractHorse(horse);
        ContainerHorseChest inv = (ContainerHorseChest)ObfuscationReflectionHelper.getPrivateValue(AbstractHorse.class, (Object)horse, (String[])new String[]{"horseChest", "field_110296_bG"});
        this.field_110296_bG.func_70299_a(0, inv.func_70301_a(0));
        this.field_110296_bG.func_70299_a(1, inv.func_70301_a(1));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compound.func_74782_a("ArmorItem", (NBTBase)this.field_110296_bG.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HORSE_ARMOR, (Object)HorseArmorType.NONE.func_188579_a());
        this.field_70180_af.func_187214_a(HORSE_ARMOR_STACK, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        if (compound.func_150297_b("ArmorItem", 10) && !(itemstack = new ItemStack(compound.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(itemstack)) {
            this.field_110296_bG.func_70299_a(1, itemstack);
        }
        this.func_110232_cE();
    }

    protected void func_110232_cE() {
        super.func_110232_cE();
        this.setHorseArmorStack(this.field_110296_bG.func_70301_a(1));
    }

    private void setHorseArmorStack(ItemStack itemstack) {
        HorseArmorType horsearmortype = HorseArmorType.func_188580_a((ItemStack)itemstack);
        this.field_70180_af.func_187227_b(HORSE_ARMOR, (Object)horsearmortype.func_188579_a());
        this.field_70180_af.func_187227_b(HORSE_ARMOR_STACK, (Object)itemstack);
        this.getGenes().resetTexture();
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(ARMOR_MODIFIER_UUID);
            int i = horsearmortype.func_188578_c();
            if (i != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, 0).func_111168_a(false));
            }
        }
    }

    public ItemStack getHorseArmor() {
        ItemStack armorStack = (ItemStack)this.field_70180_af.func_187225_a(HORSE_ARMOR_STACK);
        return armorStack;
    }

    public HorseArmorType getHorseArmorType() {
        HorseArmorType armor = HorseArmorType.func_188580_a((ItemStack)((ItemStack)this.field_70180_af.func_187225_a(HORSE_ARMOR_STACK)));
        if (armor == HorseArmorType.NONE) {
            armor = HorseArmorType.func_188575_a((int)((Integer)this.field_70180_af.func_187225_a(HORSE_ARMOR)));
        }
        return armor;
    }

    public void func_76316_a(IInventory invBasic) {
        HorseArmorType horsearmortype = this.getHorseArmorType();
        super.func_76316_a(invBasic);
        HorseArmorType horsearmortype1 = this.getHorseArmorType();
        if (this.field_70173_aa > 20 && horsearmortype != horsearmortype1 && horsearmortype1 != HorseArmorType.NONE) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
    }

    protected void func_190680_a(SoundType p_190680_1_) {
        super.func_190680_a(p_190680_1_);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, p_190680_1_.func_185843_a() * 0.6f, p_190680_1_.func_185847_b());
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        ItemStack stack = this.field_110296_bG.func_70301_a(1);
        if (this.func_190682_f(stack)) {
            stack.func_77973_b().onHorseArmorTick(this.field_70170_p, (EntityLiving)this, stack);
        }
    }

    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187717_cr;
    }

    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    @Override
    public boolean fluffyTail() {
        return true;
    }

    @Override
    public boolean longEars() {
        return false;
    }

    @Override
    public boolean thinMane() {
        return false;
    }

    @Override
    public boolean canEquipChest() {
        return false;
    }

    @Override
    public Species getSpecies() {
        return Species.HORSE;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof AbstractHorseGenetic && !this.isOppositeGender((AbstractHorseGenetic)otherAnimal)) {
            return false;
        }
        if (otherAnimal instanceof DonkeyGeneticEntity || otherAnimal instanceof HorseGeneticEntity || otherAnimal instanceof EntityDonkey || otherAnimal instanceof EntityHorse) {
            return this.func_110200_cJ() && Util.horseCanMate((AbstractHorse)otherAnimal);
        }
        return false;
    }

    @Override
    public AbstractHorse getChild(EntityAgeable ageable) {
        if (ageable instanceof AbstractHorseGenetic) {
            AbstractHorseGenetic child = null;
            AbstractHorseGenetic other = (AbstractHorseGenetic)ageable;
            if (ageable instanceof HorseGeneticEntity) {
                child = new HorseGeneticEntity(this.field_70170_p);
            } else if (ageable instanceof DonkeyGeneticEntity) {
                child = new MuleGeneticEntity(this.field_70170_p);
            }
            return child;
        }
        if (ageable instanceof EntityHorse) {
            EntityHorse child = new EntityHorse(this.field_70170_p);
            child.func_110235_q(((EntityHorse)ageable).func_110202_bQ());
            return child;
        }
        if (ageable instanceof EntityDonkey) {
            return new EntityDonkey(this.field_70170_p);
        }
        return null;
    }

    public boolean func_190677_dK() {
        return true;
    }

    public boolean func_190682_f(ItemStack stack) {
        return HorseArmorType.isHorseArmor((ItemStack)stack) || stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockCarpet;
    }

    @Override
    public Breed getDefaultBreed() {
        return DefaultHorse.breed;
    }
}

