/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sekelsta.horse_colors.HorseColors;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.DonkeyGeneticEntity;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.entity.MuleGeneticEntity;
import sekelsta.horse_colors.renderer.HorseGeneticRenderer;

public class ModEntities {
    private static int ID = 0;
    static IForgeRegistry<Biome> biomeRegistry;
    public static EntityEntry HORSE_GENETIC;
    public static EntityEntry DONKEY_GENETIC;
    public static EntityEntry MULE_GENETIC;
    public static final int horseEggPrimary = 8340256;
    public static final int horseEggSecondary = 1117709;

    private static Biome[] getBiomes(BiomeDictionary.Type type) {
        assert (type != null);
        assert (BiomeDictionary.getBiomes((BiomeDictionary.Type)type) != null);
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)type).toArray(new Biome[0]);
    }

    public static void editSpawnTable() {
        Collection allBiomes = biomeRegistry.getValuesCollection();
        for (Biome biome : allBiomes) {
            List spawns = biome.func_76747_a(EnumCreatureType.CREATURE);
            if (spawns.isEmpty()) continue;
            ArrayList<Biome.SpawnListEntry> horseSpawns = new ArrayList<Biome.SpawnListEntry>();
            for (Biome.SpawnListEntry entry : spawns) {
                if (entry.field_76300_b != EntityHorse.class || !HorseConfig.blockVanillaHorseSpawns()) continue;
                HorseColors.logger.debug("Removing vanilla horse spawn: " + entry + " from biome " + biome);
                horseSpawns.add(entry);
            }
            for (Biome.SpawnListEntry horseSpawn : horseSpawns) {
                spawns.remove(horseSpawn);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        HorseGeneticRenderer renderer = new HorseGeneticRenderer(Minecraft.func_71410_x().func_175598_ae());
        RenderingRegistry.registerEntityRenderingHandler(HorseGeneticEntity.class, (Render)renderer);
        RenderingRegistry.registerEntityRenderingHandler(MuleGeneticEntity.class, (Render)renderer);
        RenderingRegistry.registerEntityRenderingHandler(DonkeyGeneticEntity.class, (Render)renderer);
    }

    public static void onLoadComplete() {
        ModEntities.editSpawnTable();
    }

    static {
        HORSE_GENETIC = null;
        DONKEY_GENETIC = null;
        MULE_GENETIC = null;
        int horsePlainsWeight = (int)Math.round(5.0 * HorseConfig.COMMON.horseSpawnMultiplier);
        int horseSavannaWeight = (int)Math.round(1.0 * HorseConfig.COMMON.horseSpawnMultiplier);
        ResourceLocation horseRegistryName = new ResourceLocation("horse_colors", "horse_felinoid");
        HORSE_GENETIC = EntityEntryBuilder.create().entity(HorseGeneticEntity.class).id(horseRegistryName, ID++).name(horseRegistryName.toString()).egg(8340256, 1117709).tracker(64, 2, false).spawn(EnumCreatureType.CREATURE, horsePlainsWeight, 4, 6, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)).spawn(EnumCreatureType.CREATURE, horseSavannaWeight, 4, 6, (Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)).build();
        ResourceLocation donkeyRegistryName = new ResourceLocation("horse_colors", "donkey");
        DONKEY_GENETIC = EntityEntryBuilder.create().entity(DonkeyGeneticEntity.class).id(donkeyRegistryName, ID++).name(donkeyRegistryName.toString()).tracker(64, 2, false).build();
        ResourceLocation muleRegistryName = new ResourceLocation("horse_colors", "mule");
        MULE_GENETIC = EntityEntryBuilder.create().entity(MuleGeneticEntity.class).id(muleRegistryName, ID++).name(muleRegistryName.toString()).tracker(64, 2, false).build();
    }

    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{HORSE_GENETIC, DONKEY_GENETIC, MULE_GENETIC});
        }

        @SubscribeEvent
        public static void catchBiomeRegistry(RegistryEvent.Register<Biome> event) {
            biomeRegistry = event.getRegistry();
        }
    }
}

