/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.genetics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.genetics.FakeGeneticEntity;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.genetics.Species;
import sekelsta.horse_colors.renderer.TextureLayer;

public abstract class Genome {
    public final Species species;
    protected IGeneticEntity entity;
    protected String textureCacheName;
    protected List<TextureLayer> textureLayers;
    public static Random rand = new Random();

    public abstract List<String> listGenes();

    public abstract List<String> listGenericChromosomes();

    public abstract List<String> listStats();

    public List<Linkage> listLinkages() {
        ArrayList<Linkage> linkages = new ArrayList<Linkage>();
        for (String gene : this.listGenes()) {
            linkages.add(new Linkage(gene));
        }
        return linkages;
    }

    public Genome(Species species) {
        this(species, new FakeGeneticEntity());
    }

    public Genome(Species species, IGeneticEntity entityIn) {
        this.species = species;
        this.entity = entityIn;
    }

    public void resetTexture() {
        this.textureCacheName = null;
    }

    public abstract List<List<String>> getBookContents();

    public abstract void setTexturePaths();

    public abstract String genesToString();

    public abstract void genesFromString(String var1);

    public abstract boolean isValidGeneString(String var1);

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        if (this.textureCacheName == null) {
            this.setTexturePaths();
        }
        return this.textureCacheName;
    }

    @SideOnly(value=Side.CLIENT)
    public List<TextureLayer> getVariantTexturePaths() {
        if (this.textureCacheName == null) {
            this.setTexturePaths();
        }
        return this.textureLayers;
    }

    public abstract int getGeneSize(String var1);

    public int getChromosome(String name) {
        return this.entity.getChromosome(name);
    }

    public void setNamedGene(String name, int val) {
        String chr = this.getGeneChromosome(name);
        this.entity.setChromosome(chr, this.entity.getChromosome(chr) & ~this.getGeneLoci(name) | val << this.getGenePos(name) % 32);
    }

    public int getNamedGene(String name) {
        String chr = this.getGeneChromosome(name);
        return (this.entity.getChromosome(chr) & this.getGeneLoci(name)) >>> this.getGenePos(name);
    }

    public int getRawStat(String name) {
        String chr = this.listGenericChromosomes().get(this.getStatPos(name) / 32);
        return this.entity.getChromosome(chr) & this.getStatLoci(name);
    }

    public int getStatValue(String name) {
        int val = this.getRawStat(name);
        return this.countBits(val);
    }

    public int countBits(int val) {
        int count = 0;
        for (int i = 0; i < 32; ++i) {
            count += (val % 2 + 2) % 2;
            val >>= 1;
        }
        return count;
    }

    public int countDiffs(int val) {
        int count = 0;
        for (int i = 0; i < 16; ++i) {
            int one = (val % 2 + 2) % 2;
            int two = ((val >>= 1) % 2 + 2) % 2;
            val >>= 1;
            count += one ^ two;
        }
        return count;
    }

    public int getGenePos(String name) {
        return this.getPos(name, this.listGenes());
    }

    public int getStatPos(String name) {
        return this.getPos(name, this.listStats());
    }

    private int getPos(String name, List<String> genes) {
        int i = 0;
        for (String gene : genes) {
            int next = i + 2 * this.getGeneSize(gene);
            if (next / 32 != i / 32 && next % 32 != 0) {
                i = (i / 32 + 1) * 32;
            }
            if (gene == name) {
                return i;
            }
            i += 2 * this.getGeneSize(gene);
        }
        System.out.println("Gene not recognized: " + name);
        return -1;
    }

    public int getGeneLoci(String gene) {
        return this.getLoci(gene, this.getGenePos(gene));
    }

    public int getStatLoci(String gene) {
        return this.getLoci(gene, this.getStatPos(gene));
    }

    private int getLoci(String gene, int pos) {
        return (1 << 2 * this.getGeneSize(gene)) - 1 << pos % 32;
    }

    public String getGeneChromosome(String gene) {
        return Integer.toString(this.getGenePos(gene) / 32);
    }

    public int getAllele(String name, int n) {
        int gene = this.getNamedGene(name);
        gene >>= n * this.getGeneSize(name);
        return gene %= 1 << this.getGeneSize(name);
    }

    public void setAllele(String name, int n, int v) {
        int other = this.getAllele(name, 1 - n);
        int size = this.getGeneSize(name);
        this.setNamedGene(name, other << (1 - n) * size | v << n * size);
    }

    public void mutateAllele(String gene, int n) {
        Map<String, List<Float>> map = this.entity.getDefaultBreed().colors;
        if (!map.containsKey(gene)) {
            return;
        }
        List<Float> frequencies = map.get(gene);
        ArrayList<Integer> allowedAlleles = new ArrayList<Integer>();
        float val = 0.0f;
        for (int i = 0; i < frequencies.size() && !(val >= 1.0f); ++i) {
            if (!(val < frequencies.get(i).floatValue())) continue;
            allowedAlleles.add(i);
            val = frequencies.get(i).floatValue();
        }
        int size = allowedAlleles.size();
        int v = (Integer)allowedAlleles.get(rand.nextInt(size));
        this.setAllele(gene, n, v);
    }

    public void mutateAlleleChance(String gene, int n, double p) {
        if (rand.nextDouble() < p) {
            this.mutateAllele(gene, n);
        }
    }

    public int mutateIntMask(double p) {
        int mask = 0;
        if (rand.nextDouble() < p) {
            ++mask;
        }
        for (int i = 1; i < 32; ++i) {
            mask <<= 1;
            if (!(rand.nextDouble() < p)) continue;
            ++mask;
        }
        return mask;
    }

    public void mutateGenericChromosome(String name, double p) {
        this.entity.setChromosome(name, this.entity.getChromosome(name) ^ this.mutateIntMask(p / 2.0));
    }

    public void mutate() {
        double p = HorseConfig.getMutationChance();
        for (String gene : this.listGenes()) {
            int a = this.getAllele(gene, 0);
            int b = this.getAllele(gene, 1);
            this.mutateAlleleChance(gene, 0, p);
            this.mutateAlleleChance(gene, 1, p);
        }
        for (String stat : this.listGenericChromosomes()) {
            this.mutateGenericChromosome(stat, p);
        }
    }

    public boolean hasAllele(String name, int allele) {
        return this.getAllele(name, 0) == allele || this.getAllele(name, 1) == allele;
    }

    public int getMaxAllele(String name) {
        return Math.max(this.getAllele(name, 0), this.getAllele(name, 1));
    }

    public boolean isHomozygous(String name, int allele) {
        return this.getAllele(name, 0) == allele && this.getAllele(name, 1) == allele;
    }

    public int countAlleles(String gene, int allele) {
        int count = 0;
        if (this.getAllele(gene, 0) == allele) {
            ++count;
        }
        if (this.getAllele(gene, 1) == allele) {
            ++count;
        }
        return count;
    }

    public int getRandomGenericGenes(int n, int data, float linkage) {
        int rand = Genome.rand.nextInt(2);
        int answer = 0;
        for (int i = 0; i < 16; ++i) {
            if (Genome.rand.nextFloat() < linkage) {
                rand = 1 - rand;
            }
            answer += (data & 1 << 2 * i + rand) >> rand << n;
        }
        return answer;
    }

    public void inheritNamedGenes(Genome parent1, Genome parent2) {
        int rand1 = rand.nextInt(2);
        int rand2 = rand.nextInt(2);
        for (Linkage link : this.listLinkages()) {
            int allele1 = parent1.getAllele(link.gene, rand1);
            int allele2 = parent2.getAllele(link.gene, rand2);
            this.setAllele(link.gene, 0, allele1);
            this.setAllele(link.gene, 1, allele2);
            if (rand.nextFloat() < link.p) {
                rand1 = 1 - rand1;
            }
            if (!(rand.nextFloat() < link.p)) continue;
            rand2 = 1 - rand2;
        }
    }

    public static String chrToStr(int chr) {
        String s = "";
        for (int i = 16; i > 0; --i) {
            s = s + (chr >>> 2 * i - 1 & 1);
            s = s + (chr >>> 2 * i - 2 & 1);
            if (i <= 1) continue;
            s = s + " ";
        }
        return s;
    }

    public void inheritGenericGenes(Genome parent1, Genome parent2) {
        float linkage = 0.5f;
        for (String chr : this.listGenericChromosomes()) {
            linkage = chr.startsWith("mhc") ? 0.05f : 0.5f;
            int mother = parent1.getRandomGenericGenes(1, parent1.getChromosome(chr), linkage);
            int father = parent2.getRandomGenericGenes(0, parent2.getChromosome(chr), linkage);
            this.entity.setChromosome(chr, mother | father);
        }
    }

    public void inheritGenes(Genome parent1, Genome parent2) {
        this.inheritNamedGenes(parent1, parent2);
        this.inheritGenericGenes(parent1, parent2);
        this.mutate();
    }

    public static class Linkage {
        public String gene;
        public float p;

        public Linkage(String gene, float p) {
            this.gene = gene;
            this.p = p;
        }

        public Linkage(String gene) {
            this.gene = gene;
            this.p = 0.5f;
        }
    }
}

