/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.genetics;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.genetics.HorseGenome;
import sekelsta.horse_colors.genetics.HorsePatternCalculator;
import sekelsta.horse_colors.renderer.TextureLayer;
import sekelsta.horse_colors.util.RandomSupplier;

public class HorseColorCalculator {
    static final RandomSupplier randSource = new RandomSupplier((List)ImmutableList.of((Object)"leg_white", (Object)"face_white", (Object)"star_choice"));
    private static final int GRAY_BODY_STAGES = 19;
    private static final int GRAY_MANE_STAGES = 20;

    public static String fixPath(String inStr) {
        if (inStr == null || inStr.contains(".png")) {
            return inStr;
        }
        if (inStr == "") {
            return null;
        }
        return "horse_colors:textures/entity/horse/" + inStr + ".png";
    }

    public static void adjustConcentration(TextureLayer layer, float power) {
        float r = (float)layer.red / 255.0f;
        float g = (float)layer.green / 255.0f;
        float b = (float)layer.blue / 255.0f;
        float red = (float)Math.pow(r, power) * 255.0f;
        float green = (float)Math.pow(g, power) * 255.0f;
        float blue = (float)Math.pow(b, power) * 255.0f;
        layer.red = Math.max(0, Math.min(255, (int)red));
        layer.green = Math.max(0, Math.min(255, (int)green));
        layer.blue = Math.max(0, Math.min(255, (int)blue));
    }

    public static void addWhite(TextureLayer layer, float white) {
        layer.red = (int)(255.0 * (double)white + (double)((float)layer.red * (1.0f - white)));
        layer.green = (int)(255.0 * (double)white + (double)((float)layer.green * (1.0f - white)));
        layer.blue = (int)(255.0 * (double)white + (double)((float)layer.blue * (1.0f - white)));
    }

    public static void setPheomelanin(TextureLayer layer, float concentration, float white) {
        layer.red = 228;
        layer.green = 192;
        layer.blue = 119;
        HorseColorCalculator.adjustConcentration(layer, concentration);
        HorseColorCalculator.addWhite(layer, white);
    }

    public static void setEumelanin(TextureLayer layer, float concentration, float white) {
        layer.red = 192;
        layer.green = 154;
        layer.blue = 95;
        HorseColorCalculator.adjustConcentration(layer, concentration);
        HorseColorCalculator.addWhite(layer, white);
    }

    public static void colorRedBody(HorseGenome horse, TextureLayer layer) {
        float concentration = 5.0f;
        float white = 0.08f;
        if (horse.isDoubleCream() || horse.isHomozygous("ivory", 1)) {
            concentration *= 0.05f;
            white += 0.4f;
        } else if (horse.isCreamPearl()) {
            concentration *= 0.1f;
        } else if (horse.hasCream()) {
            concentration *= 0.6f;
            white += 0.15f;
            if (horse.hasAllele("cream", 4)) {
                concentration *= 0.6f;
                white = (float)((double)white + 0.04);
            }
        } else if (horse.isPearl()) {
            concentration *= 0.6f;
            white += 0.15f;
            if (horse.hasAllele("cream", 4)) {
                concentration *= 0.9f;
                white += 0.04f;
            }
        } else if (horse.isHomozygous("cream", 4)) {
            concentration *= 0.9f;
            white += 0.04f;
        }
        if (horse.hasAllele("cameo", 1)) {
            concentration *= 0.3f;
            white += 0.25f;
        }
        if (horse.hasAllele("rufous", 1)) {
            concentration *= 1.1f;
        }
        if (horse.isHomozygous("dark_red", 1)) {
            concentration *= 1.2f;
        }
        if (horse.isHomozygous("dense", 1)) {
            concentration *= 1.1f;
            white -= 0.03f;
        }
        white = Math.max(white, 0.0f);
        HorseColorCalculator.setPheomelanin(layer, concentration, white);
        if (horse.isChestnut() && horse.isHomozygous("liver", 0)) {
            TextureLayer dark = new TextureLayer();
            HorseColorCalculator.setPheomelanin(dark, concentration * 5.0f, white);
            float a = 0.4f;
            layer.red = (int)((float)dark.red * a + (float)layer.red * (1.0f - a));
            layer.green = (int)((float)dark.green * a + (float)layer.green * (1.0f - a));
            layer.blue = (int)((float)dark.blue * a + (float)layer.blue * (1.0f - a));
            layer.clamp();
        }
    }

    public static TextureLayer getRedBody(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("base");
        HorseColorCalculator.colorRedBody(horse, layer);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    public static void colorBlackBody(HorseGenome horse, TextureLayer layer) {
        float concentration = 20.0f;
        float white = 0.02f;
        if (horse.isDoubleCream() || horse.isHomozygous("ivory", 1)) {
            concentration *= 0.02f;
        } else if (horse.isCreamPearl()) {
            concentration *= 0.025f;
        } else if (horse.hasCream()) {
            concentration *= 0.5f;
        } else if (horse.isPearl()) {
            concentration *= 0.25f;
            white += 0.18f;
        }
        if (horse.hasAllele("cameo", 1)) {
            concentration *= 0.2f;
            white += 0.2f;
        }
        if (horse.hasAllele("silver", 1)) {
            concentration *= 0.4f;
        }
        if (horse.isHomozygous("dense", 1)) {
            concentration *= 1.1f;
            white -= 0.01f;
        }
        white = Math.max(white, 0.0f);
        HorseColorCalculator.setEumelanin(layer, concentration, white);
    }

    public static TextureLayer getBlackBody(HorseGenome horse) {
        if (horse.isChestnut()) {
            return null;
        }
        TextureLayer layer = new TextureLayer();
        layer.description = "black body";
        if (horse.getMaxAllele("agouti") == 0) {
            layer.name = HorseColorCalculator.fixPath("base");
        } else if (horse.getMaxAllele("agouti") == 1 || horse.getMaxAllele("agouti") == 2) {
            layer.name = HorseColorCalculator.fixPath("brown");
        } else {
            return HorseColorCalculator.getSooty(horse);
        }
        HorseColorCalculator.colorBlackBody(horse, layer);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    public static void addRedManeTail(HorseGenome horse, List<TextureLayer> layers) {
        float PALOMINO_POWER = 0.2f;
        if (!horse.isChestnut()) {
            return;
        }
        if (horse.hasAllele("cream", 3)) {
            TextureLayer palomino_mane = new TextureLayer();
            palomino_mane.description = "palomino mane";
            palomino_mane.name = HorseColorCalculator.fixPath("manetail");
            HorseColorCalculator.colorRedBody(horse, palomino_mane);
            HorseColorCalculator.adjustConcentration(palomino_mane, 0.2f);
            HorseColorCalculator.setGrayConcentration(horse, palomino_mane);
            layers.add(palomino_mane);
        }
        if (!horse.isHomozygous("flaxen1", 0) && !horse.isHomozygous("flaxen2", 0)) {
            return;
        }
        TextureLayer flaxen = new TextureLayer();
        flaxen.name = HorseColorCalculator.fixPath("flaxen");
        flaxen.description = "flaxen";
        HorseColorCalculator.colorRedBody(horse, flaxen);
        float power = 1.0f;
        if (horse.hasAllele("cream", 3)) {
            power *= 0.2f;
        }
        float white = 0.0f;
        if (horse.isHomozygous("flaxen1", 0)) {
            power *= 0.5f;
            white += 0.2f;
        }
        if (horse.isHomozygous("flaxen2", 0)) {
            power *= 0.8f;
            white += 0.1f;
        }
        if (horse.hasAllele("flaxen_boost", 1)) {
            Math.pow(power, 1.5);
            white = (float)((double)white * 1.5);
        }
        HorseColorCalculator.adjustConcentration(flaxen, power);
        HorseColorCalculator.setGrayConcentration(horse, flaxen);
        HorseColorCalculator.addWhite(flaxen, white);
        layers.add(flaxen);
    }

    public static TextureLayer getBlackManeTail(HorseGenome horse) {
        if (horse.isChestnut()) {
            return null;
        }
        if (!horse.hasAllele("silver", 1)) {
            return null;
        }
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("flaxen");
        layer.description = "silver dapple mane";
        HorseColorCalculator.setEumelanin(layer, 0.3f, 0.0f);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    public static void colorSkin(HorseGenome horse, TextureLayer layer) {
        if (horse.isCreamPearl() || horse.hasAllele("cameo", 1)) {
            HorseColorCalculator.setEumelanin(layer, 5.0f, 0.2f);
        } else if (!horse.isDoubleCream() && !horse.isHomozygous("ivory", 1)) {
            HorseColorCalculator.setEumelanin(layer, 18.0f, 0.1f);
        }
        int old = layer.green;
        layer.green = (int)((float)(layer.green * 214) / 255.0f);
        old = layer.blue;
        layer.blue = (int)((float)(layer.blue * 182) / 255.0f);
    }

    public static void colorGray(HorseGenome horse, TextureLayer layer) {
        HorseColorCalculator.colorSkin(horse, layer);
        HorseColorCalculator.addWhite(layer, 0.99f);
    }

    public static TextureLayer getNose(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("nose");
        HorseColorCalculator.colorSkin(horse, layer);
        return layer;
    }

    public static TextureLayer getHooves(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("hooves");
        HorseColorCalculator.colorSkin(horse, layer);
        HorseColorCalculator.addWhite(layer, 0.4f);
        layer.red = (int)((float)layer.red * 255.0f / 255.0f);
        layer.green = (int)((float)layer.green * 229.0f / 255.0f);
        layer.blue = (int)((float)layer.blue * 184.0f / 255.0f);
        layer.clamp();
        return layer;
    }

    public static void addDun(HorseGenome horse, List<TextureLayer> layers) {
        int val;
        if (!horse.hasStripe()) {
            return;
        }
        TextureLayer white = new TextureLayer();
        white.name = HorseColorCalculator.fixPath("dun");
        white.alpha = 25;
        if (!horse.isDun()) {
            white.alpha = (int)((double)white.alpha * 0.1);
        }
        if (horse.isHomozygous("light_dun", 1)) {
            white.alpha *= 2;
        }
        white.type = TextureLayer.Type.SHADE;
        layers.add(white);
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("dun");
        layer.type = TextureLayer.Type.ROOT;
        float dunpower = 0.6f;
        if (!horse.isDun()) {
            dunpower = 0.9f;
        }
        layer.red = val = (int)(dunpower * 255.0f);
        layer.green = val;
        layer.blue = val;
        layers.add(layer);
    }

    public static TextureLayer getSooty(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        int sooty_level = horse.getSootyLevel();
        switch (sooty_level) {
            case 0: {
                return null;
            }
            case 1: {
                layer.alpha = 102;
                break;
            }
            case 2: {
                layer.alpha = 204;
                break;
            }
            case 3: {
                layer.alpha = 255;
                break;
            }
            default: {
                layer.alpha = 255;
            }
        }
        if (horse.hasAllele("donkey_dark", 1) && !horse.isChestnut()) {
            layer.alpha = 255;
        }
        layer.name = HorseColorCalculator.fixPath("sooty_countershade");
        if (horse.isDappleInclined()) {
            layer.name = HorseColorCalculator.fixPath("sooty_dapple");
        } else if (horse.isChestnut()) {
            layer.name = HorseColorCalculator.fixPath("base");
            layer.alpha /= 2;
        }
        HorseColorCalculator.colorBlackBody(horse, layer);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    public static TextureLayer getMealy(HorseGenome horse) {
        if (!horse.isMealy()) {
            return null;
        }
        TextureLayer light_belly = new TextureLayer();
        int spread = 1;
        int color = 0;
        if (horse.hasAllele("mealy1", 1)) {
            spread += 2;
        }
        if (horse.hasAllele("mealy2", 1)) {
            ++color;
        }
        if (horse.isHomozygous("flaxen2", 0)) {
            ++spread;
        }
        String prefix = "";
        if (horse.isHomozygous("light_legs", 1)) {
            prefix = "l";
        } else if (horse.hasAllele("less_light_legs", 0)) {
            prefix = "l";
            if (spread > 1) {
                --spread;
                light_belly.next = new TextureLayer();
                light_belly.next.name = HorseColorCalculator.fixPath("mealy/mealy1");
                HorseColorCalculator.colorRedBody(horse, light_belly.next);
                HorseColorCalculator.adjustConcentration(light_belly.next, 0.04f * (float)(2 - color));
            }
        }
        light_belly.name = HorseColorCalculator.fixPath("mealy/" + prefix + "mealy" + spread);
        HorseColorCalculator.colorRedBody(horse, light_belly);
        HorseColorCalculator.adjustConcentration(light_belly, 0.04f * (float)(2 - color));
        return light_belly;
    }

    public static void addPoints(HorseGenome horse, List<TextureLayer> layers) {
        String prefix = "";
        if (horse.hasAllele("reduced_points", 1)) {
            prefix = "wild_";
        }
        if (horse.hasStripe()) {
            TextureLayer stripe = new TextureLayer();
            stripe.name = horse.hasAllele("cross", 1) ? HorseColorCalculator.fixPath("marks/" + prefix + "cross") : HorseColorCalculator.fixPath("marks/" + prefix + "dorsal");
            if (horse.isChestnut()) {
                HorseColorCalculator.colorRedBody(horse, stripe);
            } else {
                HorseColorCalculator.colorBlackBody(horse, stripe);
            }
            HorseColorCalculator.adjustConcentration(stripe, 1.2f);
            layers.add(stripe);
        } else if (!horse.isChestnut()) {
            TextureLayer points = new TextureLayer();
            points.name = HorseColorCalculator.fixPath(prefix + "bay");
            HorseColorCalculator.colorBlackBody(horse, points);
            layers.add(points);
        }
    }

    public static void addGray(HorseGenome horse, List<TextureLayer> layers) {
        if (!horse.isGray()) {
            return;
        }
        float rate = horse.getGrayRate();
        float mane_rate = horse.getGrayManeRate();
        int body_stage = HorseColorCalculator.grayStage(horse, rate, 19, 0.25f);
        int mane_stage = HorseColorCalculator.grayStage(horse, mane_rate, 20, 0.3f);
        if (body_stage > 0) {
            TextureLayer body = new TextureLayer();
            body.name = body_stage > 19 ? HorseColorCalculator.fixPath("body") : HorseColorCalculator.fixPath("gray/dapple" + body_stage);
            HorseColorCalculator.colorGray(horse, body);
            layers.add(body);
        }
        if (mane_stage > 0) {
            TextureLayer mane = new TextureLayer();
            mane.name = mane_stage > 20 ? HorseColorCalculator.fixPath("manetail") : HorseColorCalculator.fixPath("gray/mane" + mane_stage);
            HorseColorCalculator.colorGray(horse, mane);
            layers.add(mane);
        }
    }

    public static int grayStage(HorseGenome horse, float rate, int num_stages, float delay) {
        int YEAR_TICKS = HorseConfig.getYearLength();
        int MAX_AGE = HorseConfig.GROWTH.getMaxAge();
        int age = horse.getAge() + 24000;
        age = Math.min(age, MAX_AGE);
        if (!HorseConfig.GROWTH.grayGradually) {
            age = (int)((float)MAX_AGE * 0.5f);
        }
        float gray_age = (float)age / ((float)YEAR_TICKS * rate);
        if ((gray_age = (gray_age - delay) / (1.0f - delay)) <= 0.0f) {
            return 0;
        }
        if (gray_age >= 1.0f) {
            return num_stages + 1;
        }
        return (int)(gray_age * (float)num_stages);
    }

    public static float grayConcentration(HorseGenome horse, float rate) {
        int stage = HorseColorCalculator.grayStage(horse, rate, 50, 0.0f);
        double val = 1.1 + Math.pow(1.06, stage) * (double)stage / 50.0 * (double)stage / 50.0;
        return (float)val;
    }

    public static void setGrayConcentration(HorseGenome horse, TextureLayer layer) {
        if (horse.isGray()) {
            float prevRed = layer.red;
            float prevGreen = layer.green;
            float prevBlue = layer.blue;
            float concentration = HorseColorCalculator.grayConcentration(horse, horse.getGrayRate());
            HorseColorCalculator.adjustConcentration(layer, concentration);
            float lightnessDiff = (float)(layer.red + layer.green + layer.blue) / (prevRed + prevGreen + prevBlue);
            layer.red = (int)(((float)layer.red + lightnessDiff * prevRed) / 2.0f);
            layer.green = (int)(((float)layer.green + lightnessDiff * prevGreen) / 2.0f);
            layer.blue = (int)(((float)layer.blue + lightnessDiff * prevBlue) / 2.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static List<TextureLayer> getTexturePaths(HorseGenome horse) {
        ArrayList<TextureLayer> textureLayers = new ArrayList<TextureLayer>();
        TextureLayer red = HorseColorCalculator.getRedBody(horse);
        textureLayers.add(red);
        textureLayers.add(HorseColorCalculator.getMealy(horse));
        TextureLayer black = HorseColorCalculator.getBlackBody(horse);
        textureLayers.add(black);
        HorseColorCalculator.addDun(horse, textureLayers);
        HorseColorCalculator.addPoints(horse, textureLayers);
        HorseColorCalculator.addRedManeTail(horse, textureLayers);
        textureLayers.add(HorseColorCalculator.getBlackManeTail(horse));
        HorseColorCalculator.addGray(horse, textureLayers);
        textureLayers.add(HorseColorCalculator.getNose(horse));
        textureLayers.add(HorseColorCalculator.getHooves(horse));
        if (horse.hasAllele("KIT", 14)) {
            TextureLayer roan = new TextureLayer();
            roan.name = HorseColorCalculator.fixPath("roan/roan");
            textureLayers.add(roan);
        }
        HorsePatternCalculator.addFaceMarkings(horse, textureLayers);
        if (horse.showsLegMarkings()) {
            String[] leg_markings;
            for (String marking : leg_markings = HorsePatternCalculator.getLegMarkings(horse)) {
                TextureLayer layer = new TextureLayer();
                layer.name = marking;
                textureLayers.add(layer);
            }
        }
        textureLayers.add(HorsePatternCalculator.getPinto(horse));
        HorsePatternCalculator.addLeopard(horse, textureLayers);
        TextureLayer highlights = new TextureLayer();
        highlights.name = HorseColorCalculator.fixPath("base");
        highlights.type = TextureLayer.Type.HIGHLIGHT;
        highlights.alpha = 51;
        textureLayers.add(highlights);
        TextureLayer shading = new TextureLayer();
        shading.name = HorseColorCalculator.fixPath("shading");
        shading.type = TextureLayer.Type.SHADE;
        shading.alpha = 127;
        textureLayers.add(shading);
        TextureLayer common = new TextureLayer();
        common.name = HorseColorCalculator.fixPath("common");
        textureLayers.add(common);
        return textureLayers;
    }
}

