/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.genetics;

import java.util.List;
import sekelsta.horse_colors.genetics.HorseColorCalculator;
import sekelsta.horse_colors.genetics.HorseGenome;
import sekelsta.horse_colors.renderer.TextureLayer;

public class HorsePatternCalculator {
    public static boolean hasPigmentInEars(HorseGenome horse) {
        return HorsePatternCalculator.getPreviousFaceWhiteLevel(horse) <= 18;
    }

    public static int getPreviousFaceWhiteLevel(HorseGenome horse) {
        int white = -2;
        if (horse.hasAllele("white_suppression", 1)) {
            white -= 4;
        }
        white += horse.countAlleles("KIT", 1);
        white += horse.countAlleles("KIT", 2);
        white += 2 * horse.countAlleles("KIT", 3);
        white += 2 * horse.countAlleles("KIT", 4);
        white += 3 * horse.countAlleles("KIT", 5);
        white += 3 * horse.countAlleles("KIT", 6);
        white += 3 * horse.countW20();
        white += 4 * horse.countAlleles("KIT", 9);
        white += 6 * horse.countAlleles("MITF", 0);
        white += 9 * horse.countAlleles("MITF", 1);
        white += 8 * horse.countAlleles("MITF", 2);
        white += 7 * horse.countAlleles("PAX3", 1);
        white += 8 * horse.countAlleles("PAX3", 2);
        white += 3 * horse.countAlleles("white_star", 1);
        white += horse.countAlleles("white_forelegs", 1);
        white += horse.countAlleles("white_hindlegs", 1);
        if (horse.hasMC1RWhiteBoost()) {
            white += 2;
        }
        return white;
    }

    public static TextureLayer getPreviousFaceMarking(HorseGenome horse) {
        int white = HorsePatternCalculator.getPreviousFaceWhiteLevel(horse);
        int unused_bits = 2;
        int random = horse.getChromosome("random") << 1 >>> 1 + unused_bits;
        if ((white += random & 3) <= 0) {
            return null;
        }
        int face_marking = white / 5;
        TextureLayer layer = new TextureLayer();
        String folder = "face/";
        switch (face_marking) {
            case 0: {
                break;
            }
            case 1: {
                layer.name = HorseColorCalculator.fixPath(folder + "star");
                break;
            }
            case 2: {
                layer.name = HorseColorCalculator.fixPath(folder + "strip");
                break;
            }
            case 3: {
                layer.name = HorseColorCalculator.fixPath(folder + "blaze");
                break;
            }
            default: {
                layer.name = HorseColorCalculator.fixPath(folder + "blaze");
            }
        }
        return layer;
    }

    public static void addFaceMarkings(HorseGenome horse, List<TextureLayer> textureLayers) {
        textureLayers.add(HorsePatternCalculator.getPreviousFaceMarking(horse));
    }

    public static String[] getLegMarkings(HorseGenome horse) {
        WhiteBoost whiteBoost = new WhiteBoost(horse);
        String[] legs = new String[4];
        int random = HorseColorCalculator.randSource.getVal("leg_white", horse.getChromosome("random"));
        random = random << 1 >>> 5;
        for (int i = 0; i < 4; ++i) {
            int r = random & 7;
            random >>>= 3;
            int w = whiteBoost.getForelegs();
            if (i >= 2) {
                w = whiteBoost.getHindlegs();
            }
            if (w > -2) {
                w += whiteBoost.conditional;
            }
            legs[i] = w < 0 ? null : HorseColorCalculator.fixPath("socks/" + String.valueOf(i) + "_" + String.valueOf(Math.min(7, w / 2 + r)));
        }
        return legs;
    }

    public static TextureLayer getPinto(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        if (horse.isWhite()) {
            layer.name = HorseColorCalculator.fixPath("pinto/white");
            return layer;
        }
        String folder = "pinto/";
        if (horse.isTobiano()) {
            layer.name = horse.hasAllele("frame", 1) ? (horse.isHomozygous("MITF", 0) ? HorseColorCalculator.fixPath(folder + "medicine_hat") : HorseColorCalculator.fixPath(folder + "war_shield")) : HorseColorCalculator.fixPath(folder + "tobiano");
        } else if (horse.hasAllele("frame", 1)) {
            layer.name = HorseColorCalculator.fixPath(folder + "frame");
        } else if (horse.isHomozygous("MITF", 0)) {
            layer.name = HorseColorCalculator.fixPath(folder + "splash");
        } else if (horse.hasAllele("KIT", 12)) {
            layer.name = HorseColorCalculator.fixPath(folder + "sabino");
        }
        return layer;
    }

    public static void addLeopard(HorseGenome horse, List<TextureLayer> textureLayers) {
        if (!horse.hasAllele("leopard", 1)) {
            return;
        }
        TextureLayer hooves = new TextureLayer();
        hooves.name = horse.isHomozygous("leopard", 1) ? HorseColorCalculator.fixPath("leopard/lplp_features") : HorseColorCalculator.fixPath("leopard/lp_features");
        textureLayers.add(hooves);
        int patn = 7 * horse.countAlleles("PATN1", 1);
        patn += 2 * horse.countAlleles("PATN2", 1);
        TextureLayer spread = new TextureLayer();
        if ((patn += horse.countAlleles("PATN3", 1)) == 0) {
            spread.name = HorseColorCalculator.fixPath("leopard/varnish_roan");
            textureLayers.add(spread);
            return;
        }
        WhiteBoost whiteBoost = new WhiteBoost(horse);
        spread.name = (patn += whiteBoost.getBlanket()) < 1 ? HorseColorCalculator.fixPath("leopard/varnish_roan") : HorseColorCalculator.fixPath("leopard/blanket" + patn);
        TextureLayer spots = new TextureLayer();
        spots.name = horse.isHomozygous("leopard", 1) ? HorseColorCalculator.fixPath("leopard/fewspot") : (horse.hasAllele("white_suppression", 1) ? HorseColorCalculator.fixPath("leopard/leopard_large") : (horse.hasAllele("marble", 1) ? HorseColorCalculator.fixPath("leopard/leopard_marble") : HorseColorCalculator.fixPath("leopard/leopard")));
        if (patn >= 8) {
            textureLayers.add(spots);
            return;
        }
        spots.type = TextureLayer.Type.MASK;
        spread.next = spots;
        textureLayers.add(spread);
    }

    public static class WhiteBoost {
        public int general = 0;
        public int conditional = 0;
        public int leg = 0;
        public int face = 0;
        public int foreleg = 0;
        public int hindleg = 0;
        public int forehead = 0;
        public int noseBridge = 0;
        public int muzzle = 0;
        public int blanket = 0;

        public WhiteBoost(HorseGenome horse) {
            this.foreleg = 2 * horse.countAlleles("white_forelegs", 1);
            this.hindleg = 2 * horse.countAlleles("white_hindlegs", 1);
            this.forehead += horse.countAlleles("white_star", 1);
            this.setOldLegWhite(horse);
            if (horse.hasMC1RWhiteBoost()) {
                this.conditional += 2;
            }
            this.setGeneralWhite(horse);
            this.face = WhiteBoost.getOldFaceWhiteLevel(horse);
        }

        private void setGeneralWhite(HorseGenome horse) {
            if (horse.hasAllele("white_suppression", 1)) {
                this.general -= 4;
            }
            this.general += horse.countAlleles("KIT", 1);
            this.general += horse.countAlleles("KIT", 2);
            this.general += 2 * horse.countAlleles("KIT", 3);
            this.general += 2 * horse.countAlleles("KIT", 4);
            this.general += 3 * horse.countAlleles("KIT", 5);
            this.general += 3 * horse.countAlleles("KIT", 6);
            this.general += 3 * horse.countW20();
            this.general += 4 * horse.countAlleles("KIT", 9);
            this.general += 2 * horse.countAlleles("MITF", 0);
            this.general += 6 * horse.countAlleles("MITF", 1);
            this.general += 2 * horse.countAlleles("MITF", 2);
            this.general += 2 * horse.countAlleles("PAX3", 1);
            this.general += 3 * horse.countAlleles("PAX3", 2);
            if (horse.hasAllele("white_star", 1)) {
                ++this.general;
            }
        }

        public static int getOldFaceWhiteLevel(HorseGenome horse) {
            int white = -2;
            white += 6 * horse.countAlleles("MITF", 0);
            white += 9 * horse.countAlleles("MITF", 1);
            white += 8 * horse.countAlleles("MITF", 2);
            white += 7 * horse.countAlleles("PAX3", 1);
            white += 8 * horse.countAlleles("PAX3", 2);
            white += horse.countAlleles("white_forelegs", 1);
            white += horse.countAlleles("white_hindlegs", 1);
            if (horse.hasMC1RWhiteBoost()) {
                white += 2;
            }
            return white;
        }

        private void setOldLegWhite(HorseGenome horse) {
            int white = -3;
            white += 1 * horse.countAlleles("KIT", 2);
            white += 1 * horse.countAlleles("KIT", 3);
            white += 2 * horse.countAlleles("KIT", 4);
            white += 2 * horse.countAlleles("KIT", 5);
            white += 3 * horse.countAlleles("KIT", 6);
            white += 4 * horse.countW20();
            this.leg = white += 4 * horse.countAlleles("KIT", 9);
        }

        public void setBlanketWhite(HorseGenome horse) {
            if (horse.hasAllele("leopard_suppression", 1)) {
                this.blanket -= 1 + horse.countAlleles("PATN1", 1);
            }
            if (horse.isHomozygous("leopard_suppression2", 1)) {
                --this.blanket;
            }
            if (horse.hasAllele("PATN_boost1", 1)) {
                ++this.blanket;
            }
            if (horse.isHomozygous("PATN_boost2", 1)) {
                ++this.blanket;
            }
        }

        public int getForelegs() {
            return this.general + this.leg + this.foreleg;
        }

        public int getHindlegs() {
            return this.general + this.leg + this.hindleg;
        }

        public int getBlanket() {
            return this.general / 2 + this.blanket;
        }

        public int getForehead() {
            return (this.general + this.face) / 5 + this.forehead;
        }

        public int getNoseBridge() {
            return (this.general + this.face) / 5 + this.noseBridge;
        }

        public int getMuzzle() {
            return (this.general + this.face) / 5 + this.muzzle;
        }
    }
}

