/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sekelsta.horse_colors.client.GeneBookScreen;
import sekelsta.horse_colors.entity.ModEntities;
import sekelsta.horse_colors.genetics.Genome;
import sekelsta.horse_colors.genetics.HorseGenome;
import sekelsta.horse_colors.genetics.Species;

public class GeneBookItem
extends Item {
    public GeneBookItem() {
        this.func_77625_d(1);
    }

    public static boolean validBookTagContents(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_150297_b("species", 8)) {
            return false;
        }
        if (!nbt.func_150297_b("genes", 8)) {
            return false;
        }
        try {
            Species species = Species.valueOf(nbt.func_74779_i("species"));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static Species getSpecies(NBTTagCompound compoundnbt) {
        String s = compoundnbt.func_74779_i("species");
        if (!StringUtils.func_151246_b((String)s)) {
            return Species.valueOf(s);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound compoundnbt = stack.func_77978_p();
            String s = compoundnbt.func_74779_i("species");
            Species species = GeneBookItem.getSpecies(compoundnbt);
            if (species != null) {
                String translation = null;
                switch (species) {
                    case HORSE: {
                        translation = ModEntities.HORSE_GENETIC.getName();
                        break;
                    }
                    case DONKEY: {
                        translation = ModEntities.DONKEY_GENETIC.getName();
                        break;
                    }
                    case MULE: {
                        translation = ModEntities.MULE_GENETIC.getName();
                    }
                }
                if (translation != null) {
                    tooltip.add(I18n.func_74838_a((String)("entity." + translation + ".name")));
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (GeneBookItem.validBookTagContents(itemstack.func_77978_p())) {
            if (worldIn.field_72995_K) {
                this.openGeneBook(itemstack.func_77978_p());
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        System.out.println("Gene book has invalid NBT");
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void openGeneBook(NBTTagCompound nbt) {
        Minecraft mc = Minecraft.func_71410_x();
        HorseGenome genome = new HorseGenome(GeneBookItem.getSpecies(nbt));
        ((Genome)genome).genesFromString(nbt.func_74779_i("genes"));
        mc.func_147108_a((GuiScreen)new GeneBookScreen(genome));
    }
}

