/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.renderer;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sekelsta.horse_colors.renderer.TextureLayer;

@SideOnly(value=Side.CLIENT)
public class CustomLayeredTexture
extends AbstractTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    public final List<TextureLayer> layers;

    public CustomLayeredTexture(List<TextureLayer> textures) {
        this.layers = Lists.newArrayList(textures);
        if (this.layers.isEmpty()) {
            throw new IllegalStateException("Layered texture with no layers.");
        }
    }

    public void func_110551_a(IResourceManager manager) throws IOException {
        Iterator<TextureLayer> iterator = this.layers.iterator();
        TextureLayer baselayer = iterator.next();
        BufferedImage baseimage = baselayer.getLayer(manager);
        if (baseimage == null) {
            return;
        }
        baselayer.colorLayer(baseimage);
        while (iterator.hasNext()) {
            BufferedImage image;
            TextureLayer layer = iterator.next();
            if (layer == null || layer.name == null || (image = layer.getLayer(manager)) == null) continue;
            layer.combineLayers(baseimage, image);
        }
        this.loadImage(baseimage);
    }

    private void loadImage(BufferedImage imageIn) {
        TextureUtil.func_110987_a((int)this.func_110552_b(), (BufferedImage)imageIn);
    }
}

