/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.renderer.CustomLayeredTexture;
import sekelsta.horse_colors.renderer.HorseArmorLayer;
import sekelsta.horse_colors.renderer.HorseGeneticModel;

@SideOnly(value=Side.CLIENT)
public class HorseGeneticRenderer
extends RenderLiving<AbstractHorseGenetic> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    protected void preRenderCallback(AbstractHorseGenetic horse, float partialTickTime) {
        float scale = horse.getProportionalScale();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        super.func_77041_b((EntityLivingBase)horse, partialTickTime);
    }

    public HorseGeneticRenderer(RenderManager renderManager) {
        super(renderManager, (ModelBase)new HorseGeneticModel(), 0.75f);
        this.func_177094_a(new HorseArmorLayer(this));
    }

    public ResourceLocation getEntityTexture(AbstractHorseGenetic entity) {
        if (entity instanceof IGeneticEntity) {
            String s = entity.getGenes().getTexture();
            ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation(s);
                Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new CustomLayeredTexture(entity.getGenes().getVariantTexturePaths()));
                LAYERED_LOCATION_CACHE.put(s, resourcelocation);
            }
            return resourcelocation;
        }
        System.out.println("Trying to render an ineligible entity");
        return null;
    }
}

