/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.renderer;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureLayer {
    private static final Logger LOGGER = LogManager.getLogger();
    public String name = null;
    public String description = null;
    public Type type = Type.NORMAL;
    public int alpha = 255;
    public int red = 255;
    public int green = 255;
    public int blue = 255;
    public TextureLayer next;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getLayer(IResourceManager manager) {
        if (this.name == null) {
            LOGGER.error("Attempting to load unspecified texture (name is null)\n");
            return null;
        }
        try (IResource iresource = manager.func_110536_a(new ResourceLocation(this.name));){
            BufferedImage image = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            if (this.next != null) {
                this.colorLayer(image);
                this.next.combineLayers(image, this.next.getLayer(manager));
                this.red = 255;
                this.green = 255;
                this.blue = 255;
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't load layered image", (Throwable)ioexception);
            return null;
        }
    }

    public void combineLayers(BufferedImage base, BufferedImage image) {
        switch (this.type) {
            case NORMAL: {
                this.blendLayer(base, image);
                break;
            }
            case NO_ALPHA: {
                this.blendLayerKeepAlpha(base, image);
                break;
            }
            case MASK: {
                this.maskLayer(base, image);
                break;
            }
            case SHADE: {
                this.shadeLayer(base, image);
                break;
            }
            case HIGHLIGHT: {
                this.highlightLayer(base, image);
                break;
            }
            case POWER: {
                this.powerLayer(base, image);
                break;
            }
            case ROOT: {
                this.rootLayer(base, image);
            }
        }
    }

    public void blendLayer(BufferedImage base, BufferedImage image) {
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                TextureLayer.blendPixel(base, j, i, this.multiply(image.getRGB(j, i)));
            }
        }
    }

    public void blendLayerKeepAlpha(BufferedImage base, BufferedImage image) {
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int cb = base.getRGB(j, i);
                int ci = this.multiply(image.getRGB(j, i));
                float a = (float)TextureLayer.getAlpha(ci) / 255.0f;
                float r = TextureLayer.getRed(ci);
                float g = TextureLayer.getGreen(ci);
                float b = TextureLayer.getBlue(ci);
                float br = TextureLayer.getRed(cb);
                float bg = TextureLayer.getGreen(cb);
                float bb = TextureLayer.getBlue(cb);
                int fa = TextureLayer.getAlpha(cb);
                int fr = (int)(r * a + br * (1.0f - a));
                int fg = (int)(g * a + bg * (1.0f - a));
                int fb = (int)(b * a + bb * (1.0f - a));
                base.setRGB(j, i, TextureLayer.getCombined(fa, fb, fg, fr));
            }
        }
    }

    public void shadeLayer(BufferedImage base, BufferedImage image) {
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int color = base.getRGB(j, i);
                int shading = this.multiply(image.getRGB(j, i));
                base.setRGB(j, i, this.shade(color, shading));
            }
        }
    }

    public void highlightLayer(BufferedImage base, BufferedImage image) {
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int color = base.getRGB(j, i);
                int highlight = this.multiply(image.getRGB(j, i));
                base.setRGB(j, i, this.highlight(color, highlight));
            }
        }
    }

    public void maskLayer(BufferedImage base, BufferedImage image) {
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int color = base.getRGB(j, i);
                int mask = image.getRGB(j, i);
                int maskedColor = this.mask(color, mask);
                base.setRGB(j, i, maskedColor);
            }
        }
    }

    public void powerLayer(BufferedImage base, BufferedImage image) {
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int color = base.getRGB(j, i);
                int exp = image.getRGB(j, i);
                exp = this.multiply(exp);
                TextureLayer.blendPixel(base, j, i, this.power(color, exp));
            }
        }
    }

    public void rootLayer(BufferedImage base, BufferedImage image) {
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int color = base.getRGB(j, i);
                int exp = image.getRGB(j, i);
                exp = this.multiply(exp);
                TextureLayer.blendPixel(base, j, i, this.root(color, exp));
            }
        }
    }

    public void colorLayer(BufferedImage image) {
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int color = image.getRGB(j, i);
                image.setRGB(j, i, this.multiply(color));
            }
        }
    }

    public int multiply(int color) {
        int a = TextureLayer.getAlpha(color);
        a = (int)((float)a * (float)this.alpha / 255.0f);
        int r = TextureLayer.getRed(color);
        r = (int)((float)r * (float)this.red / 255.0f);
        int g = TextureLayer.getGreen(color);
        g = (int)((float)g * (float)this.green / 255.0f);
        int b = TextureLayer.getBlue(color);
        b = (int)((float)b * (float)this.blue / 255.0f);
        return TextureLayer.getCombined(a, b, g, r);
    }

    public int shade(int color, int shading) {
        float cr = TextureLayer.getRed(color);
        float cg = TextureLayer.getGreen(color);
        float cb = TextureLayer.getBlue(color);
        float sr = TextureLayer.getRed(shading);
        float sg = TextureLayer.getGreen(shading);
        float sb = TextureLayer.getBlue(shading);
        float a = (float)TextureLayer.getAlpha(shading) / 255.0f;
        float avg = (cr + cg + cb) / 255.0f / 3.0f;
        float na = 1.0f - (a *= 0.5f + 0.5f * (1.0f - avg) * (1.0f - avg));
        float r = Math.max(0.0f, Math.min(255.0f, sr * a + cr * na));
        float g = Math.max(0.0f, Math.min(255.0f, sg * a + cg * na));
        float b = Math.max(0.0f, Math.min(255.0f, sb * a + cb * na));
        int ca = TextureLayer.getAlpha(color);
        return TextureLayer.getCombined(ca, (int)b, (int)g, (int)r);
    }

    public int highlight(int color, int light) {
        float r0 = TextureLayer.getRed(color);
        float g0 = TextureLayer.getGreen(color);
        float b0 = TextureLayer.getBlue(color);
        float r1 = TextureLayer.getRed(light);
        float g1 = TextureLayer.getGreen(light);
        float b1 = TextureLayer.getBlue(light);
        float a = (float)TextureLayer.getAlpha(light) / 255.0f;
        float avg = (r0 + g0 + b0) / 255.0f / 3.0f;
        float na = 1.0f - (a *= 0.5f + 0.5f * avg * avg);
        float r = Math.max(0.0f, Math.min(255.0f, r1 * a + r0 * na));
        float g = Math.max(0.0f, Math.min(255.0f, g1 * a + g0 * na));
        float b = Math.max(0.0f, Math.min(255.0f, b1 * a + b0 * na));
        int ca = TextureLayer.getAlpha(color);
        return TextureLayer.getCombined(ca, (int)b, (int)g, (int)r);
    }

    public int power(int color, int exp) {
        float r0 = (float)TextureLayer.getRed(color) / 255.0f;
        float g0 = (float)TextureLayer.getGreen(color) / 255.0f;
        float b0 = (float)TextureLayer.getBlue(color) / 255.0f;
        float r1 = Math.max(0.002f, (float)TextureLayer.getRed(exp) / 255.0f);
        float g1 = Math.max(0.002f, (float)TextureLayer.getGreen(exp) / 255.0f);
        float b1 = Math.max(0.002f, (float)TextureLayer.getBlue(exp) / 255.0f);
        int r = this.clamp((int)(255.0 * Math.pow(r0, 1.0f / r1)));
        int g = this.clamp((int)(255.0 * Math.pow(g0, 1.0f / g1)));
        int b = this.clamp((int)(255.0 * Math.pow(b0, 1.0f / b1)));
        int a = TextureLayer.getAlpha(exp);
        return TextureLayer.getCombined(a, b, g, r);
    }

    public int root(int color, int exp) {
        float r0 = (float)TextureLayer.getRed(color) / 255.0f;
        float g0 = (float)TextureLayer.getGreen(color) / 255.0f;
        float b0 = (float)TextureLayer.getBlue(color) / 255.0f;
        float r1 = (float)TextureLayer.getRed(exp) / 255.0f;
        float g1 = (float)TextureLayer.getGreen(exp) / 255.0f;
        float b1 = (float)TextureLayer.getBlue(exp) / 255.0f;
        int r = this.clamp((int)(255.0 * Math.pow(r0, r1)));
        int g = this.clamp((int)(255.0 * Math.pow(g0, g1)));
        int b = this.clamp((int)(255.0 * Math.pow(b0, b1)));
        int a = TextureLayer.getAlpha(exp);
        return TextureLayer.getCombined(a, b, g, r);
    }

    public int mask(int color, int mask) {
        float a = TextureLayer.getAlpha(color) * TextureLayer.getAlpha(mask);
        a /= 255.0f;
        float weight = (float)this.alpha / 255.0f;
        a = a * weight + (float)TextureLayer.getAlpha(color) * (1.0f - weight);
        int r = TextureLayer.getRed(color);
        int g = TextureLayer.getGreen(color);
        int b = TextureLayer.getBlue(color);
        return TextureLayer.getCombined((int)a, b, g, r);
    }

    public void clamp() {
        this.red = this.clamp(this.red);
        this.green = this.clamp(this.green);
        this.blue = this.clamp(this.blue);
    }

    private int clamp(int x) {
        return Math.max(0, Math.min(x, 255));
    }

    private String getAbv(String s) {
        int i = s.lastIndexOf("/");
        if (i > -1) {
            s = s.substring(i + 1);
        }
        if (s.endsWith(".png")) {
            s = s.substring(0, s.length() - 4);
        }
        return s;
    }

    public String toString() {
        if (this.name == null) {
            return "";
        }
        String s = this.getAbv(this.name);
        s = s + "-" + this.type.toString();
        s = s + "-" + Integer.toHexString(this.alpha);
        s = s + Integer.toHexString(this.red);
        s = s + Integer.toHexString(this.green);
        s = s + Integer.toHexString(this.blue);
        return s;
    }

    public static int getAlpha(int col) {
        return col >> 24 & 0xFF;
    }

    public static int getRed(int col) {
        return col >> 16 & 0xFF;
    }

    public static int getGreen(int col) {
        return col >> 8 & 0xFF;
    }

    public static int getBlue(int col) {
        return col >> 0 & 0xFF;
    }

    public static int getCombined(int alpha, int blue, int green, int red) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | (blue & 0xFF) << 0;
    }

    public static void blendPixel(BufferedImage image, int xIn, int yIn, int colIn) {
        int i = image.getRGB(xIn, yIn);
        float f = (float)TextureLayer.getAlpha(colIn) / 255.0f;
        float f1 = (float)TextureLayer.getBlue(colIn) / 255.0f;
        float f2 = (float)TextureLayer.getGreen(colIn) / 255.0f;
        float f3 = (float)TextureLayer.getRed(colIn) / 255.0f;
        float f4 = (float)TextureLayer.getAlpha(i) / 255.0f;
        float f5 = (float)TextureLayer.getBlue(i) / 255.0f;
        float f6 = (float)TextureLayer.getGreen(i) / 255.0f;
        float f7 = (float)TextureLayer.getRed(i) / 255.0f;
        float f8 = 1.0f - f;
        float f9 = f * f + f4 * f8;
        float f10 = f1 * f + f5 * f8;
        float f11 = f2 * f + f6 * f8;
        float f12 = f3 * f + f7 * f8;
        if (f9 > 1.0f) {
            f9 = 1.0f;
        }
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        if (f11 > 1.0f) {
            f11 = 1.0f;
        }
        if (f12 > 1.0f) {
            f12 = 1.0f;
        }
        int j = (int)(f9 * 255.0f);
        int k = (int)(f10 * 255.0f);
        int l = (int)(f11 * 255.0f);
        int i1 = (int)(f12 * 255.0f);
        image.setRGB(xIn, yIn, TextureLayer.getCombined(j, k, l, i1));
    }

    public static enum Type {
        NORMAL,
        NO_ALPHA,
        MASK,
        SHADE,
        HIGHLIGHT,
        POWER,
        ROOT;

    }
}

