/*
 * Decompiled with CFR 0.152.
 */
package felinoid.horse_colors;

import felinoid.horse_colors.EntityHorseFelinoid;

public class HorseColorCalculator {
    private static final int GRAY_LEG_BITS = 2;
    private static final int FACE_MARKING_BITS = 2;

    public static String getBaseTexture(EntityHorseFelinoid horse) {
        if (horse.isHomozygous("cream", 3) && horse.hasAllele("gray", 1)) {
            return "white";
        }
        if (horse.hasAllele("gray", 1)) {
            return "gray";
        }
        if (horse.isHomozygous("cream", 3)) {
            if (horse.isChestnut()) {
                return "cremello";
            }
            String base = "";
            switch (horse.getMaxAllele("agouti")) {
                case 0: {
                    base = "smoky_cream";
                }
                case 1: 
                case 2: {
                    base = "brown_cream";
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    base = "perlino";
                }
            }
            if (horse.hasAllele("silver", 1)) {
                base = "silver_" + base;
            }
            return base;
        }
        if (horse.hasAllele("cream", 3)) {
            if (horse.hasAllele("dun", 3) || horse.hasAllele("dun", 2)) {
                if (horse.isChestnut()) {
                    return "dunalino";
                }
                String base = "";
                switch (horse.getMaxAllele("agouti")) {
                    case 0: {
                        base = "smoky_grullo";
                    }
                    case 1: 
                    case 2: {
                        base = "smoky_brown_dun";
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        base = "dunskin";
                    }
                }
                if (horse.hasAllele("silver", 1)) {
                    return "silver_" + base;
                }
                return base;
            }
            if (horse.isChestnut()) {
                return "palomino";
            }
            String base = "";
            switch (horse.getMaxAllele("agouti")) {
                case 0: {
                    base = "smoky_black";
                }
                case 1: 
                case 2: {
                    base = "smoky_brown";
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    base = "buckskin";
                }
            }
            if (horse.hasAllele("silver", 1)) {
                return "silver_" + base;
            }
            return base;
        }
        if (horse.hasAllele("dun", 3) || horse.hasAllele("dun", 2)) {
            if (horse.isChestnut()) {
                if (horse.getMaxAllele("liver") == 0) {
                    switch (horse.getPhenotype("flaxen")) {
                        case 0: {
                            return "liver_dun";
                        }
                        case 1: {
                            return "partly_flaxen_liver_dun";
                        }
                        case 2: {
                            return "flaxen_liver_dun";
                        }
                    }
                }
                switch (horse.getPhenotype("flaxen")) {
                    case 0: {
                        return "red_dun";
                    }
                    case 1: {
                        return "partly_flaxen_dun";
                    }
                    case 2: {
                        return "flaxen_dun";
                    }
                }
            }
            String base = "";
            switch (horse.getMaxAllele("agouti")) {
                case 0: {
                    base = "grullo";
                }
                case 1: 
                case 2: {
                    base = "brown_dun";
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    base = "dun";
                }
            }
            if (horse.hasAllele("silver", 1)) {
                return "silver_" + base;
            }
            return base;
        }
        if (horse.isChestnut()) {
            String result = "chestnut";
            if (horse.getMaxAllele("liver") == 0) {
                result = "liver_" + result;
            }
            switch (horse.getPhenotype("flaxen")) {
                case 1: {
                    result = "partly_flaxen_" + result;
                    break;
                }
                case 2: {
                    result = "flaxen_" + result;
                }
            }
            return result;
        }
        if (horse.hasAllele("silver", 1)) {
            switch (horse.getMaxAllele("agouti")) {
                case 0: {
                    return "chocolate";
                }
                case 1: 
                case 2: {
                    return "silver_brown";
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return "silver_bay";
                }
            }
        }
        switch (horse.getMaxAllele("agouti")) {
            case 0: {
                return "black";
            }
            case 1: 
            case 2: {
                return "seal_brown";
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return "bay";
            }
        }
        System.out.println("[horse_colors]: Texture not found for horse with variant " + horse.getHorseVariant("0") + ".");
        return "no texture found";
    }

    public static String getSooty(EntityHorseFelinoid horse) {
        boolean is_chestnut;
        if (horse.isHomozygous("cream", 3)) {
            return null;
        }
        int sooty_level = 0;
        boolean is_gray = horse.getPhenotype("gray") != 0;
        sooty_level = !is_gray ? horse.getPhenotype("sooty") : horse.getPhenotype("slow_gray");
        if (sooty_level == 0) {
            return null;
        }
        boolean is_dun = horse.getPhenotype("dun") == 3 && horse.getPhenotype("gray") == 0;
        String suffix = "";
        if (is_dun) {
            if (sooty_level == 0) {
                return "sooty_dun";
            }
            --sooty_level;
            suffix = "_dun";
        }
        if (sooty_level == 3) {
            suffix = suffix + "_dark";
        } else if (sooty_level == 1) {
            suffix = suffix + "_light";
        }
        if (is_gray) {
            int random = horse.getHorseVariant("random") << 1 >>> 1;
            return (random % 4 == 1 ? "sooty_dappled" : "gray") + suffix;
        }
        String type = "countershaded";
        boolean bl = is_chestnut = horse.isChestnut() && !horse.hasAllele("cream", 3) && horse.getPhenotype("liver") != 0;
        if (horse.getPhenotype("dapple") == 1) {
            type = is_chestnut ? "even" : "dappled";
        }
        String prefix = is_gray ? "gray" : "sooty_" + type;
        return prefix + suffix;
    }

    public static String getMealy(EntityHorseFelinoid horse) {
        return null;
    }

    public static String getLegs(EntityHorseFelinoid horse) {
        if (horse.getPhenotype("gray") != 0 && horse.getPhenotype("slow_gray") > 1) {
            int random = horse.getHorseVariant("random") << 1 >>> 1;
            if (random % 4 == 0) {
                return "bay_legs";
            }
            return null;
        }
        if (horse.isChestnut() && horse.getPhenotype("dun") == 0 || horse.getPhenotype("gray") != 0) {
            return null;
        }
        String legs = null;
        if (!horse.isChestnut() && (horse.getMaxAllele("agouti") >= 2 || horse.hasAllele("dun", 3) || horse.hasAllele("dun", 2))) {
            legs = horse.isHomozygous("cream", 3) ? "perlino_legs" : (horse.hasAllele("silver", 1) ? "silver_legs" : "bay_legs");
        }
        return legs;
    }

    public static String getGrayMane(EntityHorseFelinoid horse) {
        if (!horse.isHomozygous("gray", 1) || horse.getPhenotype("gray_mane") == 2) {
            // empty if block
        }
        if (horse.getPhenotype("gray") != 1) {
            return null;
        }
        if (horse.isHomozygous("cream", 3)) {
            return null;
        }
        int gray = horse.getPhenotype("slow_gray");
        int mane = horse.getPhenotype("gray_mane");
        if (mane == 2 && gray > 1) {
            return "black_mane";
        }
        if (mane == 0) {
            return null;
        }
        return "gray_mane";
    }

    public static String getFaceMarking(EntityHorseFelinoid horse) {
        if (horse.getPhenotype("white_suppression") != 0) {
            return null;
        }
        if (horse.getPhenotype("draft_sabino") != 0 || horse.getPhenotype("W20") == 2) {
            return "blaze";
        }
        int face_marking = 0;
        int random = horse.getHorseVariant("random") << 1 >>> 3;
        if (horse.getPhenotype("tobiano") == 2) {
            if (random % 2 == 0) {
                ++face_marking;
            } else if ((random >> 1) % 2 == 0) {
                face_marking += 2 + (random >> 2) % 2;
            }
            random >>= 3;
        } else if (horse.getPhenotype("tobiano") != 0) {
            if (random % 4 == 0) {
                face_marking += 1 + (random >> 2) % 2;
            }
            random >>= 3;
        }
        if (horse.getPhenotype("flashy_white") != 0) {
            face_marking = random % 2 == 0 ? (face_marking += 3) : (face_marking += 1 + (random >> 1) % 2);
            random >>= 2;
        }
        assert (horse.getPhenotype("W20") != 2);
        if (horse.getPhenotype("W20") == 1) {
            if (random % 2 == 0) {
                face_marking += 2;
            } else if ((random >> 1) % 2 == 0) {
                ++face_marking;
            } else if ((random >> 2) % 2 == 0) {
                face_marking += 3;
            }
            random >>= 3;
        }
        if (horse.getPhenotype("markings") != 0) {
            face_marking = random % 2 == 0 ? (face_marking += 2) : (face_marking += 1 + 2 * ((random >> 1) % 2));
            random >>= 2;
        }
        if (horse.getPhenotype("half-socks") != 0) {
            face_marking += random % 8 == 0 ? 1 : 0;
            random >>= 3;
        }
        if (horse.getPhenotype("strip") != 0) {
            if (random % 2 == 0) {
                face_marking += 2;
            } else if ((random >> 1) % 2 == 0) {
                ++face_marking;
            } else if ((random >> 2) % 2 == 0) {
                face_marking += 3;
            }
            random >>= 3;
        } else if (horse.getPhenotype("star") != 0) {
            if (random % 2 == 0) {
                ++face_marking;
            } else if ((random >> 1) % 2 == 0) {
                face_marking += 2;
            }
            random >>= 2;
        }
        if (horse.getPhenotype("white_boost") != 0) {
            face_marking += random % 2;
            random >>= 1;
        }
        switch (face_marking) {
            case 0: {
                return null;
            }
            case 1: {
                return "star";
            }
            case 2: {
                return "strip";
            }
            case 3: {
                return "blaze";
            }
        }
        return "blaze";
    }

    public static String[] getLegMarkings(EntityHorseFelinoid horse) {
        return new String[4];
    }

    public static String getPinto(EntityHorseFelinoid horse) {
        if (horse.getPhenotype("white") == 1) {
            return "white";
        }
        String pinto = null;
        int tobiano = horse.getPhenotype("tobiano");
        int sabino = horse.getPhenotype("sabino1");
        int splash = horse.getPhenotype("splash");
        int frame = horse.getPhenotype("frame");
        if (tobiano != 0) {
            pinto = frame == 1 ? (splash == 2 ? "medicine_hat" : "war_shield") : "tobiano";
        } else if (frame == 1) {
            pinto = "frame";
        } else if (splash == 2) {
            pinto = "splash";
        } else if (sabino == 1) {
            pinto = "sabino";
        } else if (horse.getPhenotype("W20") == 2 || horse.getPhenotype("draft_sabino") != 0) {
            pinto = "stockings";
        }
        return pinto;
    }

    public static String getLeopard(EntityHorseFelinoid horse) {
        if (horse.getPhenotype("leopard") == 0) {
            return null;
        }
        int patn = horse.getPhenotype("PATN");
        if (patn == 0) {
            return "varnish_roan";
        }
        if (horse.getPhenotype("leopard") == 1) {
            return "leopard";
        }
        return "fewspot";
    }
}

