/*
 * Decompiled with CFR 0.152.
 */
package felinoid.horse_colors;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class HorseConfig {
    private static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, commonSpec);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue useGeneticStats;
        public static ForgeConfigSpec.BooleanValue horseDebugInfo;
        public static ForgeConfigSpec.BooleanValue blockVanillaHorseSpawns;
        public static ForgeConfigSpec.BooleanValue convertVanillaHorses;
        public static ForgeConfigSpec.IntValue minHerdSize;
        public static ForgeConfigSpec.IntValue maxHerdSize;
        public static ForgeConfigSpec.IntValue spawnWeight;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            this.useGeneticStats = builder.comment(new String[]{"If enabled, horses' speed, jump, and health will be determined", "through genetics instead of the default Minecraft way"}).translation("horse_colors.config.common.useGeneticStats").define("useGeneticStats", false);
            horseDebugInfo = builder.comment(new String[]{"If enabled, debugging information will appear on the screen when the", "player is holding a stick in their left hand and looks at a horse.", "For most users, it is probably better to leave this as false."}).translation("horse_colors.config.common.horseDebugInfo").define("horseDebugInfo", false);
            blockVanillaHorseSpawns = builder.comment(new String[]{"If set to true, only horses created by this mod will spawn.", "This mainly affects newly generated areas."}).translation("horse_colors.config.common.blockVanillaHorseSpawns").define("blockVanillaHorseSpawns", true);
            convertVanillaHorses = builder.comment(new String[]{"If enabled, each vanilla horse will be replaced by a horse", "from this mod.", "This matters for already generated areas, or if blockVanillaHorseSpawns is set to false."}).translation("horse_colors.config.common.convertVanillaHorses").define("convertVanillaHorses", true);
            minHerdSize = builder.comment("What size groups horses will spawn in").translation("horse_colors.config.common.minHerdSize").defineInRange("minHerdSize", 4, 0, Integer.MAX_VALUE);
            maxHerdSize = builder.comment("").translation("horse_colors.config.common.maxHerdSize").defineInRange("maxHerdSize", 8, 0, Integer.MAX_VALUE);
            spawnWeight = builder.comment("How often horses will spawn").translation("horse_colors.config.common.spawnWeight").defineInRange("spawnWeight", 10, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

