/*
 * Decompiled with CFR 0.152.
 */
package felinoid.horse_colors;

import felinoid.horse_colors.EntityHorseFelinoid;
import felinoid.horse_colors.HorseConfig;
import felinoid.horse_colors.RenderHorseFelinoid;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEntities {
    public static EntityType<EntityHorseFelinoid> HORSE_FELINOID = null;
    public static Item HORSE_SPAWN_EGG = null;
    public static final int horseEggPrimary = 8340256;
    public static final int horseEggSecondary = 1117709;

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityHorseFelinoid.class, renderManager -> new RenderHorseFelinoid(renderManager));
    }

    static {
        System.out.println("registering horse\n");
        ResourceLocation registryName = new ResourceLocation("horse_colors", "horse_felinoid");
        HORSE_FELINOID = EntityType.Builder.func_201757_a(EntityHorseFelinoid.class, EntityHorseFelinoid::new).func_206830_a(registryName.toString());
        HORSE_FELINOID.setRegistryName(registryName);
        System.out.println("registering horse egg\n");
        assert (HORSE_FELINOID != null);
        ItemSpawnEgg spawnEgg = new ItemSpawnEgg(HORSE_FELINOID, 8340256, 1117709, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        spawnEgg.setRegistryName(new ResourceLocation("horse_colors", "horse_felinoid_spawn_egg"));
        HORSE_SPAWN_EGG = spawnEgg;
    }

    @Mod.EventBusSubscriber(modid="horse_colors", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{HORSE_FELINOID});
        }

        @SubscribeEvent
        public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
            event.getRegistry().register((IForgeRegistryEntry)HORSE_SPAWN_EGG);
        }

        public static void addSpawns() {
            assert (HORSE_FELINOID != null);
            RegistrationHandler.addSpawn(HORSE_FELINOID, (Integer)HorseConfig.Common.spawnWeight.get(), (Integer)HorseConfig.Common.minHerdSize.get(), (Integer)HorseConfig.Common.maxHerdSize.get(), EnumCreatureType.CREATURE, RegistrationHandler.getBiomes(BiomeDictionary.Type.PLAINS));
            RegistrationHandler.addSpawn(HORSE_FELINOID, (Integer)HorseConfig.Common.spawnWeight.get(), (Integer)HorseConfig.Common.minHerdSize.get(), (Integer)HorseConfig.Common.maxHerdSize.get(), EnumCreatureType.CREATURE, RegistrationHandler.getBiomes(BiomeDictionary.Type.SAVANNA));
        }

        private static void addSpawn(EntityType<? extends EntityLiving> entityType, int itemWeight, int minGroupCount, int maxGroupCount, EnumCreatureType classification, Biome ... biomes) {
            for (Biome biome : biomes) {
                List spawns = biome.func_76747_a(classification);
                spawns.stream().filter(entry -> entry.field_200702_b == entityType).findFirst().ifPresent(spawns::remove);
                spawns.add(new Biome.SpawnListEntry(entityType, itemWeight, minGroupCount, maxGroupCount));
            }
        }

        private static Biome[] getBiomes(BiomeDictionary.Type type) {
            return BiomeDictionary.getBiomes((BiomeDictionary.Type)type).toArray(new Biome[0]);
        }
    }
}

