/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sekelsta.horse_colors.HorseConfig;
import sekelsta.horse_colors.HorseGeneticEntity;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="horse_colors", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HorseDebug {
    public static boolean showDebug(PlayerEntity player) {
        if (!((Boolean)HorseConfig.Common.horseDebugInfo.get()).booleanValue()) {
            return false;
        }
        ItemStack itemStack = player.func_184592_cb();
        return itemStack != null && itemStack.func_77973_b() == Items.field_151055_y;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderOverlayEvent(RenderGameOverlayEvent.Text event) {
        RayTraceResult mouseOver;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (HorseDebug.showDebug((PlayerEntity)player) && (mouseOver = Minecraft.func_71410_x().field_71476_x) != null && mouseOver instanceof EntityRayTraceResult && ((EntityRayTraceResult)mouseOver).func_216348_a() != null && ((EntityRayTraceResult)mouseOver).func_216348_a() instanceof HorseGeneticEntity) {
            HorseGeneticEntity horse = (HorseGeneticEntity)((EntityRayTraceResult)mouseOver).func_216348_a();
            for (String gene : HorseGeneticEntity.genes) {
                event.getRight().add(gene + ": " + horse.getPhenotype(gene) + " (" + horse.getAllele(gene, 1) + ", " + horse.getAllele(gene, 0) + ")");
            }
            event.getLeft().add("speed: " + horse.getStat("speed") + "-" + Integer.toBinaryString(horse.getHorseVariant("speed")));
            event.getLeft().add("health: " + horse.getStat("health") + "-" + Integer.toBinaryString(horse.getHorseVariant("health")));
            event.getLeft().add("jump: " + horse.getStat("jump") + "-" + Integer.toBinaryString(horse.getHorseVariant("jump")));
            event.getLeft().add("random: " + Integer.toHexString(horse.getHorseVariant("random")));
        }
    }
}

