/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import sekelsta.horse_colors.HorseColorCalculator;
import sekelsta.horse_colors.HorseConfig;
import sekelsta.horse_colors.ModEntities;

public class HorseGeneticEntity
extends AbstractHorseEntity {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> HORSE_VARIANT = EntityDataManager.func_187226_a(HorseGeneticEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HORSE_VARIANT2 = EntityDataManager.func_187226_a(HorseGeneticEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HORSE_VARIANT3 = EntityDataManager.func_187226_a(HorseGeneticEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HORSE_SPEED = EntityDataManager.func_187226_a(HorseGeneticEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HORSE_JUMP = EntityDataManager.func_187226_a(HorseGeneticEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HORSE_HEALTH = EntityDataManager.func_187226_a(HorseGeneticEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HORSE_RANDOM = EntityDataManager.func_187226_a(HorseGeneticEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final String[] genes = new String[]{"extension", "agouti", "dun", "gray", "cream", "silver", "liver", "flaxen1", "flaxen2", "dapple", "sooty1", "sooty2", "sooty3", "mealy1", "mealy2", "mealy3", "white_suppression", "KIT", "frame", "MITF", "PAX3", "leopard", "PATN1", "PATN2", "PATN3", "gray_suppression", "gray_mane", "slow_gray1", "slow_gray2"};
    private String texturePrefix;
    private final String[] horseTexturesArray = new String[15];

    public HorseGeneticEntity(EntityType<? extends HorseGeneticEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public void copyAbstractHorse(AbstractHorseEntity horse) {
        this.func_70012_b(horse.field_70165_t, horse.field_70163_u, horse.field_70161_v, horse.field_70177_z, horse.field_70125_A);
        this.field_70759_as = this.field_70177_z;
        this.field_70761_aq = this.field_70177_z;
        this.func_110234_j(horse.func_110248_bS());
        this.func_110238_s(horse.func_110252_cg());
        this.func_70873_a(horse.func_70874_b());
        Inventory inv = (Inventory)ObfuscationReflectionHelper.getPrivateValue(AbstractHorseEntity.class, (Object)horse, (String)"field_110296_bG");
        this.field_110296_bG.func_70299_a(0, inv.func_70301_a(0));
        this.field_110296_bG.func_70299_a(1, inv.func_70301_a(1));
        this.func_110232_cE();
        double health = horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(health);
        double jump = horse.func_110148_a(field_110271_bv).func_111125_b();
        this.func_110148_a(field_110271_bv).func_111128_a(jump);
        double speed = horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed);
        if (horse.func_145818_k_()) {
            this.func_200203_b(horse.func_200201_e());
            this.func_174805_g(horse.func_174833_aM());
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorseEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0, AbstractHorseEntity.class));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.func_205714_dM();
    }

    protected void func_205714_dM() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HORSE_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_VARIANT2, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_VARIANT3, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_SPEED, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_HEALTH, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_JUMP, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_RANDOM, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getHorseVariant("0"));
        compound.func_74768_a("Variant2", this.getHorseVariant("1"));
        compound.func_74768_a("Variant3", this.getHorseVariant("2"));
        compound.func_74768_a("SpeedGenes", this.getHorseVariant("speed"));
        compound.func_74768_a("JumpGenes", this.getHorseVariant("jump"));
        compound.func_74768_a("HealthGenes", this.getHorseVariant("health"));
        compound.func_74768_a("Random", this.getHorseVariant("random"));
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compound.func_218657_a("ArmorItem", (INBT)this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    private void setArmor(ItemStack itemStackIn) {
        this.func_184201_a(EquipmentSlotType.CHEST, itemStackIn);
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    public void func_70037_a(CompoundNBT compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        this.setHorseVariant(compound.func_74762_e("Variant"), "0");
        this.setHorseVariant(compound.func_74762_e("Variant2"), "1");
        this.setHorseVariant(compound.func_74762_e("Variant3"), "2");
        this.setHorseVariant(compound.func_74762_e("SpeedGenes"), "speed");
        this.setHorseVariant(compound.func_74762_e("JumpGenes"), "jump");
        this.setHorseVariant(compound.func_74762_e("HealthGenes"), "health");
        this.setHorseVariant(compound.func_74762_e("Random"), "random");
        if (compound.func_150297_b("ArmorItem", 10) && !(itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(itemstack)) {
            this.field_110296_bG.func_70299_a(1, itemstack);
        }
        this.func_110232_cE();
    }

    public void setHorseVariant(int variant, String type) {
        switch (type) {
            case "0": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT, (Object)variant);
                break;
            }
            case "1": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT2, (Object)variant);
                break;
            }
            case "2": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT3, (Object)variant);
                break;
            }
            case "speed": {
                this.field_70180_af.func_187227_b(HORSE_SPEED, (Object)variant);
                return;
            }
            case "jump": {
                this.field_70180_af.func_187227_b(HORSE_JUMP, (Object)variant);
                return;
            }
            case "health": {
                this.field_70180_af.func_187227_b(HORSE_HEALTH, (Object)variant);
                return;
            }
            case "random": {
                this.field_70180_af.func_187227_b(HORSE_RANDOM, (Object)variant);
                break;
            }
            default: {
                System.out.print("Unrecognized horse data for setting: " + type + "\n");
            }
        }
        this.resetTexturePrefix();
    }

    public int getHorseVariant(String type) {
        switch (type) {
            case "0": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT);
            }
            case "1": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT2);
            }
            case "2": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT3);
            }
            case "speed": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_SPEED);
            }
            case "jump": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_JUMP);
            }
            case "health": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_HEALTH);
            }
            case "random": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_RANDOM);
            }
        }
        System.out.print("Unrecognized horse data for getting: " + type + "\n");
        return 0;
    }

    public static void test() {
        System.out.println("");
        for (String gene : genes) {
            System.out.print(gene + ": " + HorseGeneticEntity.getGenePos(gene) + "\n");
        }
    }

    public static int getGenePos(String name) {
        int i = 0;
        for (String gene : genes) {
            int next = i + 2 * HorseGeneticEntity.getGeneSize(gene);
            if (next / 32 != i / 32 && next % 32 != 0) {
                i = (i / 32 + 1) * 32;
            }
            if (gene == name) {
                return i;
            }
            i += 2 * HorseGeneticEntity.getGeneSize(gene);
        }
        System.out.println("Gene not recognized: " + name);
        return -1;
    }

    public static int getGeneSize(String gene) {
        switch (gene) {
            case "KIT": {
                return 4;
            }
            case "extension": 
            case "agouti": {
                return 3;
            }
            case "MITF": 
            case "PAX3": 
            case "cream": 
            case "dun": {
                return 2;
            }
            case "gray": 
            case "silver": 
            case "liver": 
            case "flaxen1": 
            case "flaxen2": 
            case "dapple": 
            case "sooty1": 
            case "sooty2": 
            case "sooty3": 
            case "mealy1": 
            case "mealy2": 
            case "mealy3": 
            case "white_suppression": 
            case "frame": 
            case "leopard": 
            case "PATN1": 
            case "PATN2": 
            case "PATN3": 
            case "gray_suppression": 
            case "gray_mane": 
            case "slow_gray1": 
            case "slow_gray2": {
                return 1;
            }
        }
        System.out.println("Gene size not found: " + gene);
        return -1;
    }

    public static int getGeneLoci(String gene) {
        return (1 << 2 * HorseGeneticEntity.getGeneSize(gene)) - 1 << HorseGeneticEntity.getGenePos(gene) % 32;
    }

    public static String getGeneChromosome(String gene) {
        return Integer.toString(HorseGeneticEntity.getGenePos(gene) / 32);
    }

    public void setGene(String name, int val) {
        String chr = HorseGeneticEntity.getGeneChromosome(name);
        this.setHorseVariant(this.getHorseVariant(chr) & ~HorseGeneticEntity.getGeneLoci(name) | val << HorseGeneticEntity.getGenePos(name) % 32, chr);
    }

    public int getGene(String name) {
        String chr = HorseGeneticEntity.getGeneChromosome(name);
        return (this.getHorseVariant(chr) & HorseGeneticEntity.getGeneLoci(name)) >>> HorseGeneticEntity.getGenePos(name);
    }

    public int getAllele(String name, int n) {
        int gene = this.getGene(name);
        gene >>= n * HorseGeneticEntity.getGeneSize(name);
        return gene %= 1 << HorseGeneticEntity.getGeneSize(name);
    }

    public int getStat(String name) {
        int val = this.getHorseVariant(name);
        int count = 0;
        for (int i = 0; i < 32; ++i) {
            count += (val % 2 + 2) % 2;
            val >>= 1;
        }
        return count;
    }

    public boolean hasAllele(String name, int allele) {
        return this.getAllele(name, 0) == allele || this.getAllele(name, 1) == allele;
    }

    public int getMaxAllele(String name) {
        return Math.max(this.getAllele(name, 0), this.getAllele(name, 1));
    }

    public boolean isHomozygous(String name, int allele) {
        return this.getAllele(name, 0) == allele && this.getAllele(name, 1) == allele;
    }

    public boolean isChestnut() {
        int e = this.getMaxAllele("extension");
        return e == 0 || e == 1 || e == 2 || e == 3;
    }

    public int getPhenotype(String name) {
        switch (name) {
            case "silver": 
            case "liver": 
            case "flaxen1": 
            case "flaxen2": 
            case "dapple": 
            case "sooty1": 
            case "sooty2": 
            case "sooty3": 
            case "mealy1": 
            case "mealy2": 
            case "mealy3": 
            case "white_suppression": 
            case "PATN2": 
            case "PATN3": 
            case "gray_suppression": 
            case "slow_gray1": {
                return this.getMaxAllele(name);
            }
            case "leopard": {
                return 0;
            }
            case "gray": 
            case "cream": 
            case "frame": 
            case "PATN1": 
            case "gray_mane": 
            case "slow_gray2": {
                return (this.getGene(name) & 1) + (this.getGene(name) >> 1);
            }
            case "flaxen": {
                return 2 - this.getPhenotype("flaxen1") - this.getPhenotype("flaxen2");
            }
            case "sooty": {
                return 1 + this.getPhenotype("sooty1") + this.getPhenotype("sooty2") - this.getPhenotype("sooty3");
            }
            case "mealy": {
                return 2 - this.getPhenotype("mealy1") - this.getPhenotype("mealy2");
            }
            case "splash": {
                return this.isHomozygous("MITF", 0) ? 2 : (this.hasAllele("MITF", 0) ? 1 : 0);
            }
            case "extension": {
                return Math.max(this.getAllele(name, 0), this.getAllele(name, 1));
            }
            case "agouti": {
                if (this.getGene("agouti") == 1 || this.getGene("agouti") == 4) {
                    return 1;
                }
                int allele = Math.max(this.getGene("agouti") & 3, this.getGene("agouti") >> 2);
                return allele == 0 ? 0 : allele + 1;
            }
            case "dun": {
                if (this.getGene(name) <= 1) {
                    return this.getGene(name);
                }
                if (this.getGene(name) == 4) {
                    return 1;
                }
                if (this.getGene(name) == 5) {
                    return 2;
                }
                return 3;
            }
            case "KIT": {
                return -1;
            }
            case "white_boost": {
                return (this.getGene("KIT") & 0xF) == 2 || this.getGene("KIT") >> 4 == 2 ? 1 : 0;
            }
            case "star": {
                return (this.getGene("KIT") & 0xF) == 3 || this.getGene("KIT") >> 4 == 3 ? 1 : 0;
            }
            case "strip": {
                return (this.getGene("KIT") & 0xF) == 4 || this.getGene("KIT") >> 4 == 4 ? 1 : 0;
            }
            case "half-socks": {
                return (this.getGene("KIT") & 0xF) == 5 || this.getGene("KIT") >> 4 == 5 ? 1 : 0;
            }
            case "markings": {
                return (this.getGene("KIT") & 0xF) == 6 || this.getGene("KIT") >> 4 == 6 ? 1 : 0;
            }
            case "W20": {
                boolean w2;
                boolean w1 = this.getAllele("KIT", 0) == 13 || this.getAllele("KIT", 0) == 7;
                boolean bl = w2 = this.getAllele("KIT", 1) == 13 || this.getAllele("KIT", 1) == 7;
                if (w1 && w2) {
                    return 2;
                }
                return w1 || w2 ? 1 : 0;
            }
            case "flashy_white": {
                return (this.getGene("KIT") & 0xF) == 8 || this.getGene("KIT") >> 4 == 8 ? 1 : 0;
            }
            case "draft_sabino": {
                return (this.getGene("KIT") & 0xF) == 9 || this.getGene("KIT") >> 4 == 9 ? 1 : 0;
            }
            case "sabino1": {
                if (this.getGene("KIT") == 204) {
                    return 2;
                }
                return (this.getGene("KIT") & 0xF) == 12 || this.getGene("KIT") >> 4 == 12 ? 1 : 0;
            }
            case "tobiano": {
                boolean tob2;
                boolean tob1 = this.getAllele("KIT", 0) == 13 || this.getAllele("KIT", 0) == 11;
                boolean bl = tob2 = this.getAllele("KIT", 1) == 13 || this.getAllele("KIT", 1) == 11;
                if (tob1 && tob2) {
                    return 2;
                }
                return tob1 || tob2 ? 1 : 0;
            }
            case "roan": {
                return (this.getGene("KIT") & 0xF) == 14 || this.getGene("KIT") >> 4 == 14 ? 1 : 0;
            }
            case "dominant_white": {
                if (this.getGene("KIT") == 255) {
                    return 2;
                }
                return (this.getGene("KIT") & 0xF) == 15 || this.getGene("KIT") >> 4 == 15 ? 1 : 0;
            }
            case "white": {
                return this.getPhenotype("dominant_white") != 0 || this.getPhenotype("frame") == 2 || this.getPhenotype("sabino1") == 2 || this.getPhenotype("sabino1") != 0 && this.getPhenotype("frame") != 0 && this.getPhenotype("tobiano") != 0 ? 1 : 0;
            }
            case "PATN": {
                int base = 5 * this.getPhenotype("PATN1") + this.getPhenotype("PATN2") + this.getPhenotype("PATN3");
                return base == 0 ? 0 : base + this.getPhenotype("W20") + this.getPhenotype("white_boost");
            }
            case "slow_gray": {
                int val = this.getPhenotype("slow_gray1") + this.getPhenotype("slow_gray2") + (this.getPhenotype("gray") == 2 ? -2 : 0) + (this.getPhenotype("gray_mane") == 0 ? 0 : 1);
                return Math.min(Math.max(val, 0), 3);
            }
            case "MITF": {
                return -1;
            }
            case "PAX3": {
                return -1;
            }
        }
        System.out.println("[horse_colors]: Phenotype for " + name + " not found.");
        return -1;
    }

    private void resetTexturePrefix() {
        this.texturePrefix = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String fixPath(String folder, String inStr) {
        if (inStr == null || inStr.contains(".png")) {
            return inStr;
        }
        if (inStr == "") {
            return null;
        }
        return "horse_colors:textures/entity/horse/" + folder + "/" + inStr + ".png";
    }

    public boolean showsLegMarkings() {
        return this.getPhenotype("tobiano") == 0 && this.getPhenotype("splash") != 2 && this.getPhenotype("white") == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setHorseTexturePaths() {
        String base_texture = HorseColorCalculator.getBaseTexture(this);
        String roan = this.hasAllele("KIT", 14) ? "roan" : null;
        String face_marking = HorseColorCalculator.getFaceMarking(this);
        String sooty = HorseColorCalculator.getSooty(this);
        String leopard = HorseColorCalculator.getLeopard(this);
        leopard = null;
        String mealy = HorseColorCalculator.getMealy(this);
        String legs = HorseColorCalculator.getLegs(this);
        String gray_mane = HorseColorCalculator.getGrayMane(this);
        String[] leg_markings = new String[4];
        String pinto = HorseColorCalculator.getPinto(this);
        if (this.showsLegMarkings()) {
            leg_markings = HorseColorCalculator.getLegMarkings(this);
        }
        this.horseTexturesArray[0] = HorseGeneticEntity.fixPath("base", base_texture);
        this.horseTexturesArray[1] = HorseGeneticEntity.fixPath("sooty", sooty);
        this.horseTexturesArray[2] = HorseGeneticEntity.fixPath("mealy", mealy);
        this.horseTexturesArray[3] = HorseGeneticEntity.fixPath("legs", legs);
        this.horseTexturesArray[4] = HorseGeneticEntity.fixPath("roan", roan);
        this.horseTexturesArray[6] = HorseGeneticEntity.fixPath("roan", gray_mane);
        this.horseTexturesArray[7] = HorseGeneticEntity.fixPath("pinto", face_marking);
        this.horseTexturesArray[8] = HorseGeneticEntity.fixPath("pinto", leg_markings[0]);
        this.horseTexturesArray[9] = HorseGeneticEntity.fixPath("pinto", leg_markings[1]);
        this.horseTexturesArray[10] = HorseGeneticEntity.fixPath("pinto", leg_markings[2]);
        this.horseTexturesArray[11] = HorseGeneticEntity.fixPath("pinto", leg_markings[3]);
        this.horseTexturesArray[12] = HorseGeneticEntity.fixPath("leopard", leopard);
        this.horseTexturesArray[13] = HorseGeneticEntity.fixPath("pinto", pinto);
        String base_abv = base_texture == null ? "" : base_texture;
        String sooty_abv = sooty == null ? "" : sooty;
        String mealy_abv = mealy == null ? "" : mealy;
        String legs_abv = legs == null ? "" : legs;
        String roan_abv = roan == null ? "" : roan;
        String gray_mane_abv = gray_mane == null ? "" : gray_mane;
        String face_marking_abv = face_marking == null ? "" : face_marking;
        String leg_marking_abv = (leg_markings[0] == null ? "-" : leg_markings[0]) + (leg_markings[1] == null ? "-" : leg_markings[1]) + (leg_markings[2] == null ? "-" : leg_markings[2]) + (leg_markings[3] == null ? "-" : leg_markings[3]);
        String pinto_abv = pinto == null ? "" : pinto;
        String leopard_abv = leopard == null ? "" : leopard;
        this.texturePrefix = "horse/cache_" + base_abv + sooty_abv + mealy_abv + roan_abv + gray_mane_abv + face_marking_abv + leg_marking_abv + leopard_abv + pinto_abv;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getHorseTexture() {
        if (this.texturePrefix == null) {
            this.setHorseTexturePaths();
        }
        return this.texturePrefix;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String[] getVariantTexturePaths() {
        if (this.texturePrefix == null) {
            this.setHorseTexturePaths();
        }
        return this.horseTexturesArray;
    }

    protected void func_110232_cE() {
        super.func_110232_cE();
        this.setHorseArmorStack(this.field_110296_bG.func_70301_a(1));
    }

    public void setHorseArmorStack(ItemStack itemStackIn) {
        this.setArmor(itemStackIn);
        if (!this.field_70170_p.field_72995_K) {
            int i;
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(ARMOR_MODIFIER_UUID);
            if (this.func_190682_f(itemStackIn) && (i = ((HorseArmorItem)itemStackIn.func_77973_b()).func_219977_e()) != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION).func_111168_a(false));
            }
        }
    }

    public ItemStack getHorseArmor() {
        return this.func_184582_a(EquipmentSlotType.CHEST);
    }

    public void func_76316_a(IInventory invBasic) {
        ItemStack itemstack = this.getHorseArmor();
        super.func_76316_a(invBasic);
        ItemStack itemstack1 = this.getHorseArmor();
        if (this.field_70173_aa > 20 && this.func_190682_f(itemstack1) && itemstack != itemstack1) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
    }

    protected void func_190680_a(SoundType p_190680_1_) {
        super.func_190680_a(p_190680_1_);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, p_190680_1_.func_185843_a() * 0.6f, p_190680_1_.func_185847_b());
        }
    }

    private void useGeneticAttributes() {
        if (((Boolean)HorseConfig.COMMON.useGeneticStats.get()).booleanValue()) {
            float maxHealth = 15.0f + (float)this.getStat("health") * 0.5f;
            double movementSpeed = 0.1125 + (double)this.getStat("speed") * 0.00703125;
            double jumpStrength = 0.4 + (double)this.getStat("jump") * 0.01875;
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(movementSpeed);
            this.func_110148_a(field_110271_bv).func_111128_a(jumpStrength);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.func_110267_cL());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110203_cN());
        this.func_110148_a(field_110271_bv).func_111128_a(this.func_110245_cM());
    }

    public void func_70071_h_() {
        ItemStack armor;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.resetTexturePrefix();
        }
        if (this.func_190682_f(armor = this.field_110296_bG.func_70301_a(1))) {
            armor.onHorseArmorTick(this.field_70170_p, (MobEntity)this);
        }
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
        if (this.getPhenotype("frame") == 2 && this.field_70173_aa > 80) {
            if (!this.func_70644_a(Effects.field_76436_u)) {
                this.func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 3));
            }
            if (this.func_110143_aJ() < 2.0f) {
                this.func_195064_c(new EffectInstance(Effects.field_76433_i, 1, 3));
            }
        }
    }

    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187717_cr;
    }

    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean notEmpty;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = notEmpty = !itemstack.func_190926_b();
        if (notEmpty && itemstack.func_77973_b() instanceof SpawnEggItem) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && player.func_70093_af()) {
                this.func_110199_f(player);
                return true;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(player, hand);
            }
        }
        if (notEmpty) {
            boolean saddle;
            if (this.func_190678_b(player, itemstack)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack.func_111282_a(player, (LivingEntity)this, hand)) {
                return true;
            }
            if (!this.func_110248_bS()) {
                this.func_190687_dF();
                return true;
            }
            boolean bl2 = saddle = !this.func_70631_g_() && !this.func_110257_ck() && itemstack.func_77973_b() == Items.field_151141_av;
            if (this.func_190682_f(itemstack) || saddle) {
                this.func_110199_f(player);
                return true;
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(player, hand);
        }
        this.func_110237_h(player);
        return true;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof HorseGeneticEntity) {
            return this.func_110200_cJ() && ((HorseGeneticEntity)otherAnimal).func_110200_cJ();
        }
        if (otherAnimal instanceof DonkeyEntity) {
            AbstractHorseEntity other = (AbstractHorseEntity)otherAnimal;
            boolean otherCanMate = !other.func_184207_aI() && !other.func_184218_aH() && other.func_110248_bS() && !other.func_70631_g_() && other.func_110143_aJ() >= other.func_110138_aP() && other.func_70880_s();
            return this.func_110200_cJ() && otherCanMate;
        }
        return false;
    }

    private int getRandomGenes(int n, int type) {
        int result = 0;
        int random = 0;
        String out = "";
        for (String gene : genes) {
            if (HorseGeneticEntity.getGenePos(gene) / 32 != type) continue;
            random = this.field_70146_Z.nextInt();
            int next = this.getGene(gene);
            next = random % 2 == 0 ? (next >>= HorseGeneticEntity.getGeneSize(gene)) : (next &= (1 << HorseGeneticEntity.getGeneSize(gene)) - 1);
            out = out + gene + ": " + this.getGene(gene) + " -> " + next + "\n";
            random >>= 1;
            result |= next << HorseGeneticEntity.getGenePos(gene) % 32 << n * HorseGeneticEntity.getGeneSize(gene);
        }
        return result;
    }

    private int getRandomGenericGenes(int n, int data) {
        int rand = this.field_70146_Z.nextInt();
        int answer = 0;
        for (int i = 0; i < 16; ++i) {
            answer = rand % 2 == 0 ? (answer += (data & 1 << 2 * i) << n) : (answer += (data & 1 << 2 * i + 1) >> 1 - n);
            rand >>= 1;
        }
        return answer;
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        AbstractHorseEntity abstracthorse;
        if (ageable instanceof DonkeyEntity) {
            abstracthorse = (AbstractHorseEntity)EntityType.field_200779_S.func_200721_a(this.field_70170_p);
        } else {
            HorseGeneticEntity entityhorse = (HorseGeneticEntity)ageable;
            abstracthorse = (AbstractHorseEntity)ModEntities.HORSE_GENETIC.func_200721_a(this.field_70170_p);
            int mother = this.getRandomGenes(1, 0);
            int father = entityhorse.getRandomGenes(0, 0);
            int i = mother | father;
            ((HorseGeneticEntity)abstracthorse).setHorseVariant(i, "0");
            mother = this.getRandomGenes(1, 1);
            father = entityhorse.getRandomGenes(0, 1);
            i = mother | father;
            ((HorseGeneticEntity)abstracthorse).setHorseVariant(i, "1");
            ((HorseGeneticEntity)abstracthorse).setHorseVariant(this.field_70146_Z.nextInt(), "2");
            mother = this.getRandomGenes(1, 2);
            father = entityhorse.getRandomGenes(0, 2);
            i = mother | father;
            ((HorseGeneticEntity)abstracthorse).setHorseVariant(i, "2");
            mother = this.getRandomGenericGenes(1, this.getHorseVariant("speed"));
            father = entityhorse.getRandomGenericGenes(0, entityhorse.getHorseVariant("speed"));
            i = mother | father;
            ((HorseGeneticEntity)abstracthorse).setHorseVariant(i, "speed");
            mother = this.getRandomGenericGenes(1, this.getHorseVariant("health"));
            father = entityhorse.getRandomGenericGenes(0, entityhorse.getHorseVariant("health"));
            i = mother | father;
            ((HorseGeneticEntity)abstracthorse).setHorseVariant(i, "health");
            mother = this.getRandomGenericGenes(1, this.getHorseVariant("jump"));
            father = entityhorse.getRandomGenericGenes(0, entityhorse.getHorseVariant("jump"));
            i = mother | father;
            ((HorseGeneticEntity)abstracthorse).setHorseVariant(i, "jump");
            i = this.field_70146_Z.nextInt();
            ((HorseGeneticEntity)abstracthorse).setHorseVariant(i, "random");
            if (((HorseGeneticEntity)abstracthorse).getPhenotype("dominant_white") == 2) {
                return null;
            }
        }
        this.func_190681_a(ageable, abstracthorse);
        if (abstracthorse instanceof HorseGeneticEntity) {
            ((HorseGeneticEntity)abstracthorse).useGeneticAttributes();
        }
        return abstracthorse;
    }

    public boolean func_190677_dK() {
        return true;
    }

    public boolean func_190682_f(ItemStack stack) {
        return stack.func_77973_b() instanceof HorseArmorItem;
    }

    private void setGeneRandom(String name, int n, int odds, int common) {
        int i = this.field_70146_Z.nextInt();
        int rare = common == 0 ? 1 : 0;
        this.setGene(name, (i % odds == 0 ? rare : common) << n * HorseGeneticEntity.getGeneSize(name));
    }

    private int getRandomVariant(int n, String type) {
        int answer = 0;
        int startVariant = this.getHorseVariant(type);
        if (type == "0") {
            int i = this.field_70146_Z.nextInt() >>> 1;
            this.setGene("extension", (i & 7) << n * HorseGeneticEntity.getGeneSize("extension"));
            this.setGeneRandom("gray", n, 20, 0);
            int dun = (this.field_70146_Z.nextInt() % 7 == 0 ? 2 : 0) + ((i >>= 3) % 4 == 0 ? 1 : 0);
            this.setGene("dun", dun << n * HorseGeneticEntity.getGeneSize("dun"));
            int ag = (i >>= 2) % 16;
            int agouti = ag == 0 ? 7 : (ag == 1 ? 6 : (ag < 4 ? 5 : (ag < 6 ? 4 : (ag < 8 ? 3 : (ag == 8 ? 2 : (ag == 9 ? 1 : 0))))));
            this.setGene("agouti", agouti << n * HorseGeneticEntity.getGeneSize("agouti"));
            this.setGeneRandom("silver", n, 32, 0);
            int cr = (i >>= 4) % 32;
            int cream = cr == 0 ? 3 : (cr == 1 ? 2 : (cr == 2 ? 1 : 0));
            this.setGene("cream", cream << n * HorseGeneticEntity.getGeneSize("cream"));
            this.setGeneRandom("liver", n, 3, 1);
            this.setGeneRandom("flaxen1", n, 5, 1);
            this.setGeneRandom("flaxen2", n, 5, 1);
            this.setGene("dapple", (i >>= 5) % 2 << n * HorseGeneticEntity.getGeneSize("dapple"));
            i >>= 1;
        } else if (type == "1") {
            int i = this.field_70146_Z.nextInt() >>> 1;
            this.setGeneRandom("sooty1", n, 4, 1);
            this.setGeneRandom("sooty2", n, 4, 1);
            this.setGeneRandom("sooty3", n, 2, 1);
            this.setGeneRandom("mealy1", n, 4, 1);
            this.setGeneRandom("mealy2", n, 4, 1);
            this.setGeneRandom("mealy3", n, 4, 1);
            this.setGeneRandom("white_suppression", n, 32, 0);
            int kit = i % 2 == 0 ? 0 : (i >> 2) % 16;
            this.setGene("KIT", kit << n * HorseGeneticEntity.getGeneSize("KIT"));
            this.setGeneRandom("frame", n, 32, 0);
            int mitf = (i >>= 7) % 4 == 0 ? 3 : ((i >> 2) % 2 == 0 ? (i >> 3) % 4 : 3);
            this.setGene("MITF", mitf << n * HorseGeneticEntity.getGeneSize("MITF"));
            this.setGene("PAX3", (i >>= 4) % 4 << n * HorseGeneticEntity.getGeneSize("PAX3"));
        } else if (type == "2") {
            this.setHorseVariant(this.field_70146_Z.nextInt(), "2");
            int i = this.field_70146_Z.nextInt();
            this.setGeneRandom("leopard", n, 32, 0);
            this.setGeneRandom("PATN1", n, 16, 0);
            this.setGeneRandom("PATN2", n, 16, 0);
            this.setGeneRandom("PATN3", n, 16, 0);
            this.setGeneRandom("gray_suppression", n, 40, 0);
            this.setGeneRandom("gray_mane", n, 4, 0);
            this.setGeneRandom("slow_gray1", n, 8, 0);
            this.setGeneRandom("slow_gray2", n, 4, 0);
        }
        answer = this.getHorseVariant(type);
        this.setHorseVariant(startVariant, type);
        return answer;
    }

    private void randomizeSingleVariant(String variant) {
        int i = this.getRandomVariant(0, variant);
        int j = this.getRandomVariant(1, variant);
        this.setHorseVariant(i | j, variant);
    }

    public void randomize() {
        this.randomizeSingleVariant("0");
        this.randomizeSingleVariant("1");
        this.randomizeSingleVariant("2");
        if (this.getPhenotype("frame") == 2) {
            this.setGene("frame", 1);
        }
        if (this.getPhenotype("dominant_white") == 2) {
            this.setGene("KIT", 15);
        }
        this.setHorseVariant(this.field_70146_Z.nextInt(), "speed");
        this.setHorseVariant(this.field_70146_Z.nextInt(), "jump");
        this.setHorseVariant(this.field_70146_Z.nextInt(), "health");
        this.setHorseVariant(this.field_70146_Z.nextInt(), "random");
        this.useGeneticAttributes();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.randomize();
        return spawnDataIn;
    }

    public static class HerdData
    implements ILivingEntityData {
        public int variant;

        public HerdData(int variantIn) {
            this.variant = variantIn;
        }
    }
}

