/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.HorseArmorLayer;
import sekelsta.horse_colors.HorseGeneticEntity;
import sekelsta.horse_colors.HorseGeneticModel;

@OnlyIn(value=Dist.CLIENT)
public class HorseGeneticRenderer
extends MobRenderer<HorseGeneticEntity, HorseGeneticModel<HorseGeneticEntity>> {
    private final float scale;
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    protected void preRenderCallback(HorseGeneticEntity entitylivingbaseIn, float partialTickTime) {
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        super.func_77041_b((LivingEntity)entitylivingbaseIn, partialTickTime);
    }

    public HorseGeneticRenderer(EntityRendererManager renderManager) {
        super(renderManager, new HorseGeneticModel(), 0.75f);
        this.scale = 1.1f;
        this.func_177094_a(new HorseArmorLayer((IEntityRenderer<HorseGeneticEntity, HorseGeneticModel<HorseGeneticEntity>>)this));
    }

    protected ResourceLocation getEntityTexture(HorseGeneticEntity entity) {
        String s = entity.getHorseTexture();
        ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new LayeredTexture(entity.getVariantTexturePaths()));
            LAYERED_LOCATION_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }
}

