/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.genetics.Genome;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.renderer.TextureLayer;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="horse_colors", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HorseDebug {
    public static boolean showDebug(PlayerEntity player) {
        if (!((Boolean)HorseConfig.Common.horseDebugInfo.get()).booleanValue()) {
            return false;
        }
        ItemStack itemStack = player.func_184592_cb();
        return itemStack != null && itemStack.func_77973_b() == Items.field_151055_y;
    }

    public static ArrayList<String> debugNamedGenes(Genome genome) {
        ArrayList<String> list = new ArrayList<String>();
        for (String gene : genome.listGenes()) {
            String s = gene + ": ";
            s = s + genome.getAllele(gene, 0) + ", ";
            s = s + genome.getAllele(gene, 1);
            list.add(s);
        }
        return list;
    }

    public static ArrayList<String> debugStatGenes(Genome genome) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> iterator = genome.listGenericChromosomes().iterator();
        while (iterator.hasNext()) {
            String stat;
            String s = stat = iterator.next();
            s = s + ": " + genome.countBits(genome.getChromosome(stat));
            s = s + " (";
            int val = genome.getChromosome(stat);
            for (int i = 16; i > 0; --i) {
                s = s + (val >>> 2 * i - 1 & 1);
                s = s + (val >>> 2 * i - 2 & 1);
                if (i <= 1) continue;
                s = s + " ";
            }
            s = s + ")";
            list.add(s);
        }
        return list;
    }

    private void addSubStats(Genome genome, List<String> list) {
        Iterator<String> iterator = genome.listStats().iterator();
        while (iterator.hasNext()) {
            String stat;
            String s = stat = iterator.next();
            s = s + ": " + genome.getStatValue(stat);
            s = s + " (";
            int val = genome.getRawStat(stat);
            for (int i = 16; i > 0; --i) {
                s = s + (val >>> 2 * i - 1 & 1);
                s = s + (val >>> 2 * i - 2 & 1);
                if (i <= 1) continue;
                s = s + " ";
            }
            s = s + ")";
            list.add(s);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderOverlayEvent(RenderGameOverlayEvent.Text event) {
        RayTraceResult mouseOver;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (HorseDebug.showDebug((PlayerEntity)player) && (mouseOver = Minecraft.func_71410_x().field_71476_x) != null && mouseOver instanceof EntityRayTraceResult && ((EntityRayTraceResult)mouseOver).func_216348_a() != null && ((EntityRayTraceResult)mouseOver).func_216348_a() instanceof IGeneticEntity) {
            IGeneticEntity entity = (IGeneticEntity)((EntityRayTraceResult)mouseOver).func_216348_a();
            for (String s : HorseDebug.debugStatGenes(entity.getGenes())) {
                event.getLeft().add(s);
            }
            if (entity instanceof AgeableEntity) {
                event.getLeft().add("Growing age: " + ((AgeableEntity)entity).func_70874_b());
            }
            if (entity instanceof HorseGeneticEntity) {
                event.getLeft().add("Display age: " + ((HorseGeneticEntity)entity).getDisplayAge());
            }
            for (TextureLayer l : entity.getGenes().getVariantTexturePaths()) {
                if (l == null) continue;
                event.getLeft().add(l.toString());
            }
            for (String s : HorseDebug.debugNamedGenes(entity.getGenes())) {
                event.getRight().add(s);
            }
        }
    }
}

