/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.ReadBookScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.genetics.Genome;

@OnlyIn(value=Dist.CLIENT)
public class GeneBookScreen
extends Screen {
    private static final int linesPerPage = 15;
    Genome genome;
    int currPage = 0;
    private ChangePageButton buttonNextPage;
    private ChangePageButton buttonPreviousPage;
    private final boolean pageTurnSounds = true;

    public GeneBookScreen(Genome genomeIn) {
        super(NarratorChatListener.field_216868_a);
        this.genome = genomeIn;
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        this.setFocused(null);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(ReadBookScreen.field_214167_b);
        int i = (this.width - 192) / 2;
        int j = 2;
        this.blit(i, 2, 0, 0, 192, 192);
        String s4 = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.getPageCount()});
        String s5 = this.getCurrPageText();
        int j1 = this.getTextWidth(s4);
        this.font.func_211126_b(s4, (float)(i - j1 + 192 - 44), 18.0f, 0);
        this.font.func_78279_b(s5, i + 36, 32, 114, 0);
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    protected void init() {
        this.addDoneButton();
        this.addChangePageButtons();
    }

    protected void addDoneButton() {
        this.addButton((Widget)new Button(this.width / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), p_214161_1_ -> this.minecraft.func_147108_a((Screen)null)));
    }

    protected void addChangePageButtons() {
        int i = (this.width - 192) / 2;
        int j = 2;
        this.buttonNextPage = (ChangePageButton)this.addButton((Widget)new ChangePageButton(i + 116, 159, true, p_214159_1_ -> this.nextPage(), this.pageTurnSounds));
        this.buttonPreviousPage = (ChangePageButton)this.addButton((Widget)new ChangePageButton(i + 43, 159, false, p_214158_1_ -> this.previousPage(), this.pageTurnSounds));
        this.updateButtons();
    }

    private int getPageCount() {
        return (int)Math.ceil((float)this.genome.humanReadableNamedGenes(false).size() / 15.0f);
    }

    protected void previousPage() {
        if (this.currPage > 0) {
            --this.currPage;
        }
        this.updateButtons();
    }

    protected void nextPage() {
        if (this.currPage < this.getPageCount() - 1) {
            ++this.currPage;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.visible = this.currPage < this.getPageCount() - 1;
        this.buttonPreviousPage.visible = this.currPage > 0;
    }

    private String getCurrPageText() {
        int start = this.currPage * 15;
        int max = this.genome.humanReadableNamedGenes(false).size();
        String s = "";
        for (int i = start; i < start + 15 && i < max; ++i) {
            s = s + this.genome.humanReadableNamedGenes(false).get(i) + "\n";
        }
        return s;
    }

    private int getTextWidth(String text) {
        return this.font.func_78256_a(this.font.func_78260_a() ? this.font.func_147647_b(text) : text);
    }
}

