/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class HorseConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final Common COMMON = new Common(BUILDER);
    public static final Spawn SPAWN = new Spawn(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class Spawn {
        public static ForgeConfigSpec.BooleanValue blockVanillaHorseSpawns;
        public static ForgeConfigSpec.IntValue minHerdSize;
        public static ForgeConfigSpec.IntValue maxHerdSize;
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> spawnBiomeWeights;
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> excludeBiomes;

        Spawn(ForgeConfigSpec.Builder builder) {
            builder.comment("Horse spawning settings").push("spawn");
            blockVanillaHorseSpawns = builder.comment(new String[]{"If set to true, only horses created by this mod will spawn.", "This mainly affects newly generated areas."}).translation("horse_colors.config.spawn.blockVanillaHorseSpawns").define("blockVanillaHorseSpawns", true);
            minHerdSize = builder.comment("What size groups horses will spawn in").translation("horse_colors.config.spawn.minHerdSize").defineInRange("minHerdSize", 2, 0, Integer.MAX_VALUE);
            maxHerdSize = builder.comment("").translation("horse_colors.config.spawn.maxHerdSize").defineInRange("maxHerdSize", 6, 0, Integer.MAX_VALUE);
            spawnBiomeWeights = builder.comment("A list of biomes horses can spawn in, and how often they spawn there.").defineList("spawnBiomeWeights", Arrays.asList(new BiomeWeight(BiomeDictionary.Type.PLAINS.toString(), 5).toString(), new BiomeWeight(BiomeDictionary.Type.SAVANNA.toString(), 1).toString()), BiomeWeight::isValid);
            excludeBiomes = builder.comment(new String[]{"A list of biome types that should not spawn horses.", "For instance, set to [\"MOUNTAIN\", \"HILLS\", \"PLATEAU\"]", "to prevent horses from spawning in non-flat biomes."}).defineList("excludeBiomes", Arrays.asList(new String[0]), o -> BiomeDictionary.Type.getAll().contains(BiomeWeight.getType(String.valueOf(o))));
            builder.pop();
        }

        public static class BiomeWeight {
            public int weight;
            public String biome;

            BiomeWeight(String b, int w) {
                this.biome = b;
                this.weight = w;
            }

            public BiomeWeight(String s) {
                s = s.trim();
                int comma = s.indexOf(",");
                String rawBiome = s.substring(0, comma);
                this.biome = rawBiome.trim();
                String rawWeight = s.substring(comma + 1, s.length());
                this.weight = Integer.parseInt(rawWeight.trim());
            }

            public String toString() {
                return this.biome + ", " + String.valueOf(this.weight);
            }

            public static boolean isValid(Object o) {
                if (!(o instanceof String)) {
                    return false;
                }
                String s = (String)o;
                if ((s = s.trim()).length() < 3) {
                    System.out.println(s + " not valid: Too short");
                    return false;
                }
                int comma = s.indexOf(",");
                if (comma == -1) {
                    System.out.println(s + " not valid: No comma");
                    return false;
                }
                String rawBiome = s.substring(0, comma);
                String rawWeight = s.substring(comma + 1, s.length());
                rawWeight = rawWeight.trim();
                try {
                    int weight = Integer.parseInt(rawWeight);
                    if (weight < 0) {
                        System.out.println(s + " not valid: Negative weight" + rawWeight);
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println(s + " not valid: Unparseable weight" + rawWeight);
                    return false;
                }
                if (BiomeWeight.getType(rawBiome) == null) {
                    System.out.println(s + "not valid: " + rawBiome + " is not a biome type. Make sure you enter a biome type, not a biome.");
                }
                return BiomeWeight.getType(rawBiome) != null;
            }

            public static BiomeDictionary.Type getType(String s) {
                for (BiomeDictionary.Type biome : BiomeDictionary.Type.getAll()) {
                    if (s.compareToIgnoreCase(biome.toString()) != 0) continue;
                    return biome;
                }
                return null;
            }
        }
    }

    public static class Common {
        public static ForgeConfigSpec.BooleanValue useGeneticStats;
        public static ForgeConfigSpec.BooleanValue enableHealthEffects;
        public static ForgeConfigSpec.BooleanValue horseDebugInfo;
        public static ForgeConfigSpec.DoubleValue mutationChance;
        public static ForgeConfigSpec.BooleanValue enableGroundTie;
        public static ForgeConfigSpec.IntValue yearLength;
        public static ForgeConfigSpec.DoubleValue maxAge;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            useGeneticStats = builder.comment(new String[]{"If enabled, horses' speed, jump, and health will be determined", "through genetics instead of the default Minecraft way"}).translation("horse_colors.config.common.useGeneticStats").define("useGeneticStats", false);
            enableHealthEffects = builder.comment(new String[]{"If enabled, certain genes will have a small impact on health,", "as they do in real life. This does not prevent Overo Lethal", "White Syndrome."}).translation("horse_colors.config.common.enableHealthEffects").define("enableHealthEffects", true);
            enableGroundTie = builder.comment("If enabled, horses will not wander off if they are wearing a saddle.").translation("horse_colors.config.common.enableGroundTie").define("enableGroundTie", false);
            horseDebugInfo = builder.comment(new String[]{"If enabled, debugging information will appear on the screen when the", "player is holding a stick in their left hand and looks at a horse.", "For most users, it is probably better to leave this as false."}).translation("horse_colors.config.common.horseDebugInfo").define("horseDebugInfo", false);
            mutationChance = builder.comment(new String[]{"The chance for each allele to mutate.", "There are at least 80 genes, each with 2 alleles, and each mutation", "has about half a chance of having no effect, so with the default", "value of 0.0005, each foal has a 5% chance of having at least", "one mutation. For mutationChance = 0.001, that chance becomes about 7%,", "and for mutationChance = 0.01 a foal has about a 45% chance of having at", "least one mutation. Any higher is not recommended.", "To disable mutations, set this value to 0."}).defineInRange("mutationChance", 5.0E-4, 0.0, 1.0);
            yearLength = builder.comment(new String[]{"How long a year lasts in ticks, for the purposes of graying.", "The default 24000 ticks is one minecraft day."}).defineInRange("yearLength", 24000, 1, 0x1FFFFF);
            maxAge = builder.comment("How many years a horse will age, for the purposes of graying.").defineInRange("maxAge", 15.0, 0.0, 25.0);
            builder.pop();
        }
    }
}

