/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import java.util.Random;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.ai.RandomWalkGroundTie;
import sekelsta.horse_colors.genetics.HorseGenome;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.item.GeneBookItem;

public abstract class AbstractHorseGenetic
extends AbstractChestedHorseEntity
implements IGeneticEntity {
    protected HorseGenome genes;
    protected static final DataParameter<Integer> HORSE_VARIANT = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_VARIANT2 = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_VARIANT3 = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_SPEED = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_JUMP = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_HEALTH = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HORSE_RANDOM = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> DISPLAY_AGE = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected int trueAge;

    public AbstractHorseGenetic(EntityType<? extends AbstractHorseGenetic> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    @Override
    public HorseGenome getGenes() {
        return this.genes;
    }

    @Override
    public Random getRand() {
        return this.field_70146_Z;
    }

    public abstract boolean fluffyTail();

    public abstract boolean longEars();

    public abstract boolean thinMane();

    @Override
    public abstract GeneBookItem.Species getSpecies();

    public boolean canEquipChest() {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorseEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0, AbstractHorseEntity.class));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkGroundTie((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.func_205714_dM();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HORSE_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_VARIANT2, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_VARIANT3, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_SPEED, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_HEALTH, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_JUMP, (Object)0);
        this.field_70180_af.func_187214_a(HORSE_RANDOM, (Object)0);
        this.field_70180_af.func_187214_a(DISPLAY_AGE, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getChromosome("0"));
        compound.func_74768_a("Variant2", this.getChromosome("1"));
        compound.func_74768_a("Variant3", this.getChromosome("2"));
        compound.func_74768_a("SpeedGenes", this.getChromosome("speed"));
        compound.func_74768_a("JumpGenes", this.getChromosome("jump"));
        compound.func_74768_a("HealthGenes", this.getChromosome("health"));
        compound.func_74768_a("Random", this.getChromosome("random"));
        compound.func_74768_a("true_age", this.trueAge);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setChromosome("0", compound.func_74762_e("Variant"));
        this.setChromosome("1", compound.func_74762_e("Variant2"));
        this.setChromosome("2", compound.func_74762_e("Variant3"));
        this.setChromosome("speed", compound.func_74762_e("SpeedGenes"));
        this.setChromosome("jump", compound.func_74762_e("JumpGenes"));
        this.setChromosome("health", compound.func_74762_e("HealthGenes"));
        this.setChromosome("random", compound.func_74762_e("Random"));
        this.trueAge = compound.func_74762_e("true_age");
        this.func_110232_cE();
    }

    public int getDisplayAge() {
        return (Integer)this.field_70180_af.func_187225_a(DISPLAY_AGE);
    }

    public void setDisplayAge(int age) {
        this.field_70180_af.func_187227_b(DISPLAY_AGE, (Object)age);
    }

    @Override
    public void setChromosome(String name, int variant) {
        switch (name) {
            case "0": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT, (Object)variant);
                this.getGenes().resetTexture();
                return;
            }
            case "1": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT2, (Object)variant);
                this.getGenes().resetTexture();
                return;
            }
            case "2": {
                this.field_70180_af.func_187227_b(HORSE_VARIANT3, (Object)variant);
                this.getGenes().resetTexture();
                return;
            }
            case "speed": {
                this.field_70180_af.func_187227_b(HORSE_SPEED, (Object)variant);
                this.useGeneticAttributes();
                return;
            }
            case "jump": {
                this.field_70180_af.func_187227_b(HORSE_JUMP, (Object)variant);
                this.useGeneticAttributes();
                return;
            }
            case "health": {
                this.field_70180_af.func_187227_b(HORSE_HEALTH, (Object)variant);
                this.useGeneticAttributes();
                return;
            }
            case "random": {
                this.field_70180_af.func_187227_b(HORSE_RANDOM, (Object)variant);
                break;
            }
            default: {
                System.out.print("Unrecognized horse data for setting: " + name + "\n");
            }
        }
    }

    @Override
    public int getChromosome(String name) {
        switch (name) {
            case "0": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT);
            }
            case "1": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT2);
            }
            case "2": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_VARIANT3);
            }
            case "speed": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_SPEED);
            }
            case "jump": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_JUMP);
            }
            case "health": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_HEALTH);
            }
            case "random": {
                return (Integer)this.field_70180_af.func_187225_a(HORSE_RANDOM);
            }
        }
        System.out.print("Unrecognized horse data for getting: " + name + "\n");
        return 0;
    }

    protected void useGeneticAttributes() {
        if (((Boolean)HorseConfig.Common.useGeneticStats.get()).booleanValue()) {
            HorseGenome genes = this.getGenes();
            float healthStat = genes.getStatValue("health1") + genes.getStatValue("health2") + genes.getStatValue("health3") + genes.getStatValue("stamina");
            float maxHealth = 15.0f + healthStat * 0.5f;
            float speedStat = genes.getStatValue("speed1") + genes.getStatValue("speed2") + genes.getStatValue("speed3") + genes.getStatValue("athletics1");
            double movementSpeed = 0.1125 + (double)speedStat * 0.00703125;
            float jumpStat = genes.getStatValue("jump1") + genes.getStatValue("jump2") + genes.getStatValue("jump3") + genes.getStatValue("athletics2");
            double jumpStrength = 0.4 + (double)jumpStat * 0.01875;
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(maxHealth += this.getGenes().getBaseHealth()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(movementSpeed);
            this.func_110148_a(field_110271_bv).func_111128_a(jumpStrength);
        } else {
            float maxHealth = this.func_110267_cL() + this.getGenes().getBaseHealth();
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.genes = new HorseGenome(this);
        float maxHealth = this.func_110267_cL() + this.getGenes().getBaseHealth();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110203_cN());
        this.func_110148_a(field_110271_bv).func_111128_a(this.func_110245_cM());
    }

    abstract AbstractHorseEntity getChild(AgeableEntity var1);

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        AbstractHorseEntity child = this.getChild(ageable);
        if (child != null) {
            this.func_190681_a(ageable, child);
        }
        if (child instanceof AbstractHorseGenetic) {
            if (((AbstractHorseGenetic)child).getGenes().isEmbryonicLethal()) {
                return null;
            }
            ((AbstractHorseGenetic)child).useGeneticAttributes();
        }
        return child;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.getGenes().resetTexture();
        }
        if (!this.field_70170_p.field_72995_K && this.getGenes().clientNeedsAge()) {
            this.trueAge = this.field_175504_a < 0 ? this.field_175504_a : Math.max(0, this.trueAge + 1);
            int c = 400;
            if (this.trueAge / 400 != this.getDisplayAge() / 400) {
                this.setDisplayAge(this.trueAge);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
        if (this.getGenes().isLethalWhite() && this.field_70173_aa > 80) {
            if (!this.func_70644_a(Effects.field_76436_u)) {
                this.func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 3));
            }
            if (this.func_110143_aJ() < 2.0f) {
                this.func_195064_c(new EffectInstance(Effects.field_76433_i, 1, 3));
            }
        }
    }
}

