/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.entity.DonkeyGeneticEntity;
import sekelsta.horse_colors.init.ModEntities;
import sekelsta.horse_colors.item.GeneBookItem;
import sekelsta.horse_colors.util.Util;

public class HorseGeneticEntity
extends AbstractHorseGenetic {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");

    public HorseGeneticEntity(EntityType<? extends HorseGeneticEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compound.func_218657_a("ArmorItem", (INBT)this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        if (compound.func_150297_b("ArmorItem", 10) && !(itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(itemstack)) {
            this.field_110296_bG.func_70299_a(1, itemstack);
        }
        this.func_110232_cE();
    }

    public ItemStack getHorseArmor() {
        return this.func_184582_a(EquipmentSlotType.CHEST);
    }

    private void setHorseArmor(ItemStack itemstack) {
        this.func_184201_a(EquipmentSlotType.CHEST, itemstack);
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    protected void func_110232_cE() {
        super.func_110232_cE();
        this.setHorseArmorStack(this.field_110296_bG.func_70301_a(1));
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    private void setHorseArmorStack(ItemStack itemstack) {
        this.setHorseArmor(itemstack);
        if (!this.field_70170_p.field_72995_K) {
            int i;
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(ARMOR_MODIFIER_UUID);
            if (itemstack.func_77973_b() instanceof HorseArmorItem && (i = ((HorseArmorItem)itemstack.func_77973_b()).func_219977_e()) != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION).func_111168_a(false));
            }
        }
    }

    public void func_76316_a(IInventory invBasic) {
        ItemStack itemstack = this.getHorseArmor();
        super.func_76316_a(invBasic);
        ItemStack itemstack1 = this.getHorseArmor();
        if (this.field_70173_aa > 20 && this.func_190682_f(itemstack1) && itemstack != itemstack1) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
    }

    protected void func_190680_a(SoundType p_190680_1_) {
        super.func_190680_a(p_190680_1_);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, p_190680_1_.func_185843_a() * 0.6f, p_190680_1_.func_185847_b());
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        ItemStack stack = this.field_110296_bG.func_70301_a(1);
        if (this.func_190682_f(stack)) {
            stack.onHorseArmorTick(this.field_70170_p, (MobEntity)this);
        }
    }

    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187717_cr;
    }

    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    @Override
    public boolean fluffyTail() {
        return true;
    }

    @Override
    public boolean longEars() {
        return false;
    }

    @Override
    public boolean thinMane() {
        return false;
    }

    @Override
    public boolean canEquipChest() {
        return false;
    }

    @Override
    public GeneBookItem.Species getSpecies() {
        return GeneBookItem.Species.HORSE;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof DonkeyGeneticEntity || otherAnimal instanceof HorseGeneticEntity || otherAnimal instanceof DonkeyEntity || otherAnimal instanceof HorseEntity) {
            return this.func_110200_cJ() && Util.horseCanMate((AbstractHorseEntity)otherAnimal);
        }
        return false;
    }

    @Override
    public AbstractHorseEntity getChild(AgeableEntity ageable) {
        if (ageable instanceof AbstractHorseGenetic) {
            AbstractHorseGenetic child = null;
            AbstractHorseGenetic other = (AbstractHorseGenetic)ageable;
            if (ageable instanceof HorseGeneticEntity) {
                child = (AbstractHorseGenetic)ModEntities.HORSE_GENETIC.func_200721_a(this.field_70170_p);
            } else if (ageable instanceof DonkeyGeneticEntity) {
                child = (AbstractHorseGenetic)ModEntities.MULE_GENETIC.func_200721_a(this.field_70170_p);
            }
            child.getGenes().inheritGenes(this.getGenes(), other.getGenes());
            return child;
        }
        if (ageable instanceof HorseEntity) {
            HorseEntity child = (HorseEntity)EntityType.field_200762_B.func_200721_a(this.field_70170_p);
            child.func_110235_q(((HorseEntity)ageable).func_110202_bQ());
            return child;
        }
        if (ageable instanceof DonkeyEntity) {
            return (AbstractHorseEntity)EntityType.field_200779_S.func_200721_a(this.field_70170_p);
        }
        return null;
    }

    public boolean func_190677_dK() {
        return true;
    }

    public boolean func_190682_f(ItemStack stack) {
        return stack.func_77973_b() instanceof HorseArmorItem || stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof CarpetBlock;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.getGenes().randomize();
        this.useGeneticAttributes();
        return spawnDataIn;
    }
}

